#include "Jukebox.h"
#include "Config.h"

Jukebox *music;

Jukebox::Jukebox() {
	music[0].OpenFromFile("data/music/guitar01.ogg");
	music[1].OpenFromFile("data/music/guitar02.ogg");
	music[0].SetLoop(true);
	music[1].SetLoop(true);
	playing=-1;
	
	buffers[esnd_engine].LoadFromFile("data/sound/engine.wav");
	buffers[esnd_hit].LoadFromFile("data/sound/hit.wav");
	buffers[esnd_rain].LoadFromFile("data/sound/rain.wav");
	buffers[esnd_fans].LoadFromFile("data/sound/crowd.wav");
	buffers[esnd_pasto].LoadFromFile("data/sound/pasto.wav");
	buffers[esnd_marca].LoadFromFile("data/sound/marca.wav");
	buffers[esnd_crash].LoadFromFile("data/sound/crash.wav");
	buffers[esnd_selok].LoadFromFile("data/sound/selok.wav");
	buffers[esnd_selcancel].LoadFromFile("data/sound/selcancel.wav");
	buffers[esnd_selmove].LoadFromFile("data/sound/selmove.wav");
//	for (int i=0;i<snd_count;i++) sounds[i].SetBuffer(buffers[i]);
	snd_rain.SetBuffer(buffers[esnd_rain]);
	snd_pasto.SetBuffer(buffers[esnd_pasto]);
	snd_marca.SetBuffer(buffers[esnd_marca]);
	snd_selok.SetBuffer(buffers[esnd_selok]);
	snd_selcancel.SetBuffer(buffers[esnd_selcancel]);
	snd_selmove.SetBuffer(buffers[esnd_selmove]);
	snd_rain.SetLoop(true);
	snd_pasto.SetLoop(true);
	snd_marca.SetLoop(true);
	really_playing=false;
	
	SetVolumes();
}

void Jukebox::PlayMusic(){
	if (!config->music_on) return;
	if (really_playing) return;
	if (playing<0) {
		music[playing=rand()%2].SetVolume(100*vol_music);
		music[playing].Play();
	} else {
		music[playing].Play();
		Clock c; real t;
		do {
			t=c.GetElapsedTime();
			music[playing].SetVolume((t*200*vol_music)*vol_music);
		} while (t<.5);
	}
	really_playing=true;
}

void Jukebox::StopMusic() {
	if (playing<0) return;
	Clock c;
	real t;
	do {
		t=c.GetElapsedTime();
		music[playing].SetVolume((100-t*200)*vol_music);
	} while (t<.5);
	music[playing].Pause();
	really_playing=false;
}

void Jukebox::SetVolumes() {
	if (playing>=0) 
		music[playing].SetVolume(100*vol_music);
	snd_rain.SetVolume(100*vol_sound);
	snd_pasto.SetVolume(100*vol_sound);
	snd_marca.SetVolume(100*vol_sound);
	snd_selok.SetVolume(100*vol_sound);
	snd_selcancel.SetVolume(100*vol_sound);
	snd_selmove.SetVolume(100*vol_sound);
}
