#include "Confirm.h"
#include "MyFont.h"
#include "Config.h"
#include "Jukebox.h"
#include "Loading.h"

Confirm *confirm;

Confirm::Confirm() {
	image.LoadFromFile("data/misc/confirm.png");
	sprite.SetImage(image);
	sprite.SetCenter(image.GetWidth()/2,image.GetHeight()/2);
	sprite.SetPosition(screen_w/2-5,screen_h/2);
	sprite.SetColor(Color(255,255,255,200));
}

void Confirm::Fade(Drawer *parent, bool on) {
	if (!config->extra_fx) {
		sprite.SetScale(fw,fh);
		return;
	}
	if (on) {
		real h=0;
		while (h<1) {
			h+=.2;
			sprite.SetScale(h*fw,h*fh);
			parent->Draw();
			App->Draw(sprite);
			App->TimedDisplay();
		}
	} else {
		real h=1;
		do {
			sprite.SetScale(h*fw,h*fh);
			parent->Draw();
			App->Draw(sprite);
			App->TimedDisplay();
			h-=.2;
		} while (h>0);
	}
}

bool Confirm::Ask(Drawer *parent, const char *what) {
	fw=1;fh=1;
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	selok=true;
	sel_yes=sel_no=0;
	Fade(parent,true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			if (config->sound_on) music->snd_selcancel.Play();
			last_key=sf::Key::Escape; Fade(parent,false); return false; 
		} } else if (App->GetInput().IsKeyDown(sf::Key::Return)) { if (last_key!=sf::Key::Return) {
			if (config->sound_on) music->snd_selok.Play();
			last_key=sf::Key::Return; Fade(parent,false); return selok;
		} } else if(App->GetInput().IsKeyDown(sf::Key::Left)) { if (last_key!=sf::Key::Left) {
			selok=false; last_key=sf::Key::Left;
		} } else if(App->GetInput().IsKeyDown(sf::Key::Right)) { if (last_key!=sf::Key::Right) {
			selok=true; last_key=sf::Key::Right;
		} } else {
			last_key=sf::Key::Count;
		}
		parent->Draw();
		App->Draw(sprite);
		font->RenderCenter(
			screen_w/2,screen_h/2-20,
			.5,what);

		if (selok) {
			if (sel_yes<1) sel_yes+=.2;
			if (sel_no>0) sel_no-=.2;
		} else {
			if (sel_yes>0) sel_yes-=.2;
			if (sel_no<1) sel_no+=.2;
		}
		
		font->RenderCenter(
			screen_w/2-50,screen_h/2+40+sel_no*5,
			.5+.3*sel_no,config->spanish?"No":"No");
		
		font->RenderCenter(
			screen_w/2+50,screen_h/2+40+sel_yes*5,
			.5+.3*sel_yes,config->spanish?"Si":"Yes");
		
		App->TimedDisplay();
	}
	return false;
}

void Confirm::Tell(Drawer *parent, const char *what1, const char *what2) {
	fw=fh=1;
//	FloatRect rect(0,0,screen_w,screen_h);
//	view->SetFromRect(rect);
//	App->SetView(*view);
	Fade(parent,true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				if (config->sound_on) music->snd_selcancel.Play();
				last_key=sf::Key::Escape; Fade(parent,false); return; 
			} else if (App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				if (config->sound_on) music->snd_selok.Play();
				last_key=sf::Key::Return; Fade(parent,false); return;
			} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
				last_key=sf::Key::Count;
			}
		}
		parent->Draw();
		App->Draw(sprite);
		font->RenderCenter(screen_w/2,screen_h/2-10,.5,what1);
		font->RenderCenter(screen_w/2,screen_h/2+30,.5,what2);

		App->TimedDisplay();
	}
	return;
}

void Confirm::Tell2(Drawer *parent, const char *what1, const char *what2) {
	fw=1.65; fh=1;
//	FloatRect rect(0,0,screen_w,screen_h);
//	view->SetFromRect(rect);
//	App->SetView(*view);
	Fade(parent,true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				if (config->sound_on) music->snd_selcancel.Play();
				last_key=sf::Key::Escape; Fade(parent,false); return; 
			} else if (App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				if (config->sound_on) music->snd_selok.Play();
				last_key=sf::Key::Return; Fade(parent,false); return;
			} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
				last_key=sf::Key::Count;
			}
		}
		
		parent->Draw();
		App->Draw(sprite);
		font->RenderCenter(screen_w/2,screen_h/2-10,.5,what1);
		font->RenderCenter(screen_w/2,screen_h/2+30,.5,what2);

		App->TimedDisplay();
	}
	return;
}

string Confirm::Input(Drawer *parent, const char *what) {
	string text;
	int f;
	bool down[256];
	fw=1; fh=1;
//	FloatRect rect(0,0,screen_w,screen_h);
//	view->SetFromRect(rect);
//	App->SetView(*view);
	string text2;
	Fade(parent,true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			if (config->sound_on) music->snd_selcancel.Play();
			last_key=sf::Key::Escape; Fade(parent,false); return ""; 
		} } else if (App->GetInput().IsKeyDown(sf::Key::Return)) { if (last_key!=sf::Key::Return) {
			if (config->sound_on) music->snd_selok.Play();
			last_key=sf::Key::Return; if (text.size()) Fade(parent,false); return text;
		} } else if (App->GetInput().IsKeyDown(sf::Key::Back)) { if (last_key!=sf::Key::Back) {
			last_key=sf::Key::Back; if (text.size()) text=text.substr(0,text.size()-1);
		} } else if (App->GetInput().IsKeyDown(sf::Key::Add)) { if (last_key!=sf::Key::Add) {
			text+='+'; last_key=Key::Add;
		} } else if (App->GetInput().IsKeyDown(sf::Key::Subtract)) { if (last_key!=sf::Key::Subtract) {
			text+='-'; last_key=Key::Subtract;
		} } else if (App->GetInput().IsKeyDown(sf::Key::Space)) { if (last_key!=sf::Key::Space) {
			text+=' '; last_key=Key::Space;
		} } else  {
			last_key=Key::Count;
			for (int i=sf::Key::A,c='a';i<=sf::Key::Z;i++,c++) {
				if (App->GetInput().IsKeyDown((Key::Code)i)) {
					if (!down[int(c)]) {
						down[int(c)]=true; 
						if (App->GetInput().IsKeyDown(sf::Key::LShift) || App->GetInput().IsKeyDown(sf::Key::RShift))
							text+=c+('A'-'a');
						else
							text+=c;
					}
				} else
					down[int(c)]=false;
			}
			for (int i=sf::Key::Num0,c='0';i<=sf::Key::Num9;i++,c++) {
				if (App->GetInput().IsKeyDown((Key::Code)i)) {
					if (!down[int(c)]) {
						text+=c; down[int(c)]=true;
					}
				} else
					down[int(c)]=false;
			}
		}
		
		while (font->Ancho(text.c_str(),.7)>220)
			text=text.substr(0,text.size()-1);
		
		parent->Draw();
		App->Draw(sprite);
		font->RenderCenter(screen_w/2,screen_h/2-20,.5,what);
		
//		if (text2.size()!=text.size()+1) {
			/*f=0; */text2=text+((((f++)/5)%2)?"|":" ");
//		}
		
//		if (((f++)/5)%2) {
//			if (text.size())
//				font->RenderCenter(screen_w/2,screen_h/2+40,.7,text.c_str());
//		} else
			font->RenderCenter(screen_w/2,screen_h/2+40,.7,text2.c_str());
		
		
		App->TimedDisplay();
	}
	return "";
}

void Confirm::ShowBuilding(int reset) {
	if (!reset) ibuild=3; else ibuild+=reset;
	fw=config->spanish?1.8:1.6; fh=1.4;
	if (!reset) Fade(black,true);
	App->Clear(Color(0,0,0,255));
	App->Draw(sprite);
	font->RenderCenter(screen_w/2,screen_h/2-30,.5,config->spanish?"Construyendo imagenes del circuito. Esta":"Building track images. Please wait");
	font->RenderCenter(screen_w/2,screen_h/2+10,.5,config->spanish?"espera es necesaria solo una vez por":"It have to be done once per track.");
	font->RenderSmall(screen_w/2-170,screen_h/2+50,.5,(string(config->spanish?"circuito.":"Working")+string(ibuild,'.')).c_str());
	App->Display();
	sf::Event event;
	while(App->GetEvent(event));
}

int Confirm::KeyFor(Drawer *parent, const char *what1, const char *what2) {
	fw=1.6; fh=1;
	Fade(parent,true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			int key=Key::Count;
			if(event.Type == event.Closed)
				App->Close();
			for (int i='0';i<='9';i++) 
				if (last_key!=i && App->GetInput().IsKeyDown((Key::Code)i))
				{ key=i; last_key=(Key::Code)i; }
			for (int i='a';i<='z';i++) 
				if (last_key!=i && App->GetInput().IsKeyDown((Key::Code)i))
				{ key=i; last_key=(Key::Code)i; }
			for (int i=256;i<Key::Count;i++) 
				if (last_key!=i && App->GetInput().IsKeyDown((Key::Code)i))
				{ key=i; last_key=(Key::Code)i; }
			if (key!=Key::Count) {
				if (key==Key::Escape) {
					if (config->sound_on) music->snd_selcancel.Play();
					Fade(parent,false); return Key::Escape;
				} else {
					if (config->sound_on) music->snd_selok.Play();
					Fade(parent,false); return key;
				}
			} else last_key=Key::Count;
		}
		parent->Draw();
		App->Draw(sprite);
		font->RenderCenter(screen_w/2,screen_h/2-10,.5,what1);
		font->RenderCenter(screen_w/2,screen_h/2+30,.5,what2);
		
		App->TimedDisplay();
	}
	return Key::Escape;
}

bool Confirm::JoyFor(Drawer *parent, const char *what1, const char *what2, const char *what3, int joy_num, bool &is_button, int &joy_button) {
	fw=1.5; fh=1.2;
	Fade(parent,true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			joy_button=0;
			if(event.Type == event.Closed)
				App->Close();
			for (int i=0;i<=10;i++) {
				if (App->GetInput().GetJoystickAxis(joy_num-1,(Joy::Axis)i)<-25) {
					is_button=false;
					joy_button=-i-1;
				} else if (App->GetInput().GetJoystickAxis(joy_num-1,(Joy::Axis)i)>25) {
					is_button=false;
					joy_button=i+1;
				}
			}
			for (int i=0;i<=32;i++) 
				if (last_key!=i && App->GetInput().IsJoystickButtonDown(joy_num-1,i)) {
					is_button=true;
					joy_button=i+1;
				}
			if (App->GetInput().IsKeyDown(Key::Escape)) {
				last_key=Key::Escape; return false;
			}
			if (joy_button) return true;
		}
		parent->Draw();
		App->Draw(sprite);
		font->RenderCenter(screen_w/2,screen_h/2-30,.5,what1);
		font->RenderCenter(screen_w/2,screen_h/2+10,.5,what2);
		font->RenderCenter(screen_w/2,screen_h/2+50,.5,what3);
		
		App->TimedDisplay();
	}
	return Key::Escape;
}
