#include "Circuito.h"
#include "Jukebox.h"
#include "Data.h"
#include "Loading.h"
#include "Confirm.h"
#include "MakeData.h"
#include "Profile.h"
#include "Config.h"
#include "OSD.h"

#ifdef DEBUG
bool toggle_map=false;
#endif

Circuito *circuito;

Circuito::Circuito(int track_index) {
	CERR(this<<" Circuito::Circuito "<<track_index);
	image=NULL; sprite=NULL;
	string ftrack=data->tracks[track_index].dir+"info.map";
	if (config) load_wh(t,fix_image_file(data->tracks[track_index].dir+"thumbnail.png"),1,1);
	if (config) loading->Draw();
	best_lap=data->tracks[track_index].best_time;
	if (profile) profile->temp_best_lap=profile->best_lap[track_index];
	id=data->tracks[track_index].id;
	image_c=image_r=1; 
	scale_mapa=-1;
	rain_mode=night_mode=false; mult_color=Color(255,255,255,255);
	if (config) {
		snd_fans1.SetBuffer(music->buffers[esnd_fans]);
		snd_fans1.SetLoop(true);
		snd_fans1.SetMinDistance(100);
		snd_fans1.SetAttenuation(.2);
		snd_fans1.SetVolume(100*vol_sound);
		snd_fans2.SetBuffer(music->buffers[esnd_fans]);
		snd_fans2.SetLoop(true);
		snd_fans2.SetMinDistance(100);
		snd_fans2.SetAttenuation(.2);
		snd_fans2.SetVolume(100*vol_sound);
	}
	ifstream fil(ftrack.c_str());
	string s,k,v;
	size_t p;
	check_count=0;
	fans[0][0]=0;
	version=0;
	while (getline(fil,s)) {
		if (!s.size() || s[0]=='#') continue;
		p=s.find('=');
		if (p==string::npos) continue;
		k=s.substr(0,p);
		v=s.substr(p+1);
		if (k=="mapa"&&config) {
			loading->Draw();
			mapa.LoadFromFile(fix_image_file(data->tracks[track_index].dir+v));
		} else if (k=="minimap"&&config) {
			loading->Draw();
			imini.LoadFromFile(fix_image_file(data->tracks[track_index].dir+v));
		} else if (k=="light"&&config) {
			loading->Draw();
			light.LoadFromFile(fix_image_file(data->tracks[track_index].dir+v));
		} else if (k=="fans") {
			int i=0;
			fil>>fans[i][0]>>fans[i][1];
			while (fans[i][0]||fans[i][1]) {
				fans[i][0]=int(fans[i][0]*scale);
				fans[i][1]=int(fans[i][1]*scale);
				i++; fil>>fans[i][0]>>fans[i][1]; 
			}
//		} else if (k=="ai_route") {
//			int i=0;
//			fil>>ai_route[i][0]>>ai_route[i][1];
//			while (ai_route[i][0]||ai_route[i][1]) {
//				ai_route[i][0]=int(ai_route[i][0]*scale);
//				ai_route[i][1]=int(ai_route[i][1]*scale);
//				i++; fil>>ai_route[i][0]>>ai_route[i][1]; 
//			}
//		} else if (k=="checkpoints") {
//			int i=0;
//			fil>>checkpoints[i][0]>>checkpoints[i][1];
//			while (checkpoints[i][0]||checkpoints[i][1]) {
//				checkpoints[i][0]=int(checkpoints[i][0]*scale); 
//				checkpoints[i][1]=int(checkpoints[i][1]*scale); 
//				i++; fil>>checkpoints[i][0]>>checkpoints[i][1];
//			}
//			check_count=i;
//			checkpoints[check_count+1][0]=checkpoints[0][0];
//			checkpoints[check_count+1][1]=checkpoints[0][1];
		} else if (k=="scale") scale = atof(v.c_str());
		else if (k=="scale_mapa") scale_mapa = atof(v.c_str());
		else if (k=="scale_mini") scale_mini = atof(v.c_str());
		else if (k=="image_cols") image_c = atoi(v.c_str());
		else if (k=="image_rows") image_r = atoi(v.c_str());
		else if (k=="finish_x") finish_line[0]= atoi(v.c_str());
		else if (k=="finish_y") finish_line[1] = atoi(v.c_str());
		else if (k=="start_angle") largada_angle = atof(v.c_str())/180*M_PI;
		else if (k=="start_x") largada_x = atoi(v.c_str());
		else if (k=="start_y") largada_y = atoi(v.c_str());
		else if (k=="start_angle") largada_angle = atof(v.c_str())/180*M_PI;
		else if (k=="start_dcol") largada_dc = atoi(v.c_str());
		else if (k=="start_drow") largada_df = atoi(v.c_str());
		else if (k=="start_ncols") largada_nxf = atoi(v.c_str());
		else if (k=="version") version= atoi(v.c_str());
		else if (k=="rain") rain_mode = v=="1";
		else if (k=="night") night_mode = v=="1";
	}
	
	if (mapa.GetWidth()==0) {
		confirm->Tell2(black,
			config->spanish?"Tu pc no puede cargar grandes texturas.":"Can't load big textures. Go to",
			config->spanish?"Ve a las opciones y elije \"Baja Res\"":"options and select low textures");
		return;
	}
	
	
	ifstream fcheck((data->tracks[track_index].dir+"route.dat").c_str());
	check_count=0;
	while (fcheck
		>>checkpoints[check_count][0]
		>>checkpoints[check_count][1]
		>>checkpoints[check_count][2]
		>>checkpoints[check_count][3]
		>>checkpoints_alpha[check_count][0]
		>>checkpoints_alpha[check_count][1]
		>>checkpoints_alpha[check_count][2]) {
			if (checkpoints_alpha[check_count][2]<checkpoints_alpha[check_count][1]) {
				real lala=checkpoints_alpha[check_count][2];
				checkpoints_alpha[check_count][2]=checkpoints_alpha[check_count][1];
				checkpoints_alpha[check_count][2]=lala;
			}
			check_count++;
		}
	fcheck.close();
	for (int i=0;i<check_count;i++) {
		checkpoints[i][0]*=scale_mapa;
		checkpoints[i][1]*=scale_mapa;
		checkpoints[i][2]*=scale_mapa;
		checkpoints[i][3]*=scale_mapa;
	}
	checkpoints[check_count++][0]=0; // indica el final
	checkpoints_alpha[check_count][0]=checkpoints_alpha[0][0];
	checkpoints_alpha[check_count][1]=checkpoints_alpha[0][1];
	checkpoints_alpha[check_count][2]=checkpoints_alpha[0][2];
	checkpoints[check_count][0]=checkpoints[0][0];
	checkpoints[check_count][1]=checkpoints[0][1];
	checkpoints[check_count][2]=checkpoints[0][2];
	checkpoints[check_count][3]=checkpoints[0][3];
		
//			int i=0;
//			fil>>checkpoints[i][0]>>checkpoints[i][1];
//			while (checkpoints[i][0]||checkpoints[i][1]) {
//				checkpoints[i][0]=int(checkpoints[i][0]*scale); 
//				checkpoints[i][1]=int(checkpoints[i][1]*scale); 
//				i++; fil>>checkpoints[i][0]>>checkpoints[i][1];
//			}
//			check_count=i;
//			checkpoints[check_count+1][0]=checkpoints[0][0];
//		
	
	if (rain_mode) mult_color=Color(200,200,225,255);
	if (night_mode) mult_color=Color(100,100,100,255);
	largada_x=int(largada_x*scale); largada_y=int(largada_y*scale);
	largada_df=int(largada_df*scale); largada_dc=int(largada_dc*scale);
	if (scale_mapa<0) scale_mapa=scale;
	if (!BuildIfNeeded(track_index)) {
		confirm->Tell2(black,
			config->spanish?"Error al generar las imagenes":"Error writing track images",
			config->spanish?"disco lleno, o falta de permisos?":"May be disk space or permissions?");
		return;
	}
	if (!osd) {image=NULL; sprite=NULL; return; }
	image = new Image*[image_c];
	sprite = new Sprite*[image_c];
	string image_dir=data->tracks[track_index].dir+"t00.png";
	for (int i=0;i<image_c;i++) {
		image[i]=new Image[image_r];
		sprite[i]=new Sprite[image_r];
		image_dir[image_dir.size()-6]='0'+i;
		for (int j=0;j<image_r;j++) {
			if (config) loading->Draw();
			image_dir[image_dir.size()-5]='0'+j;
//			cerr<<image_dir<<endl;
			image[i][j].LoadFromFile(fix_image_file(image_dir));
			sprite[i][j].SetImage(image[i][j]);
			sprite[i][j].SetPosition(i*500*scale,j*500*scale); // por que 501???
			sprite[i][j].SetScale(scale*global_scale,scale*global_scale);
			sprite[i][j].SetSubRect(IntRect(0,0,506/global_scale-1,506/global_scale-1));
//			if (night_mode) sprite[i][j].SetColor(mult_color);
		}
	}
	scale_mapa*=global_scale;
	mm_x0=mapa.GetWidth()*scale_mapa/scale_mini;
	mm_y0=0;
	smini.SetImage(imini);
	smini.SetPosition(mm_x0,mm_y0);
	if (config&&config->extra_fx) smini.SetColor(Color(180,180,180,180));
#ifdef DEBUG
	msprite.SetImage(light);
	msprite.SetCenter(0,0);
	msprite.SetPosition(0,0);
	msprite.SetScale(global_scale*scale_mapa,global_scale*scale_mapa);
//	msprite.SetColor(Color(255,255,255,128));
#endif
}

int Circuito::QuePisa(real x, real y) {
	const Color &color=mapa.GetPixel(int(x/scale_mapa),int(y/scale_mapa));
	int sum=color.r+color.g+color.b;
	if (sum==255*3) return qp_track;
	if (sum==0) return qp_wall;
	if (color.b==255) {
		if (color.r==255)
			return qp_finishline|qp_leca;
		if (color.g==255)
			return qp_finishline|qp_grass;
		else 
			return qp_finishline|qp_track;
	}
	if (color.r==255) return qp_leca;
	if (color.g==255) return qp_grass;
	return qp_unknown;
}

Color Circuito::Luz(real x, real y) {
	return light.GetPixel(int(x/scale_mapa/2),int(y/scale_mapa/2));
}

pos_largada Circuito::PosLargada(int i) {
	pos_largada p;
	int f=i/largada_nxf, c=i%largada_nxf;
	real a1=largada_dc*c, a2=largada_df*f, a3=largada_df*c/1.8/largada_nxf;
	real sa=sin(largada_angle), ca=cos(largada_angle);
	p.x=largada_x-a2*sa+a1*ca-a3*sa;
	p.y=largada_y+a2*ca+a1*sa+a3*ca;
	p.a=largada_angle;
	p.r=1-(.1+c*.8/(largada_nxf-1));
	return p;
}

void Circuito::DoSounds(int x, int y) {
	int i=0, imin1=0, min1=0, imin2=0, min2=0, dx,dy,d;
	while (fans[i][0]) {
		dx=fans[i][0]-x; if (dx<0) dx=-dx;
		dy=fans[i][1]-y; if (dy<0) dy=-dy;
		d=dx*dx+dy*dy;
		if (!min1 || d<min1) { 
			imin2=imin1; min2=min1;
			imin1=i; min1=d;
		} else if (!min2 || d<min2) {
			imin2=i; min2=d;
		}
		i++;
	}
	if (config) {
		if (min1) snd_fans1.SetPosition(fans[imin1][0]-x,fans[imin1][1]-y,0);
		if (min2) snd_fans2.SetPosition(fans[imin2][0]-x,fans[imin2][1]-y,0);
	}
}

Circuito::~Circuito() {
	CERR(this<<" Circuito::~Circuito");
	DeleteSomething();
	if (config) {
		if (fans[0][0]) snd_fans1.Stop();
		if (fans[0][0] && fans[1][0]) snd_fans2.Stop();
	}
}

void Circuito::Draw(real x, real y) {
	glRotatef(20,1,0,0);
#ifdef DEBUG
//	if (toggle_map) {App->Draw(msprite); return; }
#endif
	static int i,j,bx,by,x0,y0,x1,y1;
	bx=int(x/scale/500); by=int(y/scale/500);
	x0=bx-1; x1=bx+1; y0=by-1, y1=by+1;
	if (x0<0) x0=0; if (x1>=image_c) x1=image_c-1;
	if (y0<0) y0=0; if (y1>=image_r) y1=image_r-1;
	for (i=x1;i>=x0;i--) for (j=y1;j>=y0;j--)
		App->Draw(sprite[i][j]);
//	glRotatef(-20,1,0,0);
}

void Circuito::DeleteSomething() {
	if (!image||!sprite) return;
	for (int i=0;i<image_c;i++) {
		delete [] sprite[i];
		delete [] image[i];
	}
	delete []image;
	delete []sprite;
	image=NULL;
	sprite=NULL;
}

bool Circuito::IsOk() {
	return image&&sprite&&mapa.GetWidth()>0;
}

bool Circuito::BuildIfNeeded(int track_index) {
	if (!version) return true;
	ifstream fver(fix_image_file(data->tracks[track_index].dir+"build.ver").c_str());
	if (fver.is_open()) {
		int mver; fver>>mver;
		if (mver==version) return true;
		fver.close();
	}
	if (config) confirm->ShowBuilding(0);
	return MakeData(data->tracks[track_index].dir,version);
}
