#ifndef CHAMPIONSHIPDATA_H
#include <string>
#include <cstdlib>
using namespace std;
#define CHAMPIONSHIPDATA_H

struct ChampionshipData {
	int num_races, num_bikes;
	struct cResult { // resultado de un Corredor en una Carrera
		int idx; // indice en data->bikes (se guarda asi, no como id)
		int pts; // puntos que obtuvo
	};
	struct cRace { // resultado de una carrera del campeonato
		int idx; // indice del circuito en data->tracks (se guarda el id, no el indice)
		int level; // dificulty level for this race (1-3)
		int laps; // number of laps for this race (1-50)
		cResult *results; // resultados de la carrera (NULL si no se corrio)
		cRace() { results=NULL; laps=level=0; }
		int GetPos(int idx); // busca en los resultados la posicion del corredor de moto idx
		int GetPts(int idx); // busca en los resultados los puntos del corredor de moto idx
	} *races;
	struct cBike { // datos de un corredor
		int idx; // indice en data->bikes (se guarda el id, no el indice)
		int pts; // puntos acumulados (no se guarda, se calcula)
		int brake,accel,turn,vel; // cualidades, parte random para sumar a la base del nivel (para guardar)
		cBike() { brake=rand()%5; accel=rand()%5; vel=rand()%5; turn=rand()%5; pts=0; }
	} *bikes;
	int pbike; // moto del jugador para el campeonato
	int obike; // moto del jugador fuera (por si cambio, para volver al salir)
	int races_done; // cuantas carreras ya se corrieron
	int next_race; // cual es la proxima carrera (indice en races) o -1 si ya termino
	void FindNextRace();
	int FindBike(int idx);
	void SortPositions(); // ordena bikes por puntaje
	void ProcessPositions(int laps, int level); // toma el resultado de una carrera desde el arreglo de motos
	ChampionshipData(); // nuevo campeonato
	void ResetData(); // nuevo campeonato
	ChampionshipData(string afile); // cargar de disco
	void Save();
	void Finish();
	~ChampionshipData();
};

extern ChampionshipData *championship_data;
#endif

