#ifndef BIKESELECTION_H
#define BIKESELECTION_H

#include "global.h"
#include "Drawer.h"

enum mi_bike { 
		mib_name, mib_name_value,
		mib_accel, mib_accel_value,
		mib_vel, mib_vel_value,
		mib_brake, mib_brake_value,
		mib_turn, mib_turn_value,
		mib_credits_total, mib_credits_total_value, 
		mib_credits_avail, mib_credits_avail_value,
		mib_ok, mib_count };

class BikeSelection:public Drawer {
public:

	int num_opts;
	
	int tostart;
	
	int cred_max, cred_avail;
	int cred_vel, cred_turn, cred_brake, cred_accel;
	
	declare_fade;
	
	declare_wh(g);
	declare_wh(b);
	declare_wh(r);
	declare_wh(t);
	
	Image *ibikes;
	Sprite *sbikes;
	static int target_bike;
	static real current_bike;
	
	string items[mib_count];
	unsigned int charsdone[mib_count];
	int pos[mib_count][2];
	int sel_level[mib_count];
	bool selected[mib_count+1];
	bool visible[mib_count];
	int selection;
	
	bool can_change_bike;
	
	static int laps;
	static int level;
	
	BikeSelection(bool abc);
	void Draw();
	bool Select(int anumopts);
	void Reset();
	bool SelOk();
	void SelMove(bool up);
	void SelChange(bool right);
	void LoadBikeData();
//	void Zoom();
	~BikeSelection();
};

#endif
