#include "global.h"
#include "BikeSelection.h"
#include "Data.h"
#include "MyFont.h"
#include "SelectionWheel.h"
#include <sstream>
#include "Confirm.h"
#include "Loading.h"
#include "Config.h"
#include "Profile.h"
#include "Jukebox.h"
using namespace std;

#define init_item(key,text,x,y) items[key]=text; pos[key][0]=x; pos[key][1]=y; charsdone[key]=0; sel_level[key]=0; selected[key]=false;

real BikeSelection::current_bike=0;
int BikeSelection::target_bike=0;

BikeSelection::BikeSelection(bool acb) {
	can_change_bike=acb;
	loading->Draw();
	load_fade;
	load_wh(b,fix_image_file("data/menu/bikeselback.png"),1,1);
	bsprite.SetPosition(screen_w/2,screen_h/2);
	if (config->extra_fx) {
		load_wh(g,fix_image_file("data/menu/bikeglow.png"),1,1);
		gsprite.SetCenter(gimage.GetWidth()-50/global_scale,gimage.GetHeight()/2);
		load_wh(r,fix_image_file("data/menu/bikeselref.png"),1,1);
		rsprite.SetCenter(rimage.GetWidth(),0);
		rsprite.SetPosition(screen_w,0);
		load_wh(t,fix_image_file("data/menu/bikeselside.png"),1,1);
		tsprite.SetCenter(timage.GetWidth(),0);
		tsprite.SetPosition(screen_w,0);
	}
	
	ibikes = new Image[data->bike_count];
	sbikes = new Sprite[data->bike_count];
	for (int i=0;i<data->bike_count;i++) {
		ibikes[i].LoadFromFile(fix_image_file(data->bikes[i].dir+"thumbnail.png"));
		sbikes[i].SetImage(ibikes[i]);
		sbikes[i].SetCenter(ibikes[i].GetWidth(),ibikes[i].GetHeight()/2);
	}
	
	int x2=105,x3=340,y=115;
	
	init_item(mib_name,config->spanish?"Moto: ":"Bike Name:",x2,y+0);
	init_item(mib_name_value,config->spanish?"<sinnombre>":"<noname>",x3,y+0);
	init_item(mib_accel,config->spanish?"Aceleracion:":"Acceleration:",x2,y+60);
	init_item(mib_accel_value,"<                              >",x3,y+60);
	init_item(mib_vel,config->spanish?"Max Vel.:":"Max Speed:",x2,y+110);
	init_item(mib_vel_value,"<                              >",x3,y+110);
	init_item(mib_brake,config->spanish?"Pot. Frenado:":"Brake Power:",x2,y+160);
	init_item(mib_brake_value,"<                              >",x3,y+160);
	init_item(mib_turn,config->spanish?"Fac. de Manejo:":"Handling:",x2,y+210);
	init_item(mib_turn_value,"<                              >",x3,y+210);
	init_item(mib_credits_total,config->spanish?"Puntos totales:":"Total Credits:",x2+10,y+270);
	init_item(mib_credits_total_value,"0",x3-10,y+270);
	init_item(mib_credits_avail,config->spanish?"Puntos sin usar":"Unused Credits:",x2+10,y+320);
	init_item(mib_credits_avail_value,"0",x3-10,y+320);
	init_item(mib_ok,config->spanish?"Guardar":"Save",145,520);
	
	for (int i=0;i<mib_count;i++) visible[i]=true;
	
}

void BikeSelection::Reset() {
	
	cred_vel=profile->vel; cred_brake=profile->brake; cred_turn=profile->turn; cred_accel=profile->accel;
	cred_max=0; for (int i=0;i<track_max;i++) {cred_max+=profile->pts[i];}
	LoadBikeData(); for (int i=0;i<mib_count;i++) charsdone[i]=0;
	stringstream ss; ss<<cred_max; items[mib_credits_total_value]=ss.str();
	
	target_bike=profile->bike;
	for (int i=0;i<mib_count;i++) selected[i]=false;
	for (int i=mib_name+2*(num_opts+1);i<mib_ok;i++) visible[i]=false;
	for (int i=mib_name;i<mib_name+2*(num_opts+1);i++) visible[i]=true;
	selection=mib_name; selected[selection]=true; selected[selection+1]=true;
	tostart=10;
}

BikeSelection::~BikeSelection() {
	delete [] ibikes;
	delete [] sbikes;
}

void BikeSelection::Draw() {
	
	App->Draw(bsprite);
	
	font->RenderSmall(215,60,.75,config->spanish?"Conf. Moto":"Bike Set-up");
	
	if (tostart) {
		tostart--;
	} else {
		for (int i=0;i<mib_count;i++) {
			if (!visible[i]) continue;
			if (selected[i]) {
				if (sel_level[i]<8) sel_level[i]+=1;
			} else {
				if (sel_level[i]>0) sel_level[i]-=1;
			}
			font->RenderPartial(pos[i][0]-sel_level[i],pos[i][1]+sel_level[i],.55+.025*sel_level[i],items[i],charsdone[i]/char_speed);
			if (charsdone[i]==char_speed*items[i].size()) continue; charsdone[i]++;
		}
	}
	
	sel_wheel->Draw(pos[selection][0],pos[selection][1]);
	
	current_bike = (target_bike+9*current_bike	)/10;
	while (current_bike-4<0) { current_bike+=data->bike_count; target_bike+=data->bike_count; }
	
	if (config->extra_fx) {
		for (int i=-1;i<5;i++) {
			int t = (int(current_bike)+i)%data->bike_count;
			real d = current_bike-int(current_bike)-i;
			real ud = d<0?-d:d;
			if (ud>1) ud=1;
			sbikes[t].FlipX(true);
			sbikes[t].SetScale(global_scale*(2-ud)/4,global_scale*(2-ud)/4);
			sbikes[t].SetPosition(750+150-75*ud,490+d*150);
			App->Draw(sbikes[t]);
			sbikes[t].FlipX(false);
		}
		real d1 = current_bike-int(current_bike)-1;
		real d2 = current_bike-int(current_bike);
		real ud1 = d1<0?-d1:d1;
		real ud2 = d2<0?-d2:d2;
		real d=ud1<ud2?d1:d2;
		real ud=ud1<ud2?ud1:ud2;
		App->Draw(rsprite);
		gsprite.SetPosition(745,490+d*150);
		gsprite.SetScale(global_scale*(2-ud)/4,global_scale*(2-ud)/4);
		gsprite.SetColor(Color(255,255,255,255-255*(int(ud)*2)));
		App->Draw(gsprite);
	}
	for (int i=-1;i<5;i++) {
		int t = (int(current_bike)+i)%data->bike_count;
		real d = current_bike-int(current_bike)-i;
		real ud = d<0?-d:d;
		if (ud>1) ud=1;
		sbikes[t].SetScale(global_scale*(2-ud)/4,global_scale*(2-ud)/4);
		sbikes[t].SetPosition(745,490+d*150);
		App->Draw(sbikes[t]);
	}
	if (config->extra_fx) App->Draw(tsprite);
	
}

bool BikeSelection::Select(int anum_opts) {
	
	num_opts=anum_opts*6;
	
	Reset(); LoadBikeData();
	
	Fade(true);
	while (true) {
		
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed) {
				Fade(false);return false;
			}
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			if (config->sound_on) music->snd_selcancel.Play();
			last_key=sf::Key::Escape; Fade(false); return false;
		} } else if(App->GetInput().IsKeyDown(sf::Key::Return)) { if (last_key!=sf::Key::Return) {
			last_key=sf::Key::Return; 
			if (SelOk()) { 
				Fade(false); 
				target_bike=target_bike%data->bike_count;
				return true;
			}
		} } else if(App->GetInput().IsKeyDown(sf::Key::Up)) { if (last_key!=sf::Key::Up) {
			last_key=sf::Key::Up; SelMove(true);
		} } else if(App->GetInput().IsKeyDown(sf::Key::Down)) { if (last_key!=sf::Key::Down) {
			last_key=sf::Key::Down; SelMove(false);
		} } else if(App->GetInput().IsKeyDown(sf::Key::Left)) { if (last_key!=sf::Key::Left) {
			last_key=sf::Key::Left; SelChange(false);
		} } else if(App->GetInput().IsKeyDown(sf::Key::Right)) { if (last_key!=sf::Key::Right) {
			last_key=sf::Key::Right; SelChange(true);
//			} } else if(App->GetInput().IsKeyDown(sf::Key::H)) { if (last_key!=sf::Key::H) {
//				last_key=sf::Key::H; show_help=!show_help;
		} } else last_key=sf::Key::Count;
	
		Draw();
		App->TimedDisplay();
	}
}

bool BikeSelection::SelOk() {
	if (config->sound_on) music->snd_selok.Play();
//	if (selection==mib_name) {
//		Zoom();
//	} else 
	if (selection==mib_ok) {
		profile->ChangeBike(cred_vel,cred_accel,cred_brake,cred_turn,target_bike%data->bike_count);
		return true;
	} else {
		SelChange(true);
		return false;
	}
}

void BikeSelection::SelMove(bool up) {
	if (config->sound_on) music->snd_selmove.Play();
	if (up) {
		if (selection==mib_name) return;
		selected[selection]=false;
		if (selection==mib_ok) {
			if (num_opts)
				selection=mib_turn;
			else
				selection=mib_name;
		} else {
			selected[selection+1]=false;
			selection-=2;
		}
		selected[selection]=true;
		selected[selection+1]=true;
	} else {
		if (selection==mib_ok) return;
		selected[selection]=false;
		selected[selection+1]=false;
		if (selection==mib_turn || num_opts==0) {
			selection=mib_ok;
		} else {
			selection+=2;
			selected[selection+1]=true;
		}
		selected[selection]=true;
	}
}

void BikeSelection::SelChange(bool right) {
	if (config->sound_on) music->snd_selmove.Play();
	if (selection==mib_name) {
		if (!can_change_bike) {
			confirm->Tell2(this,
				config->spanish?"No se puede cambiar la moto":"You cannot change bike in the",
				config->spanish?"en medio de un campeonato.":"middle of a race or championship");
			return;
		}
		if (right) {
			target_bike++;
		} else {
			target_bike--;
		}
		LoadBikeData();
	} else if (selection==mib_vel) {
		if (right && cred_vel<bike_upgrade_max && cred_avail>0)
			{ cred_avail--; cred_vel++; }
		else if (!right && cred_vel>0)
			{ cred_avail++; cred_vel--; }
		LoadBikeData();
	} else if (selection==mib_accel) {
		if (right && cred_accel<bike_upgrade_max && cred_avail>0)
			{ cred_avail--; cred_accel++; }
		else if (!right && cred_accel>0)
			{ cred_avail++; cred_accel--; }
		LoadBikeData();
	} else if (selection==mib_brake) {
		if (right && cred_brake<bike_upgrade_max && cred_avail>0)
			{ cred_avail--; cred_brake++; }
		else if (!right && cred_brake>0)
			{ cred_avail++; cred_brake--; }
		LoadBikeData();
	} else if (selection==mib_turn) {
		if (right && cred_turn<bike_upgrade_max && cred_avail>0)
			{ cred_avail--; cred_turn++; }
		else if (!right && cred_turn>0)
			{ cred_avail++; cred_turn--; }
		LoadBikeData();
	}
}

void BikeSelection::LoadBikeData() {
	
	while (target_bike<0) {
		target_bike+=data->bike_count;
		current_bike+=data->bike_count;
	}
	int i=target_bike%data->bike_count;
	string s=string("<")+data->bikes[i].name+">";
	if (items[mib_name_value]!=s) {
		items[mib_name_value]=s;
		charsdone[mib_name_value]=1;
	}
	
	s="<"; for (int i=0;i<cred_accel;i++) s+="|"; for (int i=cred_accel;i<bike_upgrade_max;i++) s+=" "; s+=">";
	if (items[mib_accel_value]!=s) { items[mib_accel_value]=s; charsdone[mib_accel_value]=0; while (s[i]==items[mib_accel_value][i]) { charsdone[mib_accel_value]++; i++; } }

	s="<"; for (int i=0;i<cred_brake;i++) s+="|"; for (int i=cred_brake;i<bike_upgrade_max;i++) s+=" "; s+=">";
	if (items[mib_brake_value]!=s) { items[mib_brake_value]=s; charsdone[mib_brake_value]=0; while (s[i]==items[mib_brake_value][i]) { charsdone[mib_brake_value]++; i++; } }

	s="<"; for (int i=0;i<cred_turn;i++) s+="|"; for (int i=cred_turn;i<bike_upgrade_max;i++) s+=" "; s+=">";
	if (items[mib_turn_value]!=s) { items[mib_turn_value]=s; charsdone[mib_turn_value]=0; while (s[i]==items[mib_turn_value][i]) { charsdone[mib_turn_value]++; i++;}  }

	s="<"; for (int i=0;i<cred_vel;i++) s+="|"; for (int i=cred_vel;i<bike_upgrade_max;i++) s+=" "; s+=">";
	if (items[mib_vel_value]!=s) { items[mib_vel_value]=s; charsdone[mib_vel_value]=0; while (s[i]==items[mib_vel_value][i]) { charsdone[mib_vel_value]++; i++; } }
	
	cred_avail=cred_max-cred_vel-cred_accel-cred_turn-cred_brake;
	stringstream ss; ss<<cred_avail; s=ss.str();
	if (s!=items[mib_credits_avail_value]) { items[mib_credits_avail_value]=s; charsdone[mib_credits_avail_value]=0; }
	
}

//	
//}

implement_fade(BikeSelection)
	
