/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filme;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import org.apache.commons.lang.StringEscapeUtils;

public class ListeFilmeSchattenliste
extends LinkedList<DatenFilm> {
    private Daten daten;

    public ListeFilmeSchattenliste(Daten ddaten) {
        this.daten = ddaten;
    }

    @Override
    public boolean add(DatenFilm film) {
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml(film.arr[3].trim());
        film.arr[11] = Funktionen.getDateiName(this.daten, film.arr[6]);
        if (this.daten.listeBlacklist.checkBlackOk(film)) {
            this.daten.filmeLaden.listeFilme.add(film);
        }
        return super.add(film);
    }

    public boolean addSender(DatenFilm film) {
        return this.addInListe(film);
    }

    public boolean addSenderRtmp(DatenFilm film) {
        if (Boolean.parseBoolean(this.daten.system[20]) && film.arr[6].startsWith("rtmp")) {
            film.arr[6] = "-r " + film.arr[6];
        }
        return this.addInListe(film);
    }

    public synchronized boolean addOld(DatenFilm film, int bisNr) {
        DatenFilm f = null;
        int i = 0;
        boolean gibts = false;
        Iterator it = this.iterator();
        while (it.hasNext() && ++i <= bisNr) {
            f = (DatenFilm)it.next();
            if (!f.arr[1].equalsIgnoreCase(film.arr[1]) || !f.arr[2].equalsIgnoreCase(film.arr[2]) || !f.arr[6].equals(film.arr[6])) continue;
            gibts = true;
            break;
        }
        if (!gibts) {
            return this.add(film);
        }
        return false;
    }

    private synchronized boolean addInListe(DatenFilm film) {
        DatenFilm f = null;
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml(film.arr[3].trim());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            f = (DatenFilm)it.next();
            if (!f.arr[1].equalsIgnoreCase(film.arr[1]) || !f.arr[2].equalsIgnoreCase(film.arr[2]) || !f.arr[6].equals(film.arr[6])) continue;
            it.remove();
            break;
        }
        return this.add(film);
    }

    public void sort() {
        Collections.sort(this);
    }

    public synchronized void delOhneSender(String sender) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public synchronized void delSender(String sender) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (!film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenFilm)it.next()).arr[1].equalsIgnoreCase(sender)) continue;
            ++ret;
        }
        return ret;
    }
}

