/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filme;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.TModelFilm;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.daten.Datum;
import mediathek.daten.ListeAbo;
import mediathek.filme.DatenFilm;
import mediathek.filme.sender.MediathekArd;
import org.apache.commons.lang.StringEscapeUtils;

public class ListeFilme
extends LinkedList<DatenFilm> {
    private Daten daten;
    private TModel model = null;
    private int nr = 0;
    private final int MAX_STELLEN = 6;
    private final String FUELL_ZEICHEN = "0";

    public ListeFilme(Daten ddaten) {
        this.daten = ddaten;
    }

    @Override
    public synchronized void clear() {
        this.nr = 0;
        super.clear();
    }

    public void sort() {
        Collections.sort(this);
    }

    @Override
    public synchronized boolean add(DatenFilm film) {
        String str = String.valueOf(this.nr++);
        while (str.length() < 6) {
            str = "0" + str;
        }
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml(film.arr[3].trim());
        film.arr[0] = str;
        return super.add(film);
    }

    public synchronized boolean superAdd(DatenFilm film) {
        return super.add(film);
    }

    public synchronized void delThema(String sender, String thema) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (!film.arr[1].equalsIgnoreCase(sender) || !film.arr[2].equalsIgnoreCase(thema)) continue;
            it.remove();
        }
    }

    public synchronized void delSender(String sender) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (!film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenFilm)it.next()).arr[1].equalsIgnoreCase(sender)) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized void delOhneSender(String sender) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public synchronized TModelFilm getModelTabFilme(String filterSender, String filterThema, boolean filterExakt, String filterText) {
        TModelFilm modelFilm = null;
        if (this.size() == 0) {
            return null;
        }
        ListeFilme liste = new ListeFilme(this.daten);
        for (DatenFilm film : this) {
            if (!ListeAbo.aboPruefen(filterSender, filterThema, filterExakt, filterText, film.arr[1], film.arr[2], film.arr[3])) continue;
            liste.superAdd(film);
        }
        modelFilm = new TModelFilm(liste.getObjectDataTabFilme(), Konstanten.FILME_COLUMN_NAMES);
        return modelFilm;
    }

    public synchronized TModel getAboModel() {
        this.model = new TModel(this.getAboObjectData(), Konstanten.FILME_COLUMN_NAMES);
        return this.model;
    }

    public synchronized TModel getPodModel() {
        this.model = new TModel(this.getPodObjectData(), Konstanten.FILME_COLUMN_NAMES_POD);
        return this.model;
    }

    public synchronized String[] getModelOfField(int feld, String filterString, int filterFeld) {
        LinkedList<String> list = new LinkedList<String>();
        String str = "";
        list.add("");
        Iterator it = this.iterator();
        if (filterString.equals("")) {
            while (it.hasNext()) {
                str = ((DatenFilm)it.next()).arr[feld];
                if (list.contains(str)) continue;
                list.add(str);
            }
        } else {
            while (it.hasNext()) {
                DatenFilm film = (DatenFilm)it.next();
                str = film.arr[feld];
                if (!film.arr[filterFeld].equalsIgnoreCase(filterString) || list.contains(str)) continue;
                list.add(str);
            }
        }
        Funktionen.listeSort(list);
        String[] ret = new String[]{};
        ret = list.toArray(ret);
        return ret;
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        DatenFilm ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm f = (DatenFilm)it.next();
            if (!f.arr[6].equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    public synchronized void rtmpAendern() {
        String RTMP = "-r ";
        String RTMP_PRTOKOLL = "rtmp";
        for (DatenFilm film : this) {
            if (film.arr[1].equalsIgnoreCase("ARD")) {
                film.arr[6] = MediathekArd.rtmpAendern(this.daten, film.arr[7], film.arr[8]);
                continue;
            }
            if (Boolean.parseBoolean(this.daten.system[20])) {
                if (!film.arr[6].startsWith("rtmp")) continue;
                film.arr[6] = "-r " + film.arr[6];
                continue;
            }
            if (!film.arr[6].startsWith("-r ")) continue;
            film.arr[6] = film.arr[6].substring("-r ".length());
        }
    }

    private Object[][] getObjectDataTabFilme() {
        Object[][] object = null;
        int i = 0;
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            object = new Object[this.size()][18];
            while (iterator.hasNext()) {
                DatenFilm film = (DatenFilm)iterator.next();
                DatenAbo datenAbo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3], film.arr[6]);
                film.arr[17] = datenAbo != null ? datenAbo.arr[1] : "";
                for (int m = 0; m < 18; ++m) {
                    if (m == 4) {
                        Datum tmp = new Datum(0L);
                        if (!film.arr[4].equals("")) {
                            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                            try {
                                tmp.setTime(sdf.parse(film.arr[4]).getTime());
                            }
                            catch (ParseException ex) {
                                // empty catch block
                            }
                        }
                        object[i][m] = tmp;
                        continue;
                    }
                    object[i][m] = film.arr[m];
                }
                ++i;
            }
        }
        return object;
    }

    private Object[][] getAboObjectData() {
        DatenFilm film;
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[][] object = null;
        String zielPfad = "";
        String zielDateiname = "";
        ListIterator itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            film = (DatenFilm)itFilm.next();
            DatenAbo abo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3], film.arr[6]);
            if (abo == null || (!abo.binEinmal() || Boolean.parseBoolean(abo.arr[10])) && this.daten.log.zeilePruefen(film.arr[6], ".mediathek_zdf_log")) continue;
            abo.arr[7] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
            this.daten.setGeaendert();
            if (this.checkListe(liste, film.arr[6])) continue;
            DatenPgruppe gruppe = this.daten.listePgruppeAbo.getName(abo.arr[8]);
            if (gruppe != null) {
                DatenProg datenProg = gruppe.getProgUrl(film.arr[6]);
                if (datenProg != null) {
                    film.arr[15] = gruppe.checkDownloadDirekt(this.daten, film.arr[6]) == 1 ? "direkter Download" : datenProg.arr[0];
                }
                zielDateiname = gruppe.getZielDateiname();
                zielPfad = gruppe.getZielPfad();
            }
            zielPfad = abo.aboPfadAnhaengen(this.daten, zielPfad);
            zielDateiname = film.dateiNamenBauen(zielPfad, zielDateiname);
            liste.add(film);
        }
        if (liste.size() > 0) {
            object = new Object[liste.size()][18];
            itFilm = liste.listIterator();
            int i = 0;
            while (itFilm.hasNext()) {
                film = (DatenFilm)itFilm.next();
                DatenAbo datenAbo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3], film.arr[6]);
                if (datenAbo != null) {
                    film.arr[17] = datenAbo.arr[1];
                }
                object[i] = film.arr;
                ++i;
            }
        }
        return object;
    }

    private Object[][] getPodObjectData() {
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[][] object = null;
        int i = 0;
        ListIterator itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            DatenFilm film = (DatenFilm)itFilm.next();
            String zielpfad = this.daten.listePod.getZiel(film.arr[2]);
            if (zielpfad == null || this.daten.log.zeilePruefen(film.arr[6], ".mediathek_podder_log") || this.checkListe(liste, film.arr[6])) continue;
            zielpfad = Funktionen.addsPfad(this.daten, this.daten.system[11], zielpfad);
            film.dateiNamenBauen(zielpfad, Funktionen.getDateiName(this.daten, film.arr[6]));
            liste.add(film);
        }
        if (liste.size() > 0) {
            object = new Object[liste.size()][18];
            itFilm = liste.listIterator();
            while (itFilm.hasNext()) {
                object[i] = ((DatenFilm)itFilm.next()).arr;
                ++i;
            }
        }
        return object;
    }

    private boolean checkListe(LinkedList<DatenFilm> liste, String url) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (!url.equals(film.arr[6])) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

