/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io.starter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.daten.Daten;
import mediathek.gui.dialoge.DialogLog;
import mediathek.io.starter.RuntimeExecEvent;
import mediathek.io.starter.RuntimeListener;
import mediathek.io.starter.Starts;

class RuntimeExec {
    private static final int INPUT = 1;
    private static final int ERROR = 2;
    private Daten daten;
    private String url;
    private String prog;
    Thread clearIn;
    Thread clearOut;
    private Process process = null;
    private EventListenerList listeners = new EventListenerList();
    private boolean beendenMelden = true;

    public RuntimeExec(Daten d, Starts s) {
        this.daten = d;
        this.url = s.film.arr[4];
        this.prog = s.prog;
    }

    public RuntimeExec(Daten d, String u, String p) {
        this.daten = d;
        this.url = u;
        this.prog = p;
    }

    public void addListener(RuntimeListener listener) {
        this.listeners.add(RuntimeListener.class, listener);
    }

    public Process exec() {
        try {
            if (this.daten.simmulieren.booleanValue()) {
                if (this.daten.dialogLog == null) {
                    this.daten.dialogLog = new DialogLog(null, false);
                }
                this.daten.dialogLog.setVisible(true);
                this.daten.dialogLog.addText(this.url, this.prog);
            } else {
                this.daten.fehler.systemMeldung("========================================");
                this.daten.fehler.systemMeldung("Programm starten:");
                this.daten.fehler.systemMeldung(this.prog);
                this.process = Runtime.getRuntime().exec(this.prog);
                this.clearIn = new Thread(new ClearInOut(1, this.process));
                this.clearOut = new Thread(new ClearInOut(2, this.process));
                this.clearIn.start();
                this.clearOut.start();
            }
        }
        catch (IOException ex) {
            if (this.process == null) {
                this.notifyEvent();
            }
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Fehler beim Starten", 0);
        }
        return this.process;
    }

    private void notifyEvent() {
        if (this.beendenMelden) {
            this.beendenMelden = false;
            RuntimeExecEvent event = new RuntimeExecEvent(this);
            for (RuntimeListener l : (RuntimeListener[])this.listeners.getListeners(RuntimeListener.class)) {
                l.starter(event);
            }
        }
    }

    private class ClearInOut
    implements Runnable {
        private int art;
        private BufferedReader buff;
        private InputStream in;
        private Process process;

        public ClearInOut(int a, Process p) {
            this.art = a;
            this.process = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String titel = "";
            try {
                String inStr;
                switch (this.art) {
                    case 1: {
                        this.in = this.process.getInputStream();
                        titel = "INPUTSTREAM";
                        break;
                    }
                    case 2: {
                        this.in = this.process.getErrorStream();
                        titel = "ERRORSTREAM";
                    }
                }
                this.buff = new BufferedReader(new InputStreamReader(this.in));
                while ((inStr = this.buff.readLine()) != null) {
                    if (((RuntimeExec)RuntimeExec.this).daten.dialogFehler == null) continue;
                    ((RuntimeExec)RuntimeExec.this).daten.fehler.playerMeldung(titel, inStr);
                }
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    RuntimeExec.this.notifyEvent();
                    this.buff.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

