/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.Funktionen;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.beobachter.DownloadCellRenderer;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPod;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialoge.DialogPod;
import mediathek.gui.dialoge.DialogPodBasis;
import mediathek.gui.dialoge.DialogPodster;
import mediathek.io.FilmListener;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;
import mediathek.io.starter.Starts;

public class GuiPodder
extends PanelVorlage {
    private TModel tModel1;
    private TModel tModel2;
    private BeobachterTableSelect1 beobachterTableSelect1;
    private JButton jButtonAendern;
    private JButton jButtonAufraeumen;
    private JButton jButtonDauerhaftLoeschen;
    private JButton jButtonDownloadLoeschen;
    private JButton jButtonDownloaden;
    private JButton jButtonLoeschen;
    private JButton jButtonNeu;
    private JButton jButtonPodster;
    private JButton jButtonStop;
    private JButton jButtonSuchen;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane2;
    private JTable jTable1;
    private JTable jTable2;

    public GuiPodder(Daten d) {
        super(d);
        this.initComponents();
        this.daten.guiPodder = this;
        this.jProgressBar1.setVisible(false);
        this.jButtonStop.setVisible(false);
        this.jButtonNeu.addActionListener(new BeobachterNeu());
        this.jButtonLoeschen.addActionListener(new BeobLoeschen());
        this.jButtonAendern.addActionListener(new BeobAendern());
        this.jButtonSuchen.addActionListener(new BeobSuchen());
        this.jButtonDownloaden.addActionListener(new BeobDownloadAll());
        this.jButtonDownloadLoeschen.addActionListener(new BeobDownloadLoeschen(false));
        this.jButtonDauerhaftLoeschen.addActionListener(new BeobDownloadLoeschen(true));
        this.jButtonAufraeumen.addActionListener(new BeobAufraeumen());
        this.jButtonPodster.addActionListener(new BeobPodster());
        this.jButtonStop.addActionListener(new BeobPodsStop());
        this.daten.starterClass.addListener(new BeobStart());
        this.jTable1.addMouseListener(new BeobMausTabelle1());
        this.beobachterTableSelect1 = new BeobachterTableSelect1();
        this.jTable1.getSelectionModel().addListSelectionListener(this.beobachterTableSelect1);
        this.jTable2.setDefaultRenderer(Object.class, new DownloadCellRenderer(this.daten, 4));
        this.jTable2.addMouseListener(new BeobMausTabelle2(this.jTable2));
        this.jProgressBar1.setForeground(new Color(102, 153, 255));
        this.daten.feedReaderPods.addAdListener(new BeobachterLaden());
        this.load1();
    }

    @Override
    public void neuLaden() {
    }

    public static void downloadAll(Daten daten, TModel tMod) {
        String ordner = "";
        String url = "";
        if (tMod != null) {
            LinkedList<Starts> startsListe = new LinkedList<Starts>();
            for (int i = 0; i < tMod.getRowCount(); ++i) {
                ordner = (String)tMod.getValueAt(i, 12);
                url = (String)tMod.getValueAt(i, 4);
                DatenFilm film = new DatenFilm(daten, "Podcast", (String)tMod.getValueAt(i, 2), (String)tMod.getValueAt(i, 3), url, "");
                Starts starts = new Starts(film, 1, "", false);
                starts.film.dateiNamenBauen(ordner, film.arr[11]);
                startsListe.add(starts);
            }
            daten.starterClass.addListe(startsListe);
        }
    }

    public void basisziel() {
        DialogPodBasis dialogPodBasis = new DialogPodBasis(null, true, this.daten);
        dialogPodBasis.setVisible(true);
        if (dialogPodBasis.geaendert) {
            super.getSpalten(this.jTable1);
            this.load1();
            super.setSpalten(this.jTable1);
        }
    }

    private void load1() {
        this.tModel2 = new TModel((Object[][])null, Konstanten.FILME_COLUMN_NAMES_POD);
        this.jTable2.setModel(this.tModel2);
        this.jTable2.getColumnModel().getColumn(1).setMinWidth(0);
        this.jTable2.getColumnModel().getColumn(1).setMaxWidth(0);
        this.jTable2.getColumnModel().getColumn(1).setPreferredWidth(0);
        this.tModel1 = new TModel(this.daten.listePod.getObjectData(), Konstanten.POD_COLUMN_NAMES);
        this.jTable1.setModel(this.tModel1);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(1000);
    }

    private void podsSuchen() {
        this.jButtonSuchen.setEnabled(false);
        this.jButtonDownloaden.setEnabled(false);
        this.jTable2.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.daten.feedReaderPods.starten();
    }

    private void load2() {
        this.tModel2 = this.daten.feedReaderPods.getListe().getPodModel();
        this.jTable2.setModel(this.tModel2);
        Funktionen.spaltenFilmSetzen(this.jTable2, this.daten, false, true, false);
    }

    private void neuerPod() {
        DatenPod datenPod = new DatenPod();
        DialogPod dialogPod = new DialogPod(null, true, this.daten, datenPod);
        dialogPod.setVisible(true);
        if (dialogPod.ok) {
            this.daten.listePod.addPod(datenPod);
            super.getSpalten(this.jTable1);
            this.load1();
            super.setSpalten(this.jTable1);
            int neu = this.tModel1.getRowCount();
            this.jTable1.setRowSelectionInterval(this.jTable1.convertRowIndexToView(neu - 1), this.jTable1.convertRowIndexToView(neu - 1));
            this.jTable1.scrollRectToVisible(this.jTable1.getCellRect(neu - 1, 0, true));
        }
    }

    private void podAendern() {
        if (this.beobachterTableSelect1.selectedModelRow >= 0) {
            DatenPod datenPod = this.daten.listePod.getPodNr(this.beobachterTableSelect1.selectedModelRow);
            DialogPod dialogPod = new DialogPod(null, true, this.daten, datenPod);
            dialogPod.setVisible(true);
            if (dialogPod.ok) {
                super.getSpalten(this.jTable1);
                this.load1();
                super.setSpalten(this.jTable1);
            }
        }
    }

    private void initProgressBar(int max, int progress, String text) {
        if (max == 0) {
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setStringPainted(false);
            this.jProgressBar1.setVisible(false);
            this.jButtonStop.setVisible(false);
        } else {
            this.jProgressBar1.setVisible(true);
            this.jButtonStop.setVisible(true);
            this.jProgressBar1.setMaximum(max);
            this.jProgressBar1.setMinimum(0);
            int proz = 0;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            this.jProgressBar1.setString("( " + proz + "% von " + max + " Podcasts )  " + Funktionen.textLaenge(text));
            this.jProgressBar1.setStringPainted(true);
            this.jProgressBar1.setValue(progress);
        }
    }

    private void deleteDownload(boolean dauerhaft) {
        int[] rows = this.jTable2.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = this.jTable2.convertRowIndexToModel(rows[i]);
                if (dauerhaft) {
                    this.daten.log.zeileSchreiben((String)this.tModel2.getValueAt(delRow, 4), ".mediathek_podder_log");
                }
                this.daten.starterClass.filmLoeschen((String)this.tModel2.getValueAt(delRow, 4));
                this.tModel2.removeRow(delRow);
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void aufraeumen() {
        for (int i = 0; i < this.tModel2.getRowCount(); ++i) {
            int s = this.daten.starterClass.getState((String)this.tModel2.getValueAt(i, 4));
            if (s < 3) continue;
            this.tModel2.removeRow(i);
            --i;
        }
        this.daten.starterClass.aufraeumen(1);
    }

    private void podsStop() {
        if (this.daten.feedReaderPods != null) {
            this.daten.feedReaderPods.stoppen();
        }
    }

    private void downloadAll() {
        GuiPodder.downloadAll(this.daten, this.tModel2);
    }

    private void panelUpdate() {
        this.jTable2.repaint();
        this.validate();
    }

    private void podster() {
        DialogPodster dialog = new DialogPodster(null, true, this.daten);
        dialog.setVisible(true);
        if (dialog.podGeaendert) {
            super.getSpalten(this.jTable1);
            this.load1();
            super.setSpalten(this.jTable1);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButtonSuchen = new JButton();
        this.jButtonDownloaden = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonNeu = new JButton();
        this.jButtonLoeschen = new JButton();
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jButtonDownloadLoeschen = new JButton();
        this.jButtonDauerhaftLoeschen = new JButton();
        this.jButtonAufraeumen = new JButton();
        this.jButtonAendern = new JButton();
        this.jButtonPodster = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.jButtonStop = new JButton();
        this.jLabel1.setText("jLabel1");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonSuchen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/start.gif")));
        this.jButtonSuchen.setText("neue Podcasts suchen");
        this.jButtonSuchen.setToolTipText("nach neuen Podcasts suchen");
        this.jButtonDownloaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/start2.gif")));
        this.jButtonDownloaden.setText("alle Downloads starten");
        this.jButtonDownloaden.setToolTipText("alle in der unteren Tabelle angezeigten Downloads starten");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonSuchen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDownloaden).addContainerGap(285, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jButtonDownloaden, this.jButtonSuchen);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonSuchen).addComponent(this.jButtonDownloaden)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonDownloaden, this.jButtonSuchen);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonNeu.setText("neuer Podcast");
        this.jButtonNeu.setToolTipText("einen neuen Podcast anlegen");
        this.jButtonLoeschen.setText("Podcast l\u00f6schen");
        this.jButtonLoeschen.setToolTipText("markierten Podcast l\u00f6schen");
        this.jSplitPane2.setDividerLocation(150);
        this.jSplitPane2.setOrientation(0);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSplitPane2.setTopComponent(this.jScrollPane1);
        this.jTable2.setAutoCreateRowSorter(true);
        this.jTable2.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTable2.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jSplitPane2.setRightComponent(this.jScrollPane2);
        this.jButtonDownloadLoeschen.setText("Download l\u00f6schen");
        this.jButtonDownloadLoeschen.setToolTipText("markierten Download l\u00f6schen");
        this.jButtonDauerhaftLoeschen.setText("Download dauerhaft l\u00f6schen");
        this.jButtonDauerhaftLoeschen.setToolTipText("markierten Download dauerhaft l\u00f6schen");
        this.jButtonAufraeumen.setText("Tabelle aufr\u00e4umen");
        this.jButtonAufraeumen.setToolTipText("abgeschlossene Downloads aus der Tabelle entfernen");
        this.jButtonAendern.setText("Podcast \u00e4ndern");
        this.jButtonAendern.setToolTipText("Einstellungen des markierten Podcast \u00e4ndern");
        this.jButtonPodster.setText("Podcast von Podster.de suchen");
        this.jButtonPodster.setToolTipText("bei Podster.de nach Podcasts suchen");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, -1, 767, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonNeu).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAendern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 47, Short.MAX_VALUE).addComponent(this.jButtonPodster)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonDownloadLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDauerhaftLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAufraeumen))).addContainerGap()));
        jPanel4Layout.linkSize(0, this.jButtonAendern, this.jButtonLoeschen, this.jButtonNeu);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonNeu).addComponent(this.jButtonLoeschen).addComponent(this.jButtonAendern).addComponent(this.jButtonPodster)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane2, -1, 293, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonDownloadLoeschen).addComponent(this.jButtonDauerhaftLoeschen).addComponent(this.jButtonAufraeumen)).addContainerGap()));
        jPanel4Layout.linkSize(1, this.jButtonLoeschen, this.jButtonNeu);
        this.jProgressBar1.setFont(new Font("Monospaced", 1, 12));
        this.jButtonStop.setText("Stop");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jProgressBar1, -1, 722, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jProgressBar1, -2, -1, -2).addComponent(this.jButtonStop)).addGap(12, 12, 12)));
        layout.linkSize(1, this.jButtonStop, this.jProgressBar1);
    }

    public class BeobMausTabelle2
    extends MouseAdapter {
        private BeobUrl beobUrl = new BeobUrl();
        private Point p;
        private JTable tabelle;

        public BeobMausTabelle2(JTable ttabelle) {
            this.tabelle = ttabelle;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() != 1 && arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            JMenuItem itemVor = new JMenuItem("URL kopieren");
            itemVor.addActionListener(this.beobUrl);
            menu.add(itemVor);
            menu.addSeparator();
            JMenuItem itemLoeschen = new JMenuItem("Download l\u00f6schen");
            itemLoeschen.addActionListener(new BeobDownloadLoeschen(false));
            menu.add(itemLoeschen);
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download dauerhaft l\u00f6schen");
            itemDauerhaftLoeschen.addActionListener(new BeobDownloadLoeschen(true));
            menu.add(itemDauerhaftLoeschen);
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobUrl
        implements ActionListener {
            private BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = BeobMausTabelle2.this.tabelle.rowAtPoint(BeobMausTabelle2.this.p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard((String)BeobMausTabelle2.this.tabelle.getModel().getValueAt(BeobMausTabelle2.this.tabelle.convertRowIndexToModel(nr), 4));
                }
            }
        }
    }

    public class BeobMausTabelle1
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 1 && arg0.getClickCount() > 1) {
                GuiPodder.this.podAendern();
            }
        }
    }

    private class BeobachterLaden
    implements FilmListener {
        int max = 0;
        int count = 0;
        int progress;

        @Override
        public void start(String sender, int m) {
            ++this.count;
            this.max += m;
            GuiPodder.this.initProgressBar(this.max, 0, "");
        }

        @Override
        public void progress(String text) {
            ++this.progress;
            if (this.progress > this.max) {
                this.progress = this.max;
            }
            GuiPodder.this.initProgressBar(this.max, this.progress, text);
        }

        @Override
        public void fertig(String sender, boolean stop) {
            --this.count;
            if (this.count <= 0) {
                this.max = 0;
                this.progress = 0;
                GuiPodder.this.load1();
                GuiPodder.this.load2();
                GuiPodder.this.initProgressBar(0, 0, "");
                GuiPodder.this.jButtonSuchen.setEnabled(true);
                GuiPodder.this.jButtonDownloaden.setEnabled(true);
            }
        }

        @Override
        public void addMax(int m) {
            this.max += m;
        }

        @Override
        public void threads(int tthreads) {
        }
    }

    private class BeobStart
    implements StartListener {
        private BeobStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            GuiPodder.this.panelUpdate();
            if (ev.allesStop()) {
                // empty if block
            }
        }
    }

    private class BeobProg
    implements ActionListener {
        private BeobProg() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiPodder.this.basisziel();
        }
    }

    private class BeobAufraeumen
    implements ActionListener {
        private BeobAufraeumen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiPodder.this.aufraeumen();
        }
    }

    private class BeobDownloadAll
    implements ActionListener {
        private BeobDownloadAll() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiPodder.this.downloadAll();
        }
    }

    private class BeobDownloadLoeschen
    implements ActionListener {
        boolean dauerhaft = false;

        public BeobDownloadLoeschen(boolean d) {
            this.dauerhaft = d;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiPodder.this.deleteDownload(this.dauerhaft);
        }
    }

    private class BeobSuchen
    implements ActionListener {
        private BeobSuchen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiPodder.this.podsSuchen();
        }
    }

    private class BeobAendern
    implements ActionListener {
        private BeobAendern() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiPodder.this.podAendern();
        }
    }

    private class BeobLoeschen
    implements ActionListener {
        private BeobLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = GuiPodder.this.jTable1.getSelectedRows();
            if (rows.length > 0) {
                int ret = -1;
                ret = JOptionPane.showConfirmDialog(null, "L\u00f6schen?", " ", 0);
                if (ret == 0) {
                    for (int i = rows.length - 1; i >= 0; --i) {
                        int delRow = GuiPodder.this.jTable1.convertRowIndexToModel(rows[i]);
                        GuiPodder.this.daten.listePod.remove(delRow);
                    }
                    GuiPodder.this.load1();
                    GuiPodder.this.daten.setGeaendert();
                }
            } else {
                new HinweisKeineAuswahl();
            }
        }
    }

    private class BeobPodsStop
    implements ActionListener {
        private BeobPodsStop() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiPodder.this.podsStop();
        }
    }

    private class BeobPodster
    implements ActionListener {
        private BeobPodster() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiPodder.this.podster();
        }
    }

    private class BeobachterNeu
    implements ActionListener {
        private BeobachterNeu() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiPodder.this.neuerPod();
        }
    }

    private class BeobachterTableSelect1
    implements ListSelectionListener {
        public int selectedModelRow = -1;

        private BeobachterTableSelect1() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                this.selectedModelRow = GuiPodder.this.jTable1.getSelectedRow() >= 0 ? GuiPodder.this.jTable1.convertRowIndexToModel(GuiPodder.this.jTable1.getSelectedRow()) : -1;
            }
        }
    }
}

