/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.awt.Color;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import mediathek.Fehler;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.daten.DatenProg;
import mediathek.daten.ListeProg;

public class DatenPgruppe {
    public String[] arr;
    private ListeProg listeProg = new ListeProg();

    public DatenPgruppe() {
        this.makeArray();
    }

    public DatenPgruppe(String name, String suffix, String farbe, String zielPfad, String zielDateiname) {
        this.makeArray();
        this.arr[0] = name;
        this.arr[2] = suffix;
        this.arr[3] = farbe;
        this.arr[5] = zielPfad;
        this.arr[6] = zielDateiname;
    }

    public boolean addProg(DatenProg prog) {
        return this.listeProg.add(prog);
    }

    public ListeProg getListeProg() {
        return this.listeProg;
    }

    public DatenProg getProg(int i) {
        return (DatenProg)this.listeProg.get(i);
    }

    public DatenProg getProgUrl(String url) {
        DatenProg ret = null;
        if (this.listeProg.size() == 0) {
            JOptionPane.showMessageDialog(null, "Programme einrichten!", "Kein Programm", 1);
        } else if (this.listeProg.size() == 1) {
            ret = (DatenProg)this.listeProg.getFirst();
        } else {
            for (DatenProg prog : this.listeProg) {
                if (!prog.urlTesten(url)) continue;
                ret = prog;
                break;
            }
            if (this.listeProg.size() > 0 && ret == null) {
                ret = (DatenProg)this.listeProg.getLast();
            }
        }
        return ret;
    }

    public String getZielDateiname() {
        return this.arr[6];
    }

    public String getZielPfad() {
        return this.arr[5];
    }

    public DatenPgruppe copy() {
        DatenPgruppe ret = new DatenPgruppe();
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        this.arr[4] = Boolean.toString(false);
        ListIterator it = this.getListeProg().listIterator(0);
        while (it.hasNext()) {
            ret.addProg(((DatenProg)it.next()).copy());
        }
        return ret;
    }

    public Color getFarbe(Daten daten) {
        Color ret = null;
        if (!this.arr[3].equals("")) {
            String r = this.arr[3].substring(0, this.arr[3].indexOf(","));
            String g = this.arr[3].substring(this.arr[3].indexOf(",") + 1, this.arr[3].lastIndexOf(","));
            String b = this.arr[3].substring(this.arr[3].lastIndexOf(",") + 1);
            try {
                ret = new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
            }
            catch (Exception ex) {
                new Fehler(daten).fehlerMeldung(ex, "DatenProg.getFarbe");
            }
        }
        return ret;
    }

    public void setFarbe(Color farbe) {
        this.arr[3] = String.valueOf(farbe.getRed()) + "," + String.valueOf(farbe.getGreen()) + "," + String.valueOf(farbe.getBlue());
    }

    public int checkDownloadDirekt(Daten daten, String url) {
        int ret = 2;
        if ((!this.arr[1].equals("") || !this.arr[2].equals("")) && Funktionen.praefixTesten(this.arr[1], url, true) && Funktionen.praefixTesten(this.arr[2], url, false)) {
            ret = 3;
        }
        return ret;
    }

    private void makeArray() {
        this.arr = new String[7];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = new String("");
        }
    }
}

