/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.Log;
import mediathek.tool.TModel;
import mediathek.tool.TModelAbo;
import mediathek.tool.TModelDownload;
import mediathek.tool.TModelFilm;

public final class JTableMed
extends JTable {
    public static final String TABELLEN = "Tabellen";
    public static final int TABELLE_EIGENSCHAFTEN_MAX = 2;
    public static final int TABELLEN_MAX = 3;
    public static final int TABELLE_STANDARD = -1;
    public static final int TABELLE_TAB_FILME = 0;
    public static final int TABELLE_TAB_DOWNLOADS = 1;
    public static final int TABELLE_TAB_ABOS = 2;
    public static final String FELDTRENNER = "|";
    private List<? extends RowSorter.SortKey> listeSortKeys = null;
    int[] breite;
    int[] reihe;
    private int sel = -1;
    private int[] selection;
    private String idx = "";
    private boolean stopBeob = false;
    String[] spaltenTabelle;
    int nrDatenSystem;
    int tabelle;

    public JTableMed(int ttabelle) {
        this.tabelle = ttabelle;
        switch (this.tabelle) {
            case 0: {
                this.nrDatenSystem = 36;
                this.spaltenTabelle = DatenFilm.FILME_COLUMN_NAMES;
                this.setModel(new TModelFilm(new Object[0][], this.spaltenTabelle));
                break;
            }
            case 1: {
                this.nrDatenSystem = 37;
                this.spaltenTabelle = DatenDownload.DOWNLOAD_COLUMN_NAMES;
                this.setModel(new TModelDownload(new Object[0][], this.spaltenTabelle));
                break;
            }
            case 2: {
                this.nrDatenSystem = 38;
                this.spaltenTabelle = DatenAbo.ABO_COLUMN_NAMES;
                this.setModel(new TModelAbo(new Object[0][], this.spaltenTabelle));
            }
        }
        this.breite = this.getArray(this.spaltenTabelle.length);
        this.reihe = this.getArray(this.spaltenTabelle.length);
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(0);
    }

    public JTableMed(String[] sspaltenTabelle) {
        this.tabelle = -1;
        this.spaltenTabelle = sspaltenTabelle;
        this.setModel(new TModel(new Object[0][], this.spaltenTabelle));
        this.breite = this.getArray(this.spaltenTabelle.length);
        this.reihe = this.getArray(this.spaltenTabelle.length);
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(0);
    }

    public void fireTableDataChanged(boolean setSpalten) {
        if (setSpalten) {
            this.getSelected();
        }
        ((TModel)this.getModel()).fireTableDataChanged();
        if (setSpalten) {
            this.setSelected();
        }
    }

    public void getSelected() {
        this.sel = this.getSelectedRow();
        this.selection = this.getSelectedRows();
        this.idx = this.sel >= 0 ? this.getModel().getValueAt(this.convertRowIndexToModel(this.sel), 0).toString() : "";
    }

    public void setSelected() {
        this.stopBeob = true;
        switch (this.tabelle) {
            case 0: {
                int r;
                if (!this.idx.equals("") && (r = ((TModel)this.getModel()).getIdxRow(this.idx)) >= 0) {
                    r = this.convertRowIndexToView(r);
                    this.setRowSelectionInterval(r, r);
                    this.scrollRectToVisible(this.getCellRect(r, 0, false));
                }
                this.idx = "";
                break;
            }
            case -1: 
            case 1: 
            case 2: {
                if (this.sel >= 0 && this.sel < this.getRowCount()) {
                    this.setRowSelectionInterval(this.sel, this.sel);
                    this.scrollRectToVisible(this.getCellRect(this.sel, 0, false));
                }
                if (this.selection == null || this.selection.length <= 0) break;
                for (int i = 0; i < this.selection.length; ++i) {
                    if (this.selection[i] >= this.getRowCount()) continue;
                    this.addRowSelectionInterval(this.selection[i], this.selection[i]);
                }
                break;
            }
        }
        this.stopBeob = false;
    }

    public void getSpalten() {
        int i;
        this.getSelected();
        for (i = 0; i < this.reihe.length && i < this.getModel().getColumnCount(); ++i) {
            this.reihe[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < this.breite.length && i < this.getModel().getColumnCount(); ++i) {
            this.breite[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        this.listeSortKeys = this.getRowSorter() != null ? this.getRowSorter().getSortKeys() : null;
    }

    public void setSpalten() {
        this.stopBeob = true;
        this.spaltenAusschalten();
        this.setSelected();
        try {
            int i;
            for (i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
                if (this.breite[i] == 0) {
                    this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMinWidth(0);
                    this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setPreferredWidth(0);
                    this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMaxWidth(0);
                    continue;
                }
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMinWidth(10);
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setPreferredWidth(this.breite[i]);
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMaxWidth(3000);
            }
            for (i = 0; i < this.reihe.length && i < this.getColumnCount(); ++i) {
                this.getColumnModel().moveColumn(this.convertColumnIndexToView(this.reihe[i]), i);
            }
            if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
                this.getRowSorter().setSortKeys(this.listeSortKeys);
            }
            this.validate();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(965001463, 0, "JTableMed.setSpalten", ex);
        }
        this.stopBeob = false;
    }

    public void initTabelle() {
        if (this.tabelle == -1) {
            return;
        }
        boolean ok = false;
        if (!DDaten.system[this.nrDatenSystem].equals("")) {
            ok = true;
            String b = DDaten.system[this.nrDatenSystem].substring(0, DDaten.system[this.nrDatenSystem].indexOf(FELDTRENNER));
            String r = DDaten.system[this.nrDatenSystem].substring(DDaten.system[this.nrDatenSystem].indexOf(FELDTRENNER) + 1);
            if (!this.arrLesen(b, this.breite)) {
                ok = false;
            }
            if (!this.arrLesen(r, this.reihe)) {
                ok = false;
            }
        }
        if (ok) {
            this.setSpalten();
        } else {
            this.resetTabelle();
        }
    }

    public void resetTabelle() {
        block5: for (int i = 0; i < this.spaltenTabelle.length; ++i) {
            switch (this.tabelle) {
                case 0: {
                    this.reihe[i] = i;
                    this.breite[i] = 200;
                    if (i == 0) {
                        this.breite[i] = 75;
                        continue block5;
                    }
                    if (i == 3) {
                        this.breite[i] = 300;
                        continue block5;
                    }
                    if (i == 4 || i == 5 || i == 1) {
                        this.breite[i] = 100;
                        continue block5;
                    }
                    if (i != 6) continue block5;
                    this.breite[i] = 500;
                    continue block5;
                }
                case 1: {
                    this.reihe[i] = i;
                    this.breite[i] = 200;
                    if (i == 0 || i == 1 || i == 15) {
                        this.breite[i] = 75;
                        continue block5;
                    }
                    if (i == 5) {
                        this.breite[i] = 300;
                        continue block5;
                    }
                    if (i != 7 && i != 8 && i != 3 && i != 6) continue block5;
                    this.breite[i] = 100;
                    continue block5;
                }
                case 2: {
                    this.reihe[i] = i;
                    this.breite[i] = 200;
                    if (i == 0 || i == 1) {
                        this.breite[i] = 75;
                        continue block5;
                    }
                    if (i != 8 && i != 3) continue block5;
                    this.breite[i] = 100;
                    continue block5;
                }
            }
        }
        this.setRowSorter(null);
        this.setAutoCreateRowSorter(true);
        this.setSpalten();
    }

    public void spaltenAusschalten() {
        for (int i = 0; i < this.spaltenTabelle.length; ++i) {
            switch (this.tabelle) {
                case 0: {
                    if (i != 7 && i != 8 && i != 9) break;
                    this.breite[i] = 0;
                    break;
                }
                case 1: {
                    if (i != 10 && i != 11 && i != 19 && i != 20 && i != 21) break;
                    this.breite[i] = 0;
                    break;
                }
                case 2: {
                    break;
                }
            }
            if (!DDaten.debug || this.breite[i] != 0) continue;
            this.breite[i] = 100;
        }
    }

    public void tabelleNachDatenSchreiben() {
        int i;
        if (this.tabelle == -1) {
            return;
        }
        int[] reihe_ = new int[this.spaltenTabelle.length];
        int[] breite_ = new int[this.spaltenTabelle.length];
        for (i = 0; i < reihe_.length && i < this.getModel().getColumnCount(); ++i) {
            reihe_[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < breite_.length && i < this.getModel().getColumnCount(); ++i) {
            breite_[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        String b = Integer.toString(breite_[0]);
        String r = Integer.toString(reihe_[0]);
        for (i = 1; i < this.breite.length; ++i) {
            b = b + "," + Integer.toString(breite_[i]);
            r = r + "," + Integer.toString(reihe_[i]);
        }
        DDaten.system[this.nrDatenSystem] = b + FELDTRENNER + r;
    }

    private int[] getArray(int anzahl) {
        int[] arr = new int[anzahl];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = -1;
        }
        return arr;
    }

    private boolean arrLesen(String s, int[] arr) {
        if (this.spaltenTabelle.length != this.countString(s) + 1) {
            return false;
        }
        for (int i = 0; i < this.spaltenTabelle.length; ++i) {
            String sub;
            if (s.equals("")) continue;
            if (s.contains(",")) {
                sub = s.substring(0, s.indexOf(","));
                s = s.replaceFirst(sub + ",", "");
            } else {
                sub = s;
                s = "";
            }
            try {
                arr[i] = Integer.parseInt(sub);
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private int countString(String s) {
        int ret = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ',') continue;
            ++ret;
        }
        return ret;
    }
}

