/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.InputStream;
import javax.swing.JOptionPane;
import mediathek.controller.io.IoXmlLesen;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialog.DialogOk;
import mediathek.gui.dialogEinstellungen.DialogImportPset;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.tool.Funktionen;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;

public class GuiFunktionenProgramme
extends GuiFunktionen {
    public static String getMusterPfadMplayer() {
        String pfad;
        String PFAD_LINUX = "/usr/bin/mplayer";
        String PFAD_MAC = "/opt/local/bin/mplayer";
        String PFAD_WIN_DEFAULT = "C:\\Program Files\\SMPlayer\\mplayer\\mplayer.exe";
        String PFAD_WIN = "\\SMPlayer\\mplayer\\mplayer.exe";
        switch (GuiFunktionenProgramme.getOs()) {
            case 3: {
                pfad = "/usr/bin/mplayer";
                break;
            }
            case 4: {
                pfad = "/opt/local/bin/mplayer";
                break;
            }
            default: {
                pfad = System.getenv("ProgramFiles") != null ? System.getenv("ProgramFiles") + "\\SMPlayer\\mplayer\\mplayer.exe" : (System.getenv("ProgramFiles(x86)") != null ? System.getenv("ProgramFiles(x86)") + "\\SMPlayer\\mplayer\\mplayer.exe" : "C:\\Program Files\\SMPlayer\\mplayer\\mplayer.exe");
            }
        }
        if (!new File(pfad).exists()) {
            pfad = "";
        }
        return pfad;
    }

    public static String getMusterPfadVlc() {
        String pfad;
        String PFAD_LINUX_VLC = "/usr/bin/vlc";
        String PFAD_MAC_VLC = "/Applications/VLC.app/Contents/MacOS/VLC";
        String PFAD_WIN_DEFAULT = "C:\\Programme\\VideoLAN\\VLC\\vlc.exe";
        String PFAD_WIN = "\\VideoLAN\\VLC\\vlc.exe";
        switch (GuiFunktionenProgramme.getOs()) {
            case 3: {
                pfad = "/usr/bin/vlc";
                break;
            }
            case 4: {
                pfad = "/Applications/VLC.app/Contents/MacOS/VLC";
                break;
            }
            default: {
                pfad = System.getenv("ProgramFiles") != null ? System.getenv("ProgramFiles") + "\\VideoLAN\\VLC\\vlc.exe" : (System.getenv("ProgramFiles(x86)") != null ? System.getenv("ProgramFiles(x86)") + "\\VideoLAN\\VLC\\vlc.exe" : "C:\\Programme\\VideoLAN\\VLC\\vlc.exe");
            }
        }
        if (!new File(pfad).exists()) {
            pfad = "";
        }
        return pfad;
    }

    public static String getMusterPfadFlv() {
        String pfad;
        String PFAD_LINUX_FLV = "/usr/bin/flvstreamer";
        String PFAD_MAC_FLV = "bin/flvstreamer_macosx_intel_32bit_latest";
        String PFAD_WINDOWS_FLV = "bin\\flvstreamer_win32_latest.exe";
        switch (GuiFunktionenProgramme.getOs()) {
            case 3: {
                pfad = "/usr/bin/flvstreamer";
                break;
            }
            case 4: {
                pfad = Funktionen.getPathJar() + "bin/flvstreamer_macosx_intel_32bit_latest";
                break;
            }
            default: {
                pfad = Funktionen.getPathJar() + "bin\\flvstreamer_win32_latest.exe";
            }
        }
        if (new File(pfad).exists()) {
            return pfad;
        }
        return "";
    }

    public static String getPfadMplayer() {
        if (Daten.system[35].equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(false, false, true), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.system[35];
    }

    public static String getPfadVlc() {
        if (Daten.system[33].equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(true, false, false), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.system[33];
    }

    public static String getPfadFlv() {
        if (Daten.system[34].equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(false, true, false), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.system[34];
    }

    public static String getPfadScript() {
        String pfadScript;
        String PFAD_LINUX_SCRIPT = "bin/flv.sh";
        String PFAD_WINDOWS_SCRIPT = "bin\\flv.bat";
        switch (GuiFunktionenProgramme.getOs()) {
            case 3: {
                pfadScript = GuiFunktionenProgramme.getPathJar() + "bin/flv.sh";
                break;
            }
            case 4: {
                pfadScript = GuiFunktionenProgramme.getPathJar() + "bin/flv.sh";
                break;
            }
            default: {
                pfadScript = GuiFunktionenProgramme.getPathJar() + "bin\\flv.bat";
            }
        }
        return pfadScript;
    }

    public static ListePset getStandardprogramme(DDaten ddaten) {
        InputStream datei;
        switch (GuiFunktionenProgramme.getOs()) {
            case 3: {
                datei = new GetFile().getPsetVorlageLinux();
                break;
            }
            case 4: {
                datei = new GetFile().getPsetVorlageMac();
                break;
            }
            default: {
                datei = new GetFile().getPsetVorlageWindows();
            }
        }
        ListePset pSet = IoXmlLesen.importPset(datei, true);
        return pSet;
    }

    public static boolean addVorlagen(DDaten ddaten, ListePset pSet, boolean auto) {
        if (pSet != null) {
            if (!auto) {
                DialogImportPset dialog = new DialogImportPset(null, true, ddaten, pSet);
                dialog.setVisible(true);
                if (!dialog.ok) {
                    return false;
                }
            }
            if (ddaten.listePset.addPset(pSet)) {
                ListenerMediathekView.notify(3, GuiFunktionenProgramme.class.getSimpleName());
                JOptionPane.showMessageDialog(null, pSet.size() + " Programmset importiert!", "Ok", 1);
            }
            return true;
        }
        JOptionPane.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
        return false;
    }

    public static boolean praefixTesten(String str, String uurl, boolean praefix) {
        boolean ret = false;
        String url = uurl.toLowerCase();
        String s1 = "";
        if (str.equals("")) {
            ret = true;
        } else {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') {
                    s1 = s1 + str.charAt(i);
                }
                if (str.charAt(i) != ',' && i < str.length() - 1) continue;
                if (praefix) {
                    if (url.startsWith(s1.toLowerCase())) {
                        ret = true;
                        break;
                    }
                } else if (url.endsWith(s1.toLowerCase())) {
                    ret = true;
                    break;
                }
                s1 = "";
            }
        }
        return ret;
    }

    public static boolean checkPfadBeschreibbar(String pfad) {
        boolean ret = false;
        File testPfad = new File(pfad);
        try {
            if (!testPfad.exists()) {
                testPfad.mkdirs();
            }
            if (!pfad.equals("") && testPfad.isDirectory() && testPfad.canWrite()) {
                File tmpFile = File.createTempFile("mediathek", "tmp", testPfad);
                tmpFile.delete();
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean programmePruefen(DDaten daten) {
        String PIPE = "| ";
        String LEER = "      ";
        String PFEIL = " -> ";
        boolean ret = true;
        String text = "";
        for (DatenPset datenPset : daten.listePset) {
            ret = true;
            if (datenPset.isFreeLine() || datenPset.isLable()) continue;
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n";
            text = text + "| Programmgruppe: " + datenPset.arr[0] + "\n";
            String zielPfad = datenPset.arr[4];
            if (datenPset.progsContainPath()) {
                if (zielPfad.equals("")) {
                    ret = false;
                    text = text + "|       Zielpfad fehlt!\n";
                } else if (!GuiFunktionenProgramme.checkPfadBeschreibbar(zielPfad)) {
                    ret = false;
                    text = text + "|       Falscher Zielpfad!\n";
                    text = text + "|        -> Zielpfad \"" + zielPfad + "\" nicht beschreibbar!" + "\n";
                }
            }
            for (DatenProg datenProg : datenPset.getListeProg()) {
                if (new File(datenProg.arr[2]).canExecute()) continue;
                ret = false;
                text = text + "|       Falscher Programmpfad!\n";
                text = text + "|        -> Programmname: " + datenProg.arr[0] + "\n";
                text = text + "|             Pfad: " + datenProg.arr[2] + "\n";
                if (datenProg.arr[2].contains(File.separator)) continue;
                text = text + "|        -> Wenn das Programm nicht im Systempfad liegt, \n";
                text = text + "|             wird der Start nicht klappen!\n";
            }
            if (ret) {
                text = text + "|  -> Ok!\n";
            }
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n\n\n";
        }
        new DialogHilfe(null, true, text).setVisible(true);
        return ret;
    }
}

