/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.tool.DatumZeit;
import mediathek.tool.Funktionen;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.Log;

public class GuiFunktionen
extends Funktionen {
    public static boolean setLook(JFrame frame) {
        int look;
        if (DDaten.system[1].equals("")) {
            DDaten.system[1] = "0";
        }
        if ((look = Integer.parseInt(DDaten.system[1])) != 0) {
            return GuiFunktionen.setLook(frame, look);
        }
        return true;
    }

    public static boolean setLook(JFrame frame, int look) {
        boolean ret = false;
        try {
            switch (look) {
                case 0: 
                case 1: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break;
                }
                default: {
                    UIManager.setLookAndFeel(GuiKonstanten.THEME[look][1]);
                }
            }
            SwingUtilities.updateComponentTreeUI(frame);
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
            ret = true;
        }
        catch (Exception e) {
            Log.fehlerMeldung(305964198, 0, "GuiFunktionen.setLook", e, "Kann das Look and Feel nicht \u00e4ndern!");
        }
        return ret;
    }

    public static void copyToClipboard(String s) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
    }

    public static void setProxy(DDaten daten) {
        if (Boolean.parseBoolean(DDaten.system[17])) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", DDaten.system[13]);
            System.setProperty("http.proxyPort", DDaten.system[14]);
            System.setProperty("http.proxyUser", DDaten.system[15]);
            System.setProperty("http.proxyPassword", DDaten.system[16]);
        } else {
            System.setProperty("proxySet", "false");
        }
    }

    public static String replaceString(String s, DatenFilm film) {
        s = s.replace("%D", film.arr[4].equals("") ? DatumZeit.getHeute_yyyyMMdd() : GuiFunktionen.datumDatumZeitReinigen(GuiFunktionen.datumDrehen(film.arr[4])));
        s = s.replace("%d", film.arr[5].equals("") ? DatumZeit.getJetzt_HHMMSS() : GuiFunktionen.datumDatumZeitReinigen(film.arr[5]));
        s = s.replace("%t", film.arr[2]);
        s = s.replace("%T", film.arr[3]);
        s = s.replace("%s", film.arr[1]);
        s = s.replace("%H", DatumZeit.getHeute_yyyyMMdd());
        s = s.replace("%h", DatumZeit.getJetzt_HHMMSS());
        s = s.replace("%N", GuiFunktionen.getDateiName(film.arr[6]));
        return s;
    }

    private static String datumDrehen(String datum) {
        String ret = "";
        if (!datum.equals("")) {
            try {
                if (datum.length() == 10) {
                    String tmp = datum.substring(6);
                    tmp = tmp + "." + datum.substring(3, 5);
                    ret = tmp = tmp + "." + datum.substring(0, 2);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(775421006, 0, "DatenFilm.datumDrehen", ex, datum);
            }
        }
        return ret;
    }

    private static String datumDatumZeitReinigen(String datum) {
        String ret = datum;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }

    public static String replaceLeerDateiname(String pfad, boolean pfadtrennerEntfernen, boolean leerEntfernen) {
        String ret = pfad;
        boolean winPfad = false;
        if (pfad.length() > 3 && pfad.substring(1, 3).equals(":\\")) {
            winPfad = true;
        }
        if (pfadtrennerEntfernen) {
            ret = ret.replace("\\", "-");
            ret = ret.replace("/", "-");
        } else {
            String sl = File.separator.equals("\\") ? "/" : "\\";
            ret = ret.replace(sl, "-");
        }
        if (leerEntfernen) {
            ret = ret.replace(" ", "_");
        }
        ret = ret.replace("\n", "_");
        ret = ret.replace("\"", "_");
        ret = ret.replace(",", "_");
        ret = ret.replace(";", "_");
        ret = ret.replace("(", "_");
        ret = ret.replace(")", "_");
        ret = ret.replace("*", "_");
        ret = ret.replace("?", "_");
        ret = ret.replace("<", "_");
        ret = ret.replace(">", "_");
        ret = ret.replace(":", "_");
        ret = ret.replace("'", "_");
        ret = ret.replace("|", "_");
        ret = GuiFunktionen.getAscii(ret);
        if (winPfad) {
            ret = ret.substring(0, 1) + ":\\" + ret.substring(3);
        }
        return ret;
    }

    private static String getAscii(String ret) {
        String r = "";
        if (!Boolean.parseBoolean(Daten.system[40])) {
            return ret;
        }
        ret = ret.replace("\u00e4", "ae");
        ret = ret.replace("\u00f6", "oe");
        ret = ret.replace("\u00fc", "ue");
        ret = ret.replace("\u00c4", "Ae");
        ret = ret.replace("\u00d6", "Oe");
        ret = ret.replace("\u00dc", "Ue");
        for (int i = 0; i < ret.length(); ++i) {
            char c = ret.charAt(i);
            r = c < '\u007f' ? r + c : r + "_";
        }
        return r;
    }

    public static String addsPfad(String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null && !pfad1.equals("") && !pfad2.equals("")) {
            ret = pfad1.endsWith(File.separator) ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
            ret = pfad2.charAt(0) == File.separatorChar ? ret + pfad2 : ret + File.separator + pfad2;
        }
        if (ret.equals("")) {
            Log.fehlerMeldung(283946015, 0, "GuiFunktionen.addsPfad", pfad1 + " - " + pfad2);
        }
        return ret;
    }

    public static String addUrl(String u1, String u2) {
        if (u1.endsWith("/")) {
            return u1 + u2;
        }
        return u1 + "/" + u2;
    }

    public static boolean istUrl(String dateiUrl) {
        return dateiUrl.startsWith("http") ? true : dateiUrl.startsWith("www");
    }

    public static String getDateiName(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.equals("")) {
            ret = pfad.substring(pfad.lastIndexOf("/") + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf("?"));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf("&"));
        }
        if (ret.equals("")) {
            Log.fehlerMeldung(395019631, 0, "GuiFunktionen.getDateiName", pfad);
        }
        return ret;
    }

    public static void listeSort(LinkedList<String> liste) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        Collections.sort(liste, sorter);
    }

    public static String getHomePath() {
        return System.getProperty("user.home");
    }

    public static String getStandardDownloadPath() {
        if (GuiFunktionen.getOs() == 4) {
            return GuiFunktionen.addsPfad(GuiFunktionen.getHomePath(), "Desktop");
        }
        return GuiFunktionen.addsPfad(GuiFunktionen.getHomePath(), "MediathekView");
    }

    public static String[] addLeerListe(String[] str) {
        int len = str.length + 1;
        String[] liste = new String[len];
        liste[0] = "";
        for (int i = 1; i < len; ++i) {
            liste[i] = str[i - 1];
        }
        return liste;
    }

    public static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (text.length() > max) {
            text = mitte ? text.substring(0, 25) + " .... " + text.substring(text.length() - (max - 31)) : text.substring(0, max - 1);
        }
        while (text.length() < max) {
            if (addVorne) {
                text = " " + text;
                continue;
            }
            text = text + " ";
        }
        return text;
    }

    public static int getImportArtFilme() {
        int ret;
        try {
            ret = Integer.parseInt(DDaten.system[29]);
        }
        catch (Exception ex) {
            Daten.system[29] = String.valueOf(2);
            ret = 2;
        }
        return ret;
    }
}

