/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.security.CodeSource;
import java.util.ResourceBundle;
import mediathek.Main;
import mediathek.tool.Log;

public class Funktionen {
    public static final int OS_UNKNOWN = 0;
    public static final int OS_WIN_32BIT = 1;
    public static final int OS_WIN_64BIT = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_MAC = 4;

    public static int getOs() {
        int os = 0;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            if (System.getenv("ProgramFiles") != null) {
                os = 1;
            } else if (System.getenv("ProgramFiles(x86)") != null) {
                os = 2;
            }
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            os = 3;
        } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            os = 4;
        }
        return os;
    }

    public static String getPathJar() {
        String pFilePath = "pFile";
        File propFile = new File(pFilePath);
        if (!propFile.exists()) {
            try {
                CodeSource cS = Main.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(cS.getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                propFile = new File(jarDir + File.separator + pFilePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return propFile.getAbsolutePath().replace(pFilePath, "");
    }

    public static String getProgVersionString() {
        return "MediathekView 3.1.0  [Buildnummer: " + Funktionen.getBuildNr() + "]";
    }

    public static String getCompileDate() {
        String propToken = "DATE";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle("version");
            msg = rb.getString(propToken);
        }
        catch (Exception e) {
            Log.fehlerMeldung(807293847, 0, Funktionen.class.getName(), e);
        }
        return msg;
    }

    public static String getBuildNr() {
        String propToken = "BUILD";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle("version");
            msg = rb.getString(propToken);
        }
        catch (Exception e) {
            Log.fehlerMeldung(134679898, 0, Funktionen.class.getName(), e);
        }
        return msg;
    }
}

