/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.controller.io.ProgrammUpdateSuchen;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.ListenerMediathekView;

public class PanelEinstellungen
extends PanelVorlage {
    private ButtonGroup buttonGroup1;
    private JButton jButtonAnzahl;
    private JButton jButtonHilfe;
    private JButton jButtonInfos;
    private JButton jButtonName;
    private JButton jButtonSuchen;
    private JCheckBox jCheckBoxAboSuchen;
    private JCheckBox jCheckBoxEchtzeit;
    private JCheckBox jCheckBoxNurAscii;
    private JCheckBox jCheckBoxSuchen;
    private JComboBox jComboBoxLook;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JRadioButton jRadioButtonAuto;
    private JRadioButton jRadioButtonManuel;
    private JSpinner jSpinnerDownload;
    private JTextField jTextFieldAuto;
    private JTextField jTextFieldUserAgent;

    public PanelEinstellungen(DDaten d) {
        super(d);
        this.initComponents();
        this.ddaten = d;
        this.init();
        this.jCheckBoxEchtzeit.addActionListener(new BeobCheckBox());
        this.jSpinnerDownload.addChangeListener(new BeobSpinnerDownload());
        String[] theme = new String[GuiKonstanten.THEME.length];
        for (int i = 0; i < GuiKonstanten.THEME.length; ++i) {
            theme[i] = GuiKonstanten.THEME[i][0];
        }
        this.jComboBoxLook.setModel(new DefaultComboBoxModel<String>(theme));
        if (Daten.system[1].equals("")) {
            Daten.system[1] = "0";
        }
        this.jComboBoxLook.setSelectedIndex(Integer.parseInt(Daten.system[1]));
        this.jComboBoxLook.addActionListener(new BeobLook());
        this.jButtonName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(null, true, "\nDie Dateinamen der Filme\ndie gespeichert werden,\nenthalten nur noch ASCII-Zeichen.\n\nSonderzeichen werden durch \"_\" \nund Umlaute zB. \u00e4 mit ae ersetzt.").setVisible(true);
            }
        });
        this.jButtonAnzahl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(null, true, "\nHier kann angegeben werden, wie viele\nDownloads gleichzeitig gestartet werden.\nEs gibt jedoch noch eine Begrenzung \nauf 2 Downloads pro Server\ndie trotzdem nicht \u00fcberschritten wird.").setVisible(true);
            }
        });
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(null, true, "\nDieser Text wird als User-Agent\nan den Webserver \u00fcbertragen. Das enstpricht\nder Kennung die auch die Browser senden.").setVisible(true);
            }
        });
        this.jRadioButtonAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEinstellungen.this.setUserAgent();
            }
        });
        this.jRadioButtonManuel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEinstellungen.this.setUserAgent();
            }
        });
        this.jTextFieldUserAgent.getDocument().addDocumentListener(new BeobUserAgent());
        ListenerMediathekView.addListener(new ListenerMediathekView(6, PanelEinstellungen.class.getSimpleName()){

            @Override
            public void ping() {
                PanelEinstellungen.this.init();
            }
        });
        this.jCheckBoxSuchen.addActionListener(new BeobCheckBoxSuchen());
        this.jButtonSuchen.addActionListener(new BeobSuchen(false));
        this.jButtonInfos.addActionListener(new BeobSuchen(true));
        this.jCheckBoxAboSuchen.setSelected(Boolean.parseBoolean(Daten.system[39]));
        this.jCheckBoxAboSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.system[39] = Boolean.toString(PanelEinstellungen.this.jCheckBoxAboSuchen.isSelected());
            }
        });
        this.jCheckBoxNurAscii.setSelected(Boolean.parseBoolean(Daten.system[40]));
        this.jCheckBoxNurAscii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.system[40] = Boolean.toString(PanelEinstellungen.this.jCheckBoxNurAscii.isSelected());
            }
        });
    }

    private void init() {
        this.jCheckBoxSuchen.setSelected(Boolean.parseBoolean(Daten.system[27]));
        this.jCheckBoxEchtzeit.setSelected(Boolean.parseBoolean(Daten.system[0]));
        this.jTextFieldAuto.setText("MediathekView 3.1.0");
        this.jTextFieldUserAgent.setText(Daten.system[3]);
        if (Daten.isUserAgentAuto()) {
            this.jRadioButtonAuto.setSelected(true);
        } else {
            this.jRadioButtonManuel.setSelected(true);
        }
        this.jTextFieldUserAgent.setEditable(this.jRadioButtonManuel.isSelected());
        if (Daten.system[18].equals("")) {
            this.jSpinnerDownload.setValue(1);
            Daten.system[18] = "1";
        } else {
            this.jSpinnerDownload.setValue(Integer.parseInt(Daten.system[18]));
        }
    }

    private void setUserAgent() {
        if (this.jRadioButtonAuto.isSelected()) {
            Daten.setUserAgentAuto();
        } else {
            Daten.setUserAgentManuel(this.jTextFieldUserAgent.getText());
        }
        this.jTextFieldUserAgent.setEditable(this.jRadioButtonManuel.isSelected());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinnerDownload = new JSpinner();
        this.jCheckBoxEchtzeit = new JCheckBox();
        this.jCheckBoxAboSuchen = new JCheckBox();
        this.jButtonAnzahl = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextFieldUserAgent = new JTextField();
        this.jButtonHilfe = new JButton();
        this.jRadioButtonAuto = new JRadioButton();
        this.jRadioButtonManuel = new JRadioButton();
        this.jTextFieldAuto = new JTextField();
        this.jPanel7 = new JPanel();
        this.jCheckBoxSuchen = new JCheckBox();
        this.jButtonSuchen = new JButton();
        this.jButtonInfos = new JButton();
        this.jPanel2 = new JPanel();
        this.jComboBoxLook = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jCheckBoxNurAscii = new JCheckBox();
        this.jButtonName = new JButton();
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel3.setText("Download(s) gleichzeitig Laden");
        this.jSpinnerDownload.setModel(new SpinnerNumberModel(1, 1, 9, 1));
        this.jCheckBoxEchtzeit.setText("Echtzeitsuche im Suchfeld \"Titel/Thema\"");
        this.jCheckBoxAboSuchen.setText("beim Neuladen der Filmliste, Abos automatisch suchen");
        this.jButtonAnzahl.setText("Hilfe");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jSpinnerDownload, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnzahl)).addComponent(this.jCheckBoxAboSuchen).addComponent(this.jCheckBoxEchtzeit)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxEchtzeit).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAboSuchen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jSpinnerDownload, -2, -1, -2).addComponent(this.jButtonAnzahl)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("User-Agent"));
        this.jButtonHilfe.setText("Hilfe");
        this.buttonGroup1.add(this.jRadioButtonAuto);
        this.jRadioButtonAuto.setText("Auto:");
        this.buttonGroup1.add(this.jRadioButtonManuel);
        this.jTextFieldAuto.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonManuel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUserAgent)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(13, 13, 13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jRadioButtonAuto).addComponent(this.jTextFieldAuto, -2, -1, -2).addComponent(this.jButtonHilfe)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jRadioButtonManuel).addComponent(this.jTextFieldUserAgent, -2, -1, -2)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jButtonHilfe, this.jTextFieldAuto, this.jTextFieldUserAgent);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Programmupdate"));
        this.jCheckBoxSuchen.setText("Einmal am Tag nach einer neuen Programmversion suchen");
        this.jButtonSuchen.setText("Jetzt suchen");
        this.jButtonInfos.setText("Programminfos anzeigen");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSuchen).addGroup(jPanel7Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonInfos).addComponent(this.jButtonSuchen)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.linkSize(0, this.jButtonInfos, this.jButtonSuchen);
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jCheckBoxSuchen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSuchen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonInfos).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Look and Feel:"));
        this.jComboBoxLook.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxLook, 0, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxLook, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Dateiname der gespeicherten Filme"));
        this.jCheckBoxNurAscii.setText("nur ASCII-Zeichen erlauben");
        this.jButtonName.setText("Hilfe");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxNurAscii).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonName).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxNurAscii).addComponent(this.jButtonName)).addContainerGap(13, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel7, -2, 124, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(48, Short.MAX_VALUE)));
    }

    private class BeobSuchen
    implements ActionListener {
        private boolean infos = false;

        public BeobSuchen(boolean iinfos) {
            this.infos = iinfos;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ProgrammUpdateSuchen().checkVersion(PanelEinstellungen.this.ddaten, !this.infos, this.infos, true);
        }
    }

    private class BeobCheckBoxSuchen
    implements ActionListener {
        private BeobCheckBoxSuchen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Daten.system[27] = Boolean.toString(PanelEinstellungen.this.jCheckBoxSuchen.isSelected());
        }
    }

    private class BeobLook
    implements ActionListener {
        private BeobLook() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GuiFunktionen.setLook(PanelEinstellungen.this.ddaten.mediathekGui, Integer.parseInt(String.valueOf(PanelEinstellungen.this.jComboBoxLook.getSelectedIndex())))) {
                Daten.system[1] = String.valueOf(PanelEinstellungen.this.jComboBoxLook.getSelectedIndex());
            } else {
                Daten.system[1] = "0";
                PanelEinstellungen.this.jComboBoxLook.setSelectedIndex(0);
                GuiFunktionen.setLook(PanelEinstellungen.this.ddaten.mediathekGui, 0);
            }
        }
    }

    private class BeobCheckBox
    implements ActionListener {
        private BeobCheckBox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Daten.system[0] = Boolean.toString(PanelEinstellungen.this.jCheckBoxEchtzeit.isSelected());
        }
    }

    private class BeobUserAgent
    implements DocumentListener {
        private BeobUserAgent() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Daten.setUserAgentManuel(PanelEinstellungen.this.jTextFieldUserAgent.getText());
        }
    }

    private class BeobSpinnerDownload
    implements ChangeListener {
        private BeobSpinnerDownload() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            Daten.system[18] = String.valueOf(((Number)PanelEinstellungen.this.jSpinnerDownload.getModel().getValue()).intValue());
            ListenerMediathekView.notify(6, PanelEinstellungen.class.getSimpleName());
        }
    }
}

