/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.ListePset;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.gui.dialogEinstellungen.PanelPsetKurz;
import mediathek.gui.dialogEinstellungen.PanelPsetLang;
import mediathek.tool.GuiFunktionenProgramme;

public class DialogStarteinstellungen
extends JDialog {
    DDaten ddaten;
    private final int STAT_START = 1;
    private final int STAT_PFAD = 2;
    private final int STAT_PSET = 3;
    private final int STAT_FERTIG = 4;
    private int status = 1;
    private JButton jButtonStandard;
    private JCheckBox jCheckBoxAlleEinstellungen;
    private JCheckBox jCheckBoxAnpassen;
    private JCheckBox jCheckBoxSuchen;
    private JPanel jPanel2;
    private JPanel jPanel7;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;

    public DialogStarteinstellungen(Frame parent, boolean modal, DDaten dd) {
        super(parent, modal);
        this.initComponents();
        this.ddaten = dd;
        this.setTitle("Erster Start");
        this.jButtonStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStarteinstellungen.this.jCheckBoxAnpassen.setVisible(false);
                DialogStarteinstellungen.this.weiter();
            }
        });
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStarteinstellungen.this.status = 3;
                DialogStarteinstellungen.this.weiter();
            }
        });
        this.jCheckBoxSuchen.setSelected(true);
        Daten.system[27] = Boolean.TRUE.toString();
        this.jCheckBoxSuchen.addActionListener(new BeobCheckBoxSuchen());
        Daten.system[35] = GuiFunktionenProgramme.getMusterPfadMplayer();
        Daten.system[33] = GuiFunktionenProgramme.getMusterPfadVlc();
        Daten.system[34] = GuiFunktionenProgramme.getMusterPfadFlv();
    }

    private void weiter() {
        switch (this.status) {
            case 1: {
                this.statusStart();
                break;
            }
            case 2: {
                this.statusPfade();
                break;
            }
            case 3: {
                this.statusPset();
                break;
            }
            default: {
                this.beenden();
            }
        }
    }

    private void statusStart() {
        this.jButtonStandard.setText("Weiter");
        if (Daten.system[33].equals("") || Daten.system[34].equals("")) {
            this.status = 2;
        } else if (this.jCheckBoxAnpassen.isSelected()) {
            this.status = 2;
        } else {
            ListePset pSet = GuiFunktionenProgramme.getStandardprogramme(this.ddaten);
            if (pSet != null) {
                this.ddaten.listePset.addPset(pSet);
                this.status = 4;
            } else {
                this.status = 3;
            }
        }
        this.weiter();
    }

    private void statusPfade() {
        this.jCheckBoxAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        this.jScrollPane1.setViewportView(new PanelProgrammPfade(true, true, false));
        this.status = 3;
        this.jButtonStandard.setText("Weiter");
    }

    private void statusPset() {
        this.jCheckBoxAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(true);
        if (this.ddaten.listePset.size() == 0) {
            this.ddaten.listePset.addPset(GuiFunktionenProgramme.getStandardprogramme(this.ddaten));
        }
        if (this.jCheckBoxAlleEinstellungen.isSelected()) {
            this.jScrollPane1.setViewportView(new PanelPsetLang(this.ddaten, this.ddaten.listePset));
        } else {
            this.jScrollPane1.setViewportView(new PanelPsetKurz(this.ddaten, this.ddaten.listePset));
        }
        this.status = 4;
        this.jButtonStandard.setText("Weiter");
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jButtonStandard = new JButton();
        this.jCheckBoxAlleEinstellungen = new JCheckBox();
        this.jCheckBoxAnpassen = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jPanel7 = new JPanel();
        this.jCheckBoxSuchen = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 255), 3));
        this.jButtonStandard.setText("Mit Standardeinstellungen starten");
        this.jCheckBoxAlleEinstellungen.setText("alle Einstellungen anzeigen");
        this.jCheckBoxAnpassen.setText("vorher anpassen");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAlleEinstellungen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxAnpassen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonStandard).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonStandard).addComponent(this.jCheckBoxAlleEinstellungen).addComponent(this.jCheckBoxAnpassen)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Programmupdate"));
        this.jCheckBoxSuchen.setSelected(true);
        this.jCheckBoxSuchen.setText("Einmal am Tag nach einer neuen Programmversion suchen");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxSuchen).addContainerGap(324, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jCheckBoxSuchen).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelExtraLayout.createSequentialGroup().addContainerGap(675, Short.MAX_VALUE).addComponent(this.jPanel7, -2, -1, -2).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private class BeobCheckBoxSuchen
    implements ActionListener {
        private BeobCheckBoxSuchen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Daten.system[27] = Boolean.toString(DialogStarteinstellungen.this.jCheckBoxSuchen.isSelected());
        }
    }
}

