/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.File;
import mediathek.controller.io.AsxLesen;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.tool.DatumZeit;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.Log;

public class DatenDownload
implements Comparable<DatenDownload> {
    public static final int PROGRESS_NICHT_GESTARTET = -1;
    public static final int PROGRESS_WARTEN = 0;
    public static final int PROGRESS_GESTARTET = 1;
    public static final int PROGRESS_FERTIG = 1000;
    public static final String DOWNLOAD_NR = "Nr";
    public static final int DOWNLOAD_NR_NR = 0;
    public static final String DOWNLOAD_FILM_NR = "Filmnr";
    public static final int DOWNLOAD_FILM_NR_NR = 1;
    public static final String DOWNLOAD_ABO = "Abo";
    public static final int DOWNLOAD_ABO_NR = 2;
    public static final String DOWNLOAD_SENDER = "Sender";
    public static final int DOWNLOAD_SENDER_NR = 3;
    public static final String DOWNLOAD_THEMA = "Thema";
    public static final int DOWNLOAD_THEMA_NR = 4;
    public static final String DOWNLOAD_TITEL = "Titel";
    public static final int DOWNLOAD_TITEL_NR = 5;
    public static final String DOWNLOAD_PROGRESS = "Fortschritt";
    public static final int DOWNLOAD_PROGRESS_NR = 6;
    public static final String DOWNLOAD_DATUM = "Datum";
    public static final int DOWNLOAD_DATUM_NR = 7;
    public static final String DOWNLOAD_ZEIT = "Zeit";
    public static final int DOWNLOAD_ZEIT_NR = 8;
    public static final String DOWNLOAD_URL = "URL";
    public static final int DOWNLOAD_URL_NR = 9;
    public static final String DOWNLOAD_URL_AUTH = "URL-Auth";
    public static final int DOWNLOAD_URL_AUTH_NR = 10;
    public static final String DOWNLOAD_URL_RTMP = "URL-rtmp";
    public static final int DOWNLOAD_URL_RTMP_NR = 11;
    public static final String DOWNLOAD_PROGRAMMSET = "Programmset";
    public static final int DOWNLOAD_PROGRAMMSET_NR = 12;
    public static final String DOWNLOAD_PROGRAMM = "Programm";
    public static final int DOWNLOAD_PROGRAMM_NR = 13;
    public static final String DOWNLOAD_PROGRAMM_AUFRUF = "Programmaufruf";
    public static final int DOWNLOAD_PROGRAMM_AUFRUF_NR = 14;
    public static final String DOWNLOAD_PROGRAMM_RESTART = "Restart";
    public static final int DOWNLOAD_PROGRAMM_RESTART_NR = 15;
    public static final String DOWNLOAD_ZIEL_DATEINAME = "Dateiname";
    public static final int DOWNLOAD_ZIEL_DATEINAME_NR = 16;
    public static final String DOWNLOAD_ZIEL_PFAD = "Pfad";
    public static final int DOWNLOAD_ZIEL_PFAD_NR = 17;
    public static final String DOWNLOAD_ZIEL_PFAD_DATEINAME = "Pfad-Dateiname";
    public static final int DOWNLOAD_ZIEL_PFAD_DATEINAME_NR = 18;
    public static final String DOWNLOAD_ART = "Art";
    public static final int DOWNLOAD_ART_NR = 19;
    public static final String DOWNLOAD_QUELLE = "Quelle";
    public static final int DOWNLOAD_QUELLE_NR = 20;
    public static final String DOWNLOAD_ZURUECKGESTELLT = "Zurueckgestellt";
    public static final int DOWNLOAD_ZURUECKGESTELLT_NR = 21;
    public static final String DOWNLOAD = "Downlad";
    public static final int DOWNLOAD_MAX_ELEM = 22;
    public static final String[] DOWNLOAD_COLUMN_NAMES = new String[]{"Nr", "Filmnr", "Abo", "Sender", "Thema", "Titel", "Fortschritt", "Datum", "Zeit", "URL", "URL-Auth", "URL-rtmp", "Programmset", "Programm", "Programmaufruf", "Restart", "Dateiname", "Pfad", "Pfad-Dateiname", "Art", "Quelle", "Zurueckgestellt"};
    public String[] arr;

    public DatenDownload() {
        this.makeArr();
    }

    public DatenDownload(DatenPset pSet, DatenFilm film, int quelle, DatenAbo abo, String name, String pfad) {
        this.makeArr();
        this.arr[1] = film.arr[0];
        this.arr[3] = film.arr[1];
        this.arr[4] = film.arr[2];
        this.arr[5] = film.arr[3];
        this.arr[9] = film.arr[6];
        this.arr[10] = film.arr[8];
        this.arr[7] = film.arr[4];
        this.arr[8] = film.arr[5];
        this.arr[11] = film.arr[7];
        this.arr[20] = String.valueOf(quelle);
        this.aufrufBauen(pSet, film, abo, name, pfad);
    }

    public boolean istZurueckgestellt() {
        return this.arr[21].equals(Boolean.TRUE.toString());
    }

    public void zurueckstellen() {
        this.arr[21] = Boolean.TRUE.toString();
    }

    public void startMelden(int status) {
        this.arr[6] = String.valueOf(status);
        ListenerMediathekView.notify(13, DatenDownload.class.getName());
    }

    public void starten(DDaten ddaten) {
        ddaten.starterClass.addStarts(new Start(this));
        this.startMelden(0);
    }

    public DatenDownload getCopy() {
        DatenDownload ret = new DatenDownload();
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        return ret;
    }

    public void aufMichKopieren(DatenDownload datenDownload) {
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = new String(datenDownload.arr[i]);
        }
    }

    public boolean istAbo() {
        return !this.arr[2].equals("");
    }

    public int getArt() {
        try {
            return Integer.parseInt(this.arr[19]);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(946325800, 0, this.getClass().getName(), ex);
            return 2;
        }
    }

    public int getQuelle() {
        try {
            return Integer.parseInt(this.arr[20]);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(649632580, 0, this.getClass().getName(), ex);
            return 1;
        }
    }

    public boolean isRestart() {
        if (this.arr[15].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[15]);
    }

    private void aufrufBauen(DatenPset pSet, DatenFilm film, DatenAbo abo, String nname, String ppfad) {
        try {
            DatenProg programm = pSet.getProgUrl(this.arr[9]);
            pSet.arr[5] = pSet.arr[5].replace("%n", "");
            pSet.arr[5] = pSet.arr[5].replace("%p", "");
            pSet.arr[4] = pSet.arr[4].replace("%n", "");
            pSet.arr[4] = pSet.arr[4].replace("%p", "");
            for (DatenProg prog : pSet.getListeProg()) {
                prog.arr[1] = prog.arr[1].replace("%n", "");
                prog.arr[1] = prog.arr[1].replace("%p", "");
            }
            this.arr[12] = pSet.arr[0];
            int art = pSet.checkDownloadDirekt(this.arr[9]);
            this.arr[19] = String.valueOf(art);
            this.arr[13] = art == 1 ? "direkter Download" : programm.arr[0];
            this.arr[15] = String.valueOf(programm.isRestart());
            this.dateinamePfadBauen(pSet, film, abo, nname, ppfad);
            this.programmaufrufBauen(programm);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(825600145, 0, this.getClass().getName(), ex);
        }
    }

    private void dateinamePfadBauen(DatenPset pSet, DatenFilm film, DatenAbo abo, String nname, String ppfad) {
        String pfad;
        String name;
        if (!pSet.progsContainPath()) {
            this.arr[16] = "";
            this.arr[17] = "";
            return;
        }
        if (!nname.equals("")) {
            name = nname;
        } else {
            this.arr[16] = pSet.getZielDateiname(this.arr[9]);
            name = this.arr[16];
            if (name.equals("")) {
                name = DatumZeit.getHeute_yyyyMMdd() + "_" + this.arr[4] + "-" + this.arr[5] + ".mp4";
            }
            name = GuiFunktionen.replaceString(name, film);
            if ((name = GuiFunktionen.replaceLeerDateiname(name, true, true)).length() > 8) {
                String suf1 = name.substring(name.length() - 8, name.length() - 4);
                String suf2 = name.substring(name.length() - 4);
                if (suf1.startsWith(".") && suf2.startsWith(".") && suf1.equalsIgnoreCase(suf2)) {
                    name = name.substring(0, name.length() - 4);
                }
            }
            if (Boolean.parseBoolean(pSet.arr[12])) {
                int laenge = 25;
                if (!pSet.arr[13].equals("")) {
                    laenge = Integer.parseInt(pSet.arr[13]);
                }
                if (name.length() > laenge) {
                    name = name.substring(0, laenge - 4) + name.substring(name.length() - 4);
                }
            }
        }
        if (!ppfad.equals("")) {
            pfad = ppfad;
        } else {
            this.arr[17] = pSet.getZielPfad();
            pfad = this.arr[17];
            if (pfad.equals("")) {
                pfad = GuiFunktionen.getStandardDownloadPath();
            }
            if (abo != null) {
                this.arr[2] = abo.arr[2];
                if (Boolean.parseBoolean(pSet.arr[7])) {
                    pfad = GuiFunktionen.addsPfad(pfad, GuiFunktionen.replaceLeerDateiname(abo.arr[7], true, true));
                }
            } else if (Boolean.parseBoolean(pSet.arr[7])) {
                pfad = GuiFunktionen.addsPfad(pfad, GuiFunktionen.replaceLeerDateiname(this.arr[4], true, true));
            }
            pfad = GuiFunktionen.replaceString(pfad, film);
            pfad = GuiFunktionen.replaceLeerDateiname(pfad, false, false);
        }
        if (pfad.endsWith(File.separator)) {
            pfad = pfad.substring(0, pfad.length() - 1);
        }
        this.arr[16] = name;
        this.arr[17] = pfad;
        this.arr[18] = GuiFunktionen.addsPfad(pfad, name);
    }

    private void programmaufrufBauen(DatenProg programm) {
        String befehlsString = programm.getProgrammAufruf();
        befehlsString = befehlsString.replace("**", this.arr[18]);
        befehlsString = befehlsString.replace("%f", this.arr[9]);
        befehlsString = befehlsString.replace("%F", this.getUrlFlvstreamer());
        if ((befehlsString = befehlsString.replace("%k", this.getUrlLow())).contains("%x")) {
            befehlsString = befehlsString.replace("%x", AsxLesen.lesen(this.arr[9]));
        }
        if (this.arr[10].equals("")) {
            befehlsString = befehlsString.replace("%a", "");
            befehlsString = befehlsString.replace("%A", "");
        } else {
            befehlsString = befehlsString.replace("%a", this.arr[10]);
            befehlsString = befehlsString.replace("%A", "-W " + this.arr[10]);
        }
        this.arr[14] = this.getArt() == 1 ? "" : befehlsString;
    }

    private String getUrlFlvstreamer() {
        String ret = !this.arr[11].equals("") ? this.arr[11] : (this.arr[9].startsWith("rtmp") ? "-r " + this.arr[9] : this.arr[9]);
        return ret;
    }

    private String getUrlLow() {
        String ret = this.arr[9];
        if (this.arr[3].equalsIgnoreCase("SWR")) {
            ret = this.arr[9].replace(".m.mp4", ".l.mp4");
        } else if (this.arr[3].equalsIgnoreCase("3Sat") || this.arr[3].equalsIgnoreCase("ZDF")) {
            ret = this.arr[9].replace("1596k_p13v9.mp4", "51k_p7v9.mp4");
        } else if (this.arr[3].equalsIgnoreCase("NDR")) {
            ret = this.arr[9].replace(".hq.", ".lo.");
        }
        return ret;
    }

    @Override
    public int compareTo(DatenDownload arg0) {
        int ret = 0;
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        ret = sorter.compare(this.arr[3], arg0.arr[3]);
        if (ret == 0) {
            ret = sorter.compare(this.arr[4], arg0.arr[4]);
        }
        return ret;
    }

    private void makeArr() {
        this.arr = new String[22];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
        this.arr[6] = String.valueOf(-1);
        this.arr[21] = Boolean.FALSE.toString();
    }
}

