/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.File;
import mediathek.controller.filmeLaden.FilmeLaden;
import mediathek.controller.io.IoXmlFilmlisteLesen;
import mediathek.controller.io.IoXmlFilmlisteSchreiben;
import mediathek.daten.ListeFilme;
import mediathek.tool.Log;

public class Daten {
    public static String[] system = new String[42];
    public static boolean debug = false;
    public static boolean nogui = false;
    public static boolean auto = false;
    private static String basisverzeichnis = "";
    public static FilmeLaden filmeLaden;
    public static IoXmlFilmlisteLesen ioXmlFilmlisteLesen;
    public static ListeFilme listeFilme;
    public static final String LINE_SEPARATOR;

    public Daten(String pfad) {
        basisverzeichnis = pfad;
        this.init();
    }

    private void init() {
        for (int i = 0; i < system.length; ++i) {
            Daten.system[i] = "";
        }
        Daten.system[18] = "1";
        Daten.system[26] = "1";
        Daten.system[3] = "MediathekView 3.1.0";
        Daten.system[26] = "1";
        Daten.system[1] = "0";
        Daten.system[4] = "3.1.0";
        Daten.system[27] = Boolean.TRUE.toString();
        Daten.system[39] = Boolean.TRUE.toString();
        listeFilme = new ListeFilme();
        ioXmlFilmlisteLesen = new IoXmlFilmlisteLesen();
        filmeLaden = new FilmeLaden();
    }

    public static void setUserAgentAuto() {
        Daten.system[2] = Boolean.TRUE.toString();
    }

    public static void setUserAgentManuel(String ua) {
        Daten.system[2] = Boolean.FALSE.toString();
        Daten.system[3] = ua;
    }

    public static boolean isUserAgentAuto() {
        if (system[2].equals("")) {
            Daten.system[2] = Boolean.TRUE.toString();
            return true;
        }
        return Boolean.parseBoolean(system[2]);
    }

    public static String getUserAgent() {
        if (Daten.isUserAgentAuto()) {
            return "MediathekView 3.1.0";
        }
        return system[3];
    }

    public static String getBasisVerzeichnis() {
        return Daten.getBasisVerzeichnis(false);
    }

    public static String getBasisVerzeichnis(boolean anlegen) {
        return Daten.getBasisVerzeichnis(basisverzeichnis, anlegen);
    }

    private static String getBasisVerzeichnis(String basis, boolean anlegen) {
        File basisF;
        String ret = basis.equals("") ? System.getProperty("user.home") + File.separator + ".mediathek3" + File.separator : basis;
        if (anlegen && !(basisF = new File(ret)).exists() && !basisF.mkdir()) {
            Log.fehlerMeldung(898736548, 0, "Daten.getBasisVerzeichnis", new String[]{"Kann den Ordner zum Speichern der Daten nicht anlegen!", "Daten.getBasisVerzeichnis"});
        }
        return ret;
    }

    public void allesLaden() {
        ioXmlFilmlisteLesen.filmlisteLesen(Daten.getBasisVerzeichnis() + "filme.xml", false, listeFilme);
    }

    public void allesSpeichern() {
        new IoXmlFilmlisteSchreiben().filmeSchreiben(Daten.getBasisVerzeichnis(true) + "filme.xml", listeFilme);
    }

    static {
        ioXmlFilmlisteLesen = null;
        listeFilme = null;
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

