/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io.starter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mediathek.controller.io.starter.Start;
import mediathek.tool.Log;

class RuntimeExec {
    private static final int INPUT = 1;
    private static final int ERROR = 2;
    private String prog;
    Thread clearIn;
    Thread clearOut;
    private Process process = null;
    Start s;
    private static int procnr = 0;
    private Pattern patternFlvstreamer = Pattern.compile("([0-9.]*%)");
    private Pattern patternFfmpeg = Pattern.compile("(?<=Duration: )[^,]*");
    private Pattern patternZeit = Pattern.compile("(?<=time=)[\\d.]+");
    private double totalSecs = 0.0;
    private String zeit;
    private String prozent;

    public RuntimeExec(Start st) {
        this.s = st;
        this.prog = this.s.datenDownload.arr[14];
    }

    public RuntimeExec(String p) {
        this.prog = p;
    }

    public Process exec() {
        try {
            this.process = Runtime.getRuntime().exec(this.prog);
            this.clearIn = new Thread(new ClearInOut(1, this.process));
            this.clearOut = new Thread(new ClearInOut(2, this.process));
            this.clearIn.start();
            this.clearOut.start();
        }
        catch (Exception ex) {
            if (this.process == null) {
                // empty if block
            }
            Log.fehlerMeldung(450028932, 0, "RuntimeExec.exec", ex, "Fehler beim Starten");
        }
        return this.process;
    }

    private class ClearInOut
    implements Runnable {
        private int art;
        private BufferedReader buff;
        private InputStream in;
        private Process process;
        int percent = 0;

        public ClearInOut(int a, Process p) {
            this.art = a;
            this.process = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String titel = "";
            try {
                String inStr;
                switch (this.art) {
                    case 1: {
                        this.in = this.process.getInputStream();
                        titel = "INPUTSTREAM";
                        break;
                    }
                    case 2: {
                        this.in = this.process.getErrorStream();
                        ClearInOut clearInOut = this;
                        synchronized (clearInOut) {
                            titel = "ERRORSTREAM [" + ++procnr + "]";
                            break;
                        }
                    }
                }
                this.buff = new BufferedReader(new InputStreamReader(this.in));
                while ((inStr = this.buff.readLine()) != null) {
                    this.GetPercentageFromErrorStream(inStr);
                    Log.playerMeldung(titel + ": " + inStr);
                }
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    this.buff.close();
                }
                catch (IOException ex) {}
            }
        }

        private void GetPercentageFromErrorStream(String input) {
            Matcher matcher = RuntimeExec.this.patternFlvstreamer.matcher(input);
            if (matcher.find()) {
                try {
                    RuntimeExec.this.prozent = matcher.group();
                    RuntimeExec.this.prozent = RuntimeExec.this.prozent.substring(0, RuntimeExec.this.prozent.length() - 1);
                    double d = Double.parseDouble(RuntimeExec.this.prozent);
                    this.meldenDouble(d);
                }
                catch (Exception ex) {
                    RuntimeExec.this.s.datenDownload.startMelden(1);
                    Log.fehlerMeldung(912036780, 0, "RuntimeExec.GetPercentageFromErrorStream-1", input);
                }
            } else {
                try {
                    matcher = RuntimeExec.this.patternFfmpeg.matcher(input);
                    if (matcher.find()) {
                        String dauer = matcher.group();
                        String[] hms = dauer.split(":");
                        RuntimeExec.this.totalSecs = (double)(Integer.parseInt(hms[0]) * 3600 + Integer.parseInt(hms[1]) * 60) + Double.parseDouble(hms[2]);
                    }
                    matcher = RuntimeExec.this.patternZeit.matcher(input);
                    if (RuntimeExec.this.totalSecs > 0.0 && matcher.find()) {
                        RuntimeExec.this.zeit = matcher.group();
                        double d = Double.parseDouble(RuntimeExec.this.zeit) / RuntimeExec.this.totalSecs * 100.0;
                        this.meldenDouble(d);
                    }
                }
                catch (Exception ex) {
                    RuntimeExec.this.s.datenDownload.startMelden(1);
                    Log.fehlerMeldung(912036780, 0, "RuntimeExec.GetPercentageFromErrorStream-2", input);
                }
            }
        }

        private void meldenDouble(double d) {
            int pNeu = (int)(d *= 10.0);
            if (pNeu != this.percent) {
                this.percent = pNeu;
                RuntimeExec.this.s.datenDownload.startMelden(this.percent);
            }
        }
    }
}

