/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipInputStream;
import javax.swing.event.EventListenerList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.tool.DatumZeit;
import mediathek.tool.Log;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class IoXmlFilmlisteLesen {
    private EventListenerList listeners = new EventListenerList();
    private int max = 0;
    private int progress = 0;

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filmlisteLesen(String datei, boolean istUrl, ListeFilme listeFilme) {
        boolean ret = true;
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        InputStreamReader inReader = null;
        int timeout = 10000;
        try {
            ZipInputStream zipInputStream;
            if (!istUrl && !new File(datei).exists()) {
                boolean bl = false;
                return bl;
            }
            if (istUrl && datei.endsWith(".bz2")) {
                this.notifyStart(300);
                this.notifyProgress(datei);
            } else {
                this.notifyStart(100);
                this.notifyProgress(datei);
            }
            if (!istUrl) {
                if (datei.endsWith(".bz2")) {
                    BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream(new FileInputStream(datei));
                    inReader = new InputStreamReader((InputStream)bZip2CompressorInputStream, "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(new FileInputStream(datei));
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                }
            } else {
                URLConnection conn = new URL(datei).openConnection();
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
                conn.setRequestProperty("User-Agent", Daten.getUserAgent());
                if (datei.endsWith(".bz2")) {
                    File tmpFile = File.createTempFile("mediathek", null);
                    tmpFile.deleteOnExit();
                    BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                    FileOutputStream fOut = new FileOutputStream(tmpFile);
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    int count = 0;
                    this.notifyProgress(datei);
                    while (!Daten.filmeLaden.getStop() && (n = in.read(buffer)) != -1) {
                        fOut.write(buffer, 0, n);
                        if (++count <= 25) continue;
                        this.notifyProgress(datei);
                        count = 0;
                    }
                    fOut.close();
                    in.close();
                    inReader = new InputStreamReader((InputStream)new BZip2CompressorInputStream(new FileInputStream(tmpFile)), "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(conn.getInputStream());
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
                }
            }
            XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
            ret = this.datenFilmlisteLesen(parser, datei, listeFilme);
        }
        catch (Exception ex) {
            ret = false;
            Log.fehlerMeldung(468956200, 0, "IoXmlLesen.importDatenFilm", ex, "von: " + datei);
        }
        finally {
            try {
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(468983014, 0, "IoXmlLesen.importDatenFilm", ex);
            }
        }
        this.notifyFertig(listeFilme);
        return ret;
    }

    private boolean datenFilmlisteLesen(XMLStreamReader parser, String text, ListeFilme listeFilme) {
        boolean ret = true;
        int count = 0;
        DatenFilm datenFilmAlt = new DatenFilm();
        try {
            String filmTag = "X";
            String[] namen = DatenFilm.FILME_COLUMN_NAMES_;
            while (!Daten.filmeLaden.getStop() && parser.hasNext()) {
                int event = parser.next();
                if (event == 1 && parser.getLocalName().equals("Filmliste")) {
                    this.get(parser, "Filmliste", ListeFilme.FILMLISTE_COLUMN_NAMES, listeFilme.metaDaten);
                    if (listeFilme.metaDaten[2].startsWith("3")) {
                        filmTag = "X";
                        namen = DatenFilm.FILME_COLUMN_NAMES_;
                    } else {
                        filmTag = "Filme";
                        namen = DatenFilm.FILME_COLUMN_NAMES;
                    }
                    boolean anz = true;
                }
                if (event != 1 || !parser.getLocalName().equals(filmTag)) continue;
                DatenFilm datenFilm = new DatenFilm();
                if (!this.get(parser, filmTag, namen, datenFilm.arr)) continue;
                if (datenFilm.arr[1].equals("")) {
                    datenFilm.arr[1] = datenFilmAlt.arr[1];
                }
                if (datenFilm.arr[2].equals("")) {
                    datenFilm.arr[2] = datenFilmAlt.arr[2];
                }
                if (++count > 250) {
                    count = 0;
                    this.notifyProgress(text);
                }
                listeFilme.addWithNr(datenFilm);
                datenFilmAlt = datenFilm;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(698510057, 0, "IoXml.datenLesenFilme", ex);
            ret = false;
        }
        return ret;
    }

    private boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean ret = true;
        int maxElem = strRet.length;
        try {
            int event;
            block2: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            Log.fehlerMeldung(702069349, 0, "IoXmlLesen.get", ex);
        }
        return ret;
    }

    private void notifyStart(int mmax) {
        this.max = mmax;
        this.progress = 0;
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.start(new ListenerFilmeLadenEvent("", "", this.max, 0));
        }
    }

    private void notifyProgress(String text) {
        if (this.progress < this.max) {
            ++this.progress;
        }
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.progress(new ListenerFilmeLadenEvent("", text, this.max, this.progress));
        }
    }

    private void notifyFertig(ListeFilme liste) {
        Log.systemMeldung("Liste Filme gelesen: " + DatumZeit.getHeute_dd_MM_yyyy() + " " + DatumZeit.getJetzt_HH_MM_SS());
        Log.systemMeldung("Anzahl Filme: " + liste.size());
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.fertig(new ListenerFilmeLadenEvent("", "", this.max, this.progress));
        }
    }
}

