/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.suchen.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.controller.filmeLaden.suchen.FilmeSuchenSender;
import mediathek.controller.filmeLaden.suchen.sender.MediathekReader;
import mediathek.controller.io.GetUrl;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.tool.Log;

public class MediathekMdr
extends MediathekReader
implements Runnable {
    public static final String SENDER = "MDR";
    private LinkedList<String> listeTage = new LinkedList();
    private LinkedList<String[]> listeGesucht = new LinkedList();

    public MediathekMdr(FilmeSuchenSender ssearch, int startPrio) {
        super(ssearch, SENDER, 3, 500, startPrio);
    }

    @Override
    public void addToList() {
        int pos2;
        int pos1;
        String URL_SENDUNGEN = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100.html";
        String URL_TAGE = "http://www.mdr.de/mediathek/fernsehen/index.html";
        String MUSTER = "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_letter-";
        String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_letter-";
        String MUSTER_TAGE = "<a href=\"/mediathek/fernsehen/sendungverpasst100-multiGroupClosed_boxIndex-";
        String MUSTER_ADD_TAGE = "http://www.mdr.de/mediathek/fernsehen/sendungverpasst100-multiGroupClosed_boxIndex-";
        StringBuffer seite = new StringBuffer(81920);
        this.listeThemen.clear();
        this.listeTage.clear();
        this.listeGesucht.clear();
        this.meldungStart();
        seite = this.getUrlIo.getUri_Utf(this.nameSenderMReader, "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100.html", seite, "");
        int pos = 0;
        String url = "";
        while ((pos = seite.indexOf("<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_letter-", pos)) != -1) {
            pos1 = pos += "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_letter-".length();
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.equals("")) {
                Log.fehlerMeldung(-889216307, 2, "MediathekMdr.addToList", "keine URL");
                continue;
            }
            url = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_letter-" + url;
            this.listeThemen.addUrl(new String[]{url});
        }
        seite = this.getUrlIo.getUri_Utf(this.nameSenderMReader, "http://www.mdr.de/mediathek/fernsehen/index.html", seite, "");
        pos = 0;
        url = "";
        while ((pos = seite.indexOf("<a href=\"/mediathek/fernsehen/sendungverpasst100-multiGroupClosed_boxIndex-", pos)) != -1) {
            pos1 = pos += "<a href=\"/mediathek/fernsehen/sendungverpasst100-multiGroupClosed_boxIndex-".length();
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.equals("")) {
                Log.fehlerMeldung(-461225808, 2, "MediathekMdr.addToList-2", "keine URL");
                continue;
            }
            url = "http://www.mdr.de/mediathek/fernsehen/sendungverpasst100-multiGroupClosed_boxIndex-" + url;
            if (this.istInListe(this.listeTage, url)) continue;
            this.listeTage.add(url);
        }
        if (Daten.filmeLaden.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0 && this.listeTage.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeTage.size());
            MediathekMdr.listeSort(this.listeThemen, 0);
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                new Thread(new MdrThemaLaden()).start();
            }
        }
    }

    private String convertDatumXml(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(-435209987, 2, "MediathekMdr.convertDatum", ex);
        }
        return datum;
    }

    private String convertZeitXml(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(-102658736, 2, "MediathekMdr.convertDatum", ex);
        }
        return datum;
    }

    private synchronized String getListeTage() {
        return this.listeTage.pollFirst();
    }

    private synchronized boolean istInListe(String thema, String titel, String datum, String zeit) {
        for (String[] k : this.listeGesucht) {
            if (!k[0].equalsIgnoreCase(thema) || !k[1].equalsIgnoreCase(titel) || !k[2].equalsIgnoreCase(datum) || !k[3].equalsIgnoreCase(zeit)) continue;
            return true;
        }
        return false;
    }

    private void addInListe(String thema, String titel, String datum, String zeit) {
        this.listeGesucht.add(new String[]{thema, titel, datum, zeit});
    }

    private class MdrThemaLaden
    implements Runnable {
        GetUrl getUrl;
        private StringBuffer seite1;
        private StringBuffer seite2;
        private StringBuffer seite3;
        private StringBuffer seite4;

        private MdrThemaLaden() {
            this.getUrl = new GetUrl(MediathekMdr.this.wartenSeiteLaden);
            this.seite1 = new StringBuffer(81920);
            this.seite2 = new StringBuffer(81920);
            this.seite3 = new StringBuffer(81920);
            this.seite4 = new StringBuffer(81920);
        }

        @Override
        public void run() {
            try {
                String url;
                String[] link;
                MediathekMdr.this.meldungAddThread();
                while (!Daten.filmeLaden.getStop() && (link = MediathekMdr.this.listeThemen.getListeThemen()) != null) {
                    MediathekMdr.this.meldungProgress(link[0]);
                    this.addThema(link[0]);
                }
                while (!Daten.filmeLaden.getStop() && (url = MediathekMdr.this.getListeTage()) != null) {
                    MediathekMdr.this.meldungProgress(url);
                    this.addTage(url);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-115896304, 2, "MediathekMdr.MdrThemaLaden.run", ex, "");
            }
            MediathekMdr.this.meldungThreadUndFertig();
        }

        void addTage(String urlSeite) {
            String MUSTER_START_1 = "<div class=\"teaserImage\">";
            String MUSTER_START_2 = "<h3>";
            String MUSTER_THEMA = "title=\"Zu den Inhalten der Sendung\">";
            String MUSTER_XML = "{container:'mediathekStage',dataURL:'/mediathek/fernsehen";
            String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/";
            int pos = 0;
            try {
                this.seite1 = this.getUrl.getUri_Utf(MediathekMdr.this.nameSenderMReader, urlSeite, this.seite1, "");
                while (!Daten.filmeLaden.getStop() && (pos = this.seite1.indexOf("<div class=\"teaserImage\">", pos)) != -1) {
                    String url = "";
                    String thema = "";
                    pos += "<div class=\"teaserImage\">".length();
                    if ((pos = this.seite1.indexOf("<h3>", pos)) != -1) {
                        int pos2;
                        int pos1 = this.seite1.indexOf("title=\"Zu den Inhalten der Sendung\">", pos += "<h3>".length());
                        if (pos1 != -1 && (pos2 = this.seite1.indexOf("<", pos1 += "title=\"Zu den Inhalten der Sendung\">".length())) != -1) {
                            thema = this.seite1.substring(pos1, pos2).trim();
                        }
                        if ((pos1 = this.seite1.indexOf("{container:'mediathekStage',dataURL:'/mediathek/fernsehen", pos)) != -1 && (pos2 = this.seite1.indexOf("'", pos1 += "{container:'mediathekStage',dataURL:'/mediathek/fernsehen".length())) != -1) {
                            url = this.seite1.substring(pos1, pos2);
                        }
                        if (url.equals("")) {
                            Log.fehlerMeldung(-392854069, 2, "MediathekMdr.addTage", new String[]{"keine URL: " + urlSeite});
                            continue;
                        }
                        url = "http://www.mdr.de/mediathek/fernsehen/" + url;
                        MediathekMdr.this.meldung(url);
                        this.addXml(urlSeite, thema, url);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-556320478, 2, "MediathekMdr.addThema", ex, "");
            }
        }

        void addThema(String strUrlFeed) {
            String MUSTER_TITEL = "title=\"Alle verf\u00fcgbaren Sendungen anzeigen\">";
            String MUSTER_URL = "<h3><a href=\"/mediathek/fernsehen/a-z/";
            String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/";
            int pos = 0;
            String thema = "";
            try {
                this.seite2 = this.getUrl.getUri_Utf(MediathekMdr.this.nameSenderMReader, strUrlFeed, this.seite2, "");
                while (!Daten.filmeLaden.getStop() && (pos = this.seite2.indexOf("<h3><a href=\"/mediathek/fernsehen/a-z/", pos)) != -1) {
                    int pos2 = this.seite2.indexOf("\"", pos += "<h3><a href=\"/mediathek/fernsehen/a-z/".length());
                    if (pos == -1 || pos2 == -1) continue;
                    String url = this.seite2.substring(pos, pos2);
                    pos = pos2;
                    if ((pos = this.seite2.indexOf("title=\"Alle verf\u00fcgbaren Sendungen anzeigen\">", pos)) == -1) continue;
                    pos2 = this.seite2.indexOf("<", pos += "title=\"Alle verf\u00fcgbaren Sendungen anzeigen\">".length());
                    if (pos != -1 && pos2 != -1) {
                        thema = this.seite2.substring(pos, pos2);
                        pos = pos2;
                    }
                    if (url.equals("")) {
                        Log.fehlerMeldung(-766250249, 2, "MediathekMdr.addThema", "keine URL: " + strUrlFeed);
                        continue;
                    }
                    MediathekMdr.this.meldung(url);
                    this.addSendug(strUrlFeed, thema, "http://www.mdr.de/mediathek/fernsehen/a-z/" + url);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-316874602, 2, "MediathekMdr.addThema", ex);
            }
        }

        private void addSendug(String strUrlFeed, String thema, String urlThema) {
            String MUSTER_START = "<span class=\"ressortHead\">Sendungen von A bis Z</span>";
            String MUSTER_XML = "{container:'mediathekStage',dataURL:'/mediathek/fernsehen/a-z";
            String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/";
            LinkedList<String> tmpListe = new LinkedList<String>();
            this.seite3 = this.getUrl.getUri_Utf(MediathekMdr.this.nameSenderMReader, urlThema, this.seite3, "Thema: " + thema);
            String url = "";
            int pos = this.seite3.indexOf("<span class=\"ressortHead\">Sendungen von A bis Z</span>");
            if (pos != -1) {
                while ((pos = this.seite3.indexOf("{container:'mediathekStage',dataURL:'/mediathek/fernsehen/a-z", pos)) != -1) {
                    int pos1 = pos += "{container:'mediathekStage',dataURL:'/mediathek/fernsehen/a-z".length();
                    int pos2 = this.seite3.indexOf("'", pos);
                    if (pos2 != -1) {
                        url = this.seite3.substring(pos1, pos2);
                    }
                    if (url.equals("")) {
                        Log.fehlerMeldung(-256987304, 2, "MediathekMdr.addSendug", new String[]{"keine URL: " + urlThema, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
                        continue;
                    }
                    url = "http://www.mdr.de/mediathek/fernsehen/a-z/" + url;
                    if (tmpListe.contains(url)) continue;
                    tmpListe.add(url);
                }
            }
            Iterator it = tmpListe.iterator();
            while (!Daten.filmeLaden.getStop() && it.hasNext()) {
                this.addXml(strUrlFeed, thema, (String)it.next());
            }
        }

        void addXml(String strUrlFeed, String thema, String urlFilm) {
            String MUSTER_START = "<avDocument>";
            String MUSTER_ENDE = "</avDocument>";
            String MUSTER_TITEL = "<title>";
            String MUSTER_URL_1 = "<flashMediaServerApplicationURL>";
            String MUSTER_URL_2 = "<flashMediaServerURL>";
            String MUSTER_DATUM = "<broadcastStartDate>";
            String MUSTER_FRABE_WIDTH = "<frameWidth>";
            int pos = 0;
            try {
                this.seite4 = this.getUrl.getUri_Utf(MediathekMdr.this.nameSenderMReader, urlFilm, this.seite4, "Thema: " + thema);
                pos = this.seite4.indexOf("<avDocument>");
                if (pos == -1) {
                    Log.fehlerMeldung(-903656532, 2, "MediathekMdr.addXml", urlFilm);
                    return;
                }
                while ((pos = this.seite4.indexOf("<title>", pos)) != -1) {
                    int posEnde = this.seite4.indexOf("</avDocument>", pos);
                    if (posEnde == -1) {
                        Log.fehlerMeldung(-804142536, 2, "MediathekMdr.addXml", urlFilm);
                        continue;
                    }
                    String url1 = "";
                    String url2 = "";
                    String titel = "";
                    String datum = "";
                    String zeit = "";
                    int pos1 = pos += "<title>".length();
                    int pos2 = this.seite4.indexOf("<", pos);
                    if (pos2 != -1) {
                        titel = this.seite4.substring(pos1, pos2);
                    }
                    if ((pos1 = this.seite4.indexOf("<broadcastStartDate>", pos)) != -1 && (pos2 = this.seite4.indexOf("<", pos1 += "<broadcastStartDate>".length())) != -1) {
                        datum = this.seite4.substring(pos1, pos2);
                        zeit = MediathekMdr.this.convertZeitXml(datum);
                        datum = MediathekMdr.this.convertDatumXml(datum);
                    }
                    pos1 = pos;
                    int widthAlt = 0;
                    while ((pos1 = this.seite4.indexOf("<frameWidth>", pos1)) != -1 && pos1 <= posEnde) {
                        pos2 = this.seite4.indexOf("<", pos1 += "<frameWidth>".length());
                        if (pos2 != -1) {
                            String width = this.seite4.substring(pos1, pos2);
                            try {
                                int tmp = Integer.parseInt(width);
                                if (tmp <= widthAlt) continue;
                                widthAlt = tmp;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if ((pos1 = this.seite4.indexOf("<flashMediaServerApplicationURL>", pos1)) != -1 && (pos2 = this.seite4.indexOf("<", pos1 += "<flashMediaServerApplicationURL>".length())) != -1) {
                            url1 = this.seite4.substring(pos1, pos2);
                        }
                        if ((pos1 = this.seite4.indexOf("<flashMediaServerURL>", pos1)) == -1 || (pos2 = this.seite4.indexOf("<", pos1 += "<flashMediaServerURL>".length())) == -1) continue;
                        url2 = this.seite4.substring(pos1, pos2);
                    }
                    if (url1.equals("") || url2.equals("")) {
                        Log.fehlerMeldung(-326541230, 2, "MediathekMdr.addXml", new String[]{"keine URL: " + urlFilm, "Thema: " + thema, " UrlFeed: " + strUrlFeed});
                        continue;
                    }
                    String url = MediathekMdr.this.addsUrl(url1, url2);
                    String rtmpUrl = "-r " + url1 + " -y " + url2;
                    if (MediathekMdr.this.istInListe(thema, titel, datum, zeit)) continue;
                    MediathekMdr.this.addInListe(thema, titel, datum, zeit);
                    MediathekMdr.this.meldung(url);
                    DatenFilm film = new DatenFilm(MediathekMdr.this.nameSenderMReader, thema, strUrlFeed, titel, url, rtmpUrl, datum, zeit);
                    MediathekMdr.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-446286970, 2, "MediathekMdr.addFilme1", ex);
            }
        }
    }
}

