/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.controller.io.IoXmlFilmlisteSchreiben;
import mediathek.daten.Daten;
import mediathek.daten.ListeFilme;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Log;

public class MediathekNoGui
implements Runnable {
    private String output = "";
    private String importUrl = "";
    private String userAgent = "";
    private boolean allesLaden = false;
    private String pfad = "";
    private Daten daten;
    private boolean serverLaufen = false;
    private File logfile = null;

    public MediathekNoGui(String ppfad, boolean aallesLaden, String ooutput, String iimprtUrl, String uuserAgent, File log, boolean ddebug) {
        this.pfad = ppfad;
        this.allesLaden = aallesLaden;
        this.output = ooutput;
        this.importUrl = iimprtUrl;
        this.userAgent = uuserAgent;
        this.logfile = log;
        this.serverLaufen = true;
        if (ddebug) {
            Daten.debug = ddebug;
        }
    }

    public MediathekNoGui(String[] ar) {
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                this.pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-alles")) {
                    this.allesLaden = true;
                }
                if (ar[i].equalsIgnoreCase("-o") && ar.length > i) {
                    this.output = ar[i + 1];
                }
                if (ar[i].equalsIgnoreCase("-i") && ar.length > i) {
                    this.importUrl = ar[i + 1];
                }
                if (!ar[i].equalsIgnoreCase("-agent") || ar.length <= i) continue;
                this.userAgent = ar[i + 1];
            }
        }
    }

    public synchronized void init(String[] sender) {
        this.daten = new Daten(this.pfad);
        Daten.nogui = true;
        if (Daten.debug) {
            Log.systemMeldung("Debug on");
        }
        if (!this.userAgent.equals("")) {
            Daten.setUserAgentManuel(this.userAgent);
        }
        if (this.allesLaden) {
            Log.systemMeldung("Filme laden: alles laden");
        } else {
            Log.systemMeldung("Filme laden: nur update laden");
        }
        if (this.logfile != null) {
            Log.setLogFile(this.logfile);
        }
        Log.systemMeldung("ImportUrl: " + this.importUrl);
        Log.systemMeldung("Outputfile: " + this.output);
        Log.systemMeldung("");
        Daten.filmeLaden.addAdListener(new ListenerFilmeLaden(){

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                MediathekNoGui.this.serverLaufen = false;
            }
        });
        Daten.ioXmlFilmlisteLesen.filmlisteLesen(Daten.getBasisVerzeichnis() + "filme.xml", false, Daten.listeFilme);
        if (sender == null) {
            Daten.filmeLaden.filmeBeimSenderSuchen(Daten.listeFilme, this.allesLaden);
        } else {
            Daten.filmeLaden.updateSender(sender, Daten.listeFilme);
        }
    }

    @Override
    public synchronized void run() {
        try {
            while (this.serverLaufen) {
                this.wait(5000L);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(965451236, 5, MediathekNoGui.class.getName(), "ServerStarten");
        }
        this.undTschuess(false);
    }

    public void stoppen() {
        Daten.filmeLaden.setStop();
    }

    public void starten() {
        this.daten = new Daten(this.pfad);
        Daten.nogui = true;
        if (!this.userAgent.equals("")) {
            Daten.setUserAgentManuel(this.userAgent);
        }
        Log.startMeldungen(this.getClass().getName());
        if (this.allesLaden) {
            Log.systemMeldung("Programmstart: alles laden");
        } else {
            Log.systemMeldung("Programmstart: nur update laden");
        }
        Log.systemMeldung("ImportUrl: " + this.importUrl);
        Log.systemMeldung("Outputfile: " + this.output);
        Log.systemMeldung("");
        Log.systemMeldung("");
        Daten.filmeLaden.addAdListener(new ListenerFilmeLaden(){

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                MediathekNoGui.this.undTschuess(true);
            }
        });
        Daten.ioXmlFilmlisteLesen.filmlisteLesen(Daten.getBasisVerzeichnis() + "filme.xml", false, Daten.listeFilme);
        Daten.filmeLaden.filmeBeimSenderSuchen(Daten.listeFilme, this.allesLaden);
    }

    private void addImportListe(String url) {
        if (!url.equals("")) {
            Log.systemMeldung("Filmliste importieren von: " + url);
            ListeFilme tmpListe = new ListeFilme();
            Daten.ioXmlFilmlisteLesen.filmlisteLesen(url, GuiFunktionen.istUrl(url), tmpListe);
            Daten.listeFilme.updateListe(tmpListe, false);
            tmpListe.clear();
        }
    }

    private void undTschuess(boolean exit) {
        if (!this.importUrl.equals("")) {
            this.addImportListe(this.importUrl);
        }
        new IoXmlFilmlisteSchreiben().filmeSchreiben(Daten.getBasisVerzeichnis(true) + "filme.xml", Daten.listeFilme);
        if (!this.output.equals("")) {
            LinkedList<String> out = new LinkedList<String>();
            do {
                if (this.output.startsWith(",")) {
                    this.output = this.output.substring(1);
                }
                if (this.output.contains(",")) {
                    String tmp = this.output.substring(0, this.output.indexOf(","));
                    this.output = this.output.substring(this.output.indexOf(","));
                    out.add(tmp);
                    continue;
                }
                out.add(this.output);
            } while (this.output.contains(","));
            Iterator it = out.iterator();
            while (it.hasNext()) {
                new IoXmlFilmlisteSchreiben().filmeSchreiben((String)it.next(), Daten.listeFilme);
            }
        }
        Log.printEndeMeldung();
        if (exit) {
            if (Daten.listeFilme.isEmpty()) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
    }
}

