/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.io.File;
import java.util.ListIterator;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.controller.io.IoXmlLesen;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.tool.Log;

public class MediathekAuto {
    private DDaten ddaten;
    private String pfad = "";

    public MediathekAuto(String[] ar) {
        if (ar != null && ar.length > 0 && !ar[0].startsWith("-")) {
            if (!ar[0].endsWith(File.separator)) {
                ar[0] = ar[0] + File.separator;
            }
            this.pfad = ar[0];
        }
    }

    public void starten() {
        this.ddaten = new DDaten(this.pfad, false);
        Daten.auto = true;
        Log.startMeldungen(this.getClass().getName());
        if (IoXmlLesen.einstellungenExistieren()) {
            this.ddaten.allesLaden();
            DDaten.filmeLaden.addAdListener(new BeobachterLadenFilme());
            if (Daten.listeFilme.filmlisteZuAlt()) {
                Log.systemMeldung("Neue Fillmliste laden");
                DDaten.filmeLaden.importFilmliste("");
            } else {
                Log.systemMeldung("aktuelle Fillmliste verwenden");
                this.filmeLaden();
            }
        } else {
            Log.fehlerMeldung(834986137, 4, "MediathekAuto", "Das Programm muss erst mit der Gui-Version eingerichtet werden!");
            System.exit(0);
        }
    }

    private synchronized void filmeLaden() {
        try {
            Log.playerMeldungenAus = true;
            this.ddaten.listeDownloads.abosLoschenWennNochNichtGestartet();
            this.ddaten.listeDownloads.abosSuchen();
            Log.systemMeldung(this.ddaten.listeDownloads.size() + " Filme zum Laden");
            int i = 0;
            ListIterator it = this.ddaten.listeDownloads.listIterator();
            while (it.hasNext()) {
                DatenDownload d = (DatenDownload)it.next();
                Log.systemMeldung("Film " + i++ + ": ");
                Log.systemMeldung(" Sender: " + d.arr[3]);
                Log.systemMeldung(" Thema: " + d.arr[4]);
                Log.systemMeldung(" Titel: " + d.arr[5]);
            }
            Log.systemMeldung("###########################################################");
            it = this.ddaten.listeDownloads.listIterator(0);
            while (it.hasNext()) {
                Start s = new Start((DatenDownload)it.next());
                this.ddaten.starterClass.addStarts(s);
                this.wait(5000L);
            }
            while (this.ddaten.starterClass.getStartsWaiting() > 0) {
                this.wait(5000L);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(769325469, 4, "MediathekAuto.filmeLaden", ex);
        }
        this.ddaten.listeDownloads.listePutzen();
        this.ddaten.listeDownloads.abosLoschenWennNochNichtGestartet();
        this.ddaten.allesSpeichern();
        Log.printEndeMeldung();
        System.exit(0);
    }

    private class BeobachterLadenFilme
    extends ListenerFilmeLaden {
        private BeobachterLadenFilme() {
        }

        @Override
        public void fertig(ListenerFilmeLadenEvent event) {
            MediathekAuto.this.filmeLaden();
        }
    }
}

