/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mediathek.Daten;
import mediathek.Log;
import mediathek.daten.DDaten;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiKonstanten;

public class GuiFunktionen {
    public static boolean setLook(JFrame frame) {
        int look;
        if (DDaten.system[1].equals("")) {
            DDaten.system[1] = "1";
        }
        if ((look = Integer.parseInt(DDaten.system[1])) != 0) {
            return GuiFunktionen.setLook(frame, look);
        }
        return true;
    }

    public static boolean setLook(JFrame frame, int look) {
        boolean ret = false;
        try {
            switch (look) {
                case 0: 
                case 1: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break;
                }
                default: {
                    UIManager.setLookAndFeel(GuiKonstanten.THEME[look][1]);
                }
            }
            SwingUtilities.updateComponentTreeUI(frame);
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
            ret = true;
        }
        catch (Exception e) {
            Log.fehlerMeldung("GuiFunktionen.setLook", e, "Kann das Look and Feel nicht \u00e4ndern!");
        }
        return ret;
    }

    public static void copyToClipboard(String s) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
    }

    public static void setProxy(DDaten daten) {
        if (Boolean.parseBoolean(DDaten.system[14])) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", DDaten.system[10]);
            System.setProperty("http.proxyPort", DDaten.system[11]);
            System.setProperty("http.proxyUser", DDaten.system[12]);
            System.setProperty("http.proxyPassword", DDaten.system[13]);
        } else {
            System.setProperty("proxySet", "false");
        }
    }

    public static String replaceLeerDateiname(String pfad, boolean pfadtrennerEntfernen) {
        String ret = pfad;
        if (pfadtrennerEntfernen) {
            ret = ret.replace("/", "-");
            ret = ret.replace("\\", "-");
        }
        ret = ret.replace("\n", "_");
        ret = ret.replace("\"", "_");
        ret = ret.replace(",", "_");
        ret = ret.replace(";", "_");
        ret = ret.replace("(", "_");
        ret = ret.replace(")", "_");
        ret = ret.replace(" ", "_");
        ret = ret.replace("*", "_");
        ret = ret.replace("?", "_");
        ret = ret.replace("<", "_");
        ret = ret.replace(">", "_");
        ret = ret.replace(":", "_");
        ret = ret.replace("'", "_");
        ret = ret.replace("|", "_");
        return ret;
    }

    public static String addsPfad(String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null && !pfad1.equals("") && !pfad2.equals("")) {
            ret = pfad1.charAt(pfad1.length() - 1) == File.separatorChar ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
            ret = pfad2.charAt(0) == File.separatorChar ? ret + pfad2 : ret + File.separator + pfad2;
        }
        if (ret.equals("")) {
            Log.fehlerMeldung("GuiFunktionen.addsPfad", pfad1 + " - " + pfad2);
        }
        return ret;
    }

    public static String getDateiName(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.equals("")) {
            ret = pfad.substring(pfad.lastIndexOf("/") + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf("?"));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf("&"));
        }
        if (ret.equals("")) {
            Log.fehlerMeldung("GuiFunktionen.getDateiName", pfad);
        }
        return ret;
    }

    public static void listeSort(LinkedList<String> liste) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        Collections.sort(liste, sorter);
    }

    public static String getHomePath() {
        return System.getProperty("user.home");
    }

    public static String[] addLeerListe(String[] str) {
        int len = str.length + 1;
        String[] liste = new String[len];
        liste[0] = "";
        for (int i = 1; i < len; ++i) {
            liste[i] = str[i - 1];
        }
        return liste;
    }

    public static void spaltenFilmLoeschen(JTable tabelle, boolean ziel, boolean zeit, boolean datei) {
        for (int i = 0; i < tabelle.getColumnCount(); ++i) {
            if (DDaten.debug || (zeit || i != 5) && i != 7 && i != 8 && i != 9 && i != 10) continue;
            tabelle.getColumnModel().getColumn(i).setMinWidth(0);
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(0);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(0);
        }
    }

    public static void spaltenFilmSetzen(JTable tabelle, boolean ziel) {
        for (int i = 0; i < tabelle.getColumnCount(); ++i) {
            tabelle.getColumnModel().getColumn(i).setMinWidth(10);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(200);
            if (i == 0 || i == 4 || i == 5 || i == 1) {
                tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(100);
                continue;
            }
            if (i == 3) {
                tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(300);
                continue;
            }
            if (i != 6) continue;
            tabelle.getColumnModel().getColumn(i).setMinWidth(10);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(500);
        }
        GuiFunktionen.spaltenFilmLoeschen(tabelle, ziel, true, true);
    }

    public static void spaltenAboSetzen(JTable tabelle) {
        for (int i = 0; i < tabelle.getColumnCount(); ++i) {
            tabelle.getColumnModel().getColumn(i).setMinWidth(10);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
            if (i == 0) {
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(50);
                continue;
            }
            if (i == 1 || i == 8 || i == 3) {
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(100);
                continue;
            }
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(200);
        }
    }

    public static void spaltenDownloadSetzen(JTable tabelle) {
        for (int i = 0; i < tabelle.getColumnCount(); ++i) {
            if (i == 8 || i == 9 || i == 17 || i == 18) {
                tabelle.getColumnModel().getColumn(i).setMinWidth(0);
                tabelle.getColumnModel().getColumn(i).setMaxWidth(0);
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(0);
                continue;
            }
            tabelle.getColumnModel().getColumn(i).setMinWidth(10);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
            if (i == 0) {
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(50);
                continue;
            }
            if (i == 5 || i == 2 || i == 3 || i == 6 || i == 13) {
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(100);
                continue;
            }
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(200);
        }
    }

    public static String textLaenge(String text) {
        if (text.length() != 80) {
            return GuiFunktionen.textLaenge(80, text);
        }
        return text;
    }

    public static String textLaenge(int max, String text) {
        int MAX = max;
        if (text.length() > MAX) {
            text = text.substring(0, MAX - 1);
        }
        while (text.length() < MAX) {
            text = text + " ";
        }
        return text;
    }

    public static int getImportArtFilme() {
        int ret;
        try {
            ret = Integer.parseInt(DDaten.system[30]);
        }
        catch (Exception ex) {
            Daten.system[30] = String.valueOf(2);
            ret = 2;
        }
        return ret;
    }

    public static boolean istUrl(String dateiUrl) {
        return dateiUrl.startsWith("http") ? true : dateiUrl.startsWith("www");
    }
}

