/*
 * Decompiled with CFR 0.152.
 */
package mediathek.importOld;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.Log;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListeBlacklist;
import mediathek.importOld.DatenAbo__old;
import mediathek.importOld.DatenPgruppe__old;
import mediathek.importOld.DatenProg__old;
import mediathek.importOld.Konstanten__old;
import mediathek.importOld.ListeAbo__old;
import mediathek.importOld.ListePgruppe__old;
import mediathek.importOld.ListeProg__old;

public class IoXmlLesen__old {
    public ListePgruppe__old listePgruppeButton = new ListePgruppe__old();
    public ListePgruppe__old listePgruppeAbo = new ListePgruppe__old();
    public ListeAbo__old listeAbo = new ListeAbo__old();
    public ListeBlacklist listeBlacklist = new ListeBlacklist();
    public String[] system = new String[33];

    public boolean importOld(DDaten ddaten, String pfad) {
        try {
            DatenProg progNeu;
            int l;
            ListeProg__old listeProg;
            DatenPset gruppeNeu;
            DatenPgruppe__old gruppe;
            int i;
            this.xmlDatenLesen(pfad);
            for (i = 0; i < this.listePgruppeButton.size(); ++i) {
                gruppe = (DatenPgruppe__old)this.listePgruppeButton.get(i);
                gruppeNeu = gruppe.getNewVersion();
                gruppeNeu.arr[8] = Boolean.TRUE.toString();
                gruppeNeu.arr[0] = "Button" + String.valueOf(i) + "-" + gruppeNeu.arr[0];
                listeProg = gruppe.getListeProg();
                for (l = 0; l < listeProg.size(); ++l) {
                    progNeu = ((DatenProg__old)listeProg.get(l)).getNewVersion();
                    gruppeNeu.addProg(progNeu);
                }
                ddaten.listePset.addPset(gruppeNeu);
            }
            ((DatenPset)ddaten.listePset.getListeButton().getFirst()).setAbspielen(ddaten);
            for (i = 0; i < this.listePgruppeAbo.size(); ++i) {
                gruppe = (DatenPgruppe__old)this.listePgruppeAbo.get(i);
                gruppeNeu = gruppe.getNewVersion();
                gruppeNeu.arr[9] = Boolean.TRUE.toString();
                gruppeNeu.arr[0] = "PGruppeAbo" + String.valueOf(i) + "-" + gruppeNeu.arr[0];
                listeProg = gruppe.getListeProg();
                for (l = 0; l < listeProg.size(); ++l) {
                    progNeu = ((DatenProg__old)listeProg.get(l)).getNewVersion();
                    gruppeNeu.addProg(progNeu);
                }
                ddaten.listePset.addPset(gruppeNeu);
            }
            ((DatenPset)ddaten.listePset.getListeAbo().getFirst()).setSpeichern(true);
            for (i = 0; i < this.listeAbo.size(); ++i) {
                DatenAbo__old abo = (DatenAbo__old)this.listeAbo.get(i);
                DatenAbo aboNeu = abo.getNewVersion();
                ddaten.listeAbo.addAbo(aboNeu);
            }
            for (i = 0; i < this.listeBlacklist.size(); ++i) {
                ddaten.listeBlacklist.add((DatenBlacklist)this.listeBlacklist.get(i));
            }
            return true;
        }
        catch (Exception ex) {
            Log.fehlerMeldung("IoXmlLesen__old.import__old", ex);
            return false;
        }
    }

    public static String altExistiert() {
        try {
            String datei = IoXmlLesen__old.getBasisVerzeichnis() + ".mediathek";
            if (new File(datei).exists()) {
                return datei;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private void xmlDatenLesen(String datei) {
        try {
            if (new File(datei).exists()) {
                XMLInputFactory inFactory = XMLInputFactory.newInstance();
                inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                DatenPgruppe__old datenPgruppe = null;
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                XMLStreamReader parser = inFactory.createXMLStreamReader(in);
                while (parser.hasNext()) {
                    int event = parser.next();
                    if (event != 1) continue;
                    if (parser.getLocalName().equals("System")) {
                        this.get(parser, event, "System", Konstanten__old.SYSTEM_COLUMN_NAMES, this.system);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programmgruppe-Abo")) {
                        datenPgruppe = new DatenPgruppe__old();
                        if (!this.get(parser, event, "Programmgruppe-Abo", Konstanten__old.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                        this.listePgruppeAbo.add(datenPgruppe);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programmgruppe-Button")) {
                        datenPgruppe = new DatenPgruppe__old();
                        if (!this.get(parser, event, "Programmgruppe-Button", Konstanten__old.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                        this.listePgruppeButton.add(datenPgruppe);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programm")) {
                        DatenProg__old datenProg = new DatenProg__old();
                        if (!this.get(parser, event, "Programm", Konstanten__old.PROGRAMM_COLUMN_NAMES, datenProg.arr)) continue;
                        datenPgruppe.addProg(datenProg);
                        continue;
                    }
                    if (parser.getLocalName().equals("Abonnement")) {
                        DatenAbo__old datenAbo = new DatenAbo__old();
                        if (!this.get(parser, event, "Abonnement", Konstanten__old.ABO_COLUMN_NAMES, datenAbo.arr) || Boolean.parseBoolean(datenAbo.arr[10])) continue;
                        this.listeAbo.addAbo(datenAbo);
                        continue;
                    }
                    if (!parser.getLocalName().equals("Blacklist")) continue;
                    DatenBlacklist blacklist = new DatenBlacklist();
                    if (!this.get(parser, event, "Blacklist", Konstanten__old.BLACKLIST_COLUMN_NAMES, blacklist.arr)) continue;
                    this.listeBlacklist.add(blacklist);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Die alten Einstellungen konnten nicht alle importiert werden!", "Fehler", 0);
        }
    }

    private boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        int i;
        boolean ret = true;
        int maxElem = strRet.length;
        for (i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private static String getBasisVerzeichnis() {
        return System.getProperty("user.home") + File.separator + ".mediathek" + File.separator;
    }
}

