/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.beobachter;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.Log;
import mediathek.controller.io.History;
import mediathek.controller.io.starter.Starts;
import mediathek.daten.DDaten;
import mediathek.daten.DatenFilm;
import mediathek.tool.GuiKonstanten;

public class CellRendererFilme
extends DefaultTableCellRenderer {
    private DDaten ddaten;
    private History history = null;

    public CellRendererFilme(DDaten d) {
        this.ddaten = d;
        this.history = this.ddaten.history;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.setBackground(null);
            this.setForeground(null);
            this.setFont(null);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int r = table.convertRowIndexToModel(row);
            String url = table.getModel().getValueAt(r, 6).toString();
            boolean live = table.getModel().getValueAt(r, 2).equals("Livestream");
            Starts s = this.ddaten.starterClass.getStart(url);
            if (s != null) {
                if (s.download.getQuelle() == 1) {
                    switch (s.status) {
                        case 1: {
                            if (isSelected) {
                                this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_WAIT_SEL);
                                break;
                            }
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_WAIT);
                            break;
                        }
                        case 2: {
                            if (isSelected) {
                                this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_RUN_SEL);
                                break;
                            }
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_RUN);
                            break;
                        }
                        case 3: {
                            if (isSelected) {
                                this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_FERTIG_SEL);
                                break;
                            }
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_FERTIG);
                            break;
                        }
                        case 4: {
                            if (isSelected) {
                                this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_ERR_SEL);
                                break;
                            }
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_ERR);
                        }
                    }
                }
            } else if (!live) {
                if (this.history.contains(DatenFilm.getUrlOrg(table.getModel().getValueAt(r, 8).toString(), table.getModel().getValueAt(r, 7).toString(), table.getModel().getValueAt(r, 6).toString()))) {
                    if (isSelected) {
                        this.setBackground(GuiKonstanten.FARBE_GRAU_SEL);
                    } else {
                        this.setBackground(GuiKonstanten.FARBE_GRAU);
                    }
                }
            } else if (live) {
                this.setFont(new Font("Dialog", 1, 12));
                this.setForeground(GuiKonstanten.DOWNLOAD_FARBE_LIVE);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(this.getClass().getName(), ex);
        }
        return this;
    }
}

