/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.beobachter;

import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.Log;
import mediathek.controller.io.starter.Starts;
import mediathek.daten.DDaten;
import mediathek.tool.GuiKonstanten;

public class CellRendererDownloads
extends DefaultTableCellRenderer {
    private DDaten ddaten;

    public CellRendererDownloads(DDaten d) {
        this.ddaten = d;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.setBackground(null);
            this.setForeground(null);
            this.setFont(null);
            this.setIcon(null);
            this.setHorizontalAlignment(10);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int r = table.convertRowIndexToModel(row);
            int c = table.convertColumnIndexToModel(column);
            String url = table.getModel().getValueAt(r, 7).toString();
            boolean abo = !table.getModel().getValueAt(r, 1).equals("");
            Starts s = this.ddaten.starterClass.getStart(url);
            if (s != null) {
                switch (s.status) {
                    case 1: {
                        if (isSelected) {
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_WAIT_SEL);
                            break;
                        }
                        this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_WAIT);
                        break;
                    }
                    case 2: {
                        if (isSelected) {
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_RUN_SEL);
                            break;
                        }
                        this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_RUN);
                        break;
                    }
                    case 3: {
                        if (isSelected) {
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_FERTIG_SEL);
                            break;
                        }
                        this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_FERTIG);
                        break;
                    }
                    case 4: {
                        if (isSelected) {
                            this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_ERR_SEL);
                            break;
                        }
                        this.setBackground(GuiKonstanten.DOWNLOAD_FARBE_ERR);
                    }
                }
            }
            if (c == 1) {
                this.setFont(new Font("Dialog", 1, 12));
                if (abo) {
                    this.setForeground(GuiKonstanten.ABO_FOREGROUND);
                } else {
                    this.setForeground(GuiKonstanten.DOWNLOAD_FOREGROUND);
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_12.png")));
                    this.setHorizontalAlignment(0);
                }
            }
            if (c == 13) {
                boolean restart = this.ddaten.listeDownloads.getDownloadByUrl(url).isRestart();
                this.setHorizontalAlignment(0);
                if (restart) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_16.png")));
                } else {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_12.png")));
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(this.getClass().getName(), ex);
        }
        return this;
    }
}

