/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import mediathek.Log;
import mediathek.daten.DDaten;

public class PanelVorlage
extends JPanel {
    public DDaten ddaten;
    public boolean stopBeob = false;
    private int[] breite = null;
    private int[] reihe = null;
    private List<? extends RowSorter.SortKey> listeSort = null;
    private int sel;
    private int rows;

    public PanelVorlage(DDaten d) {
        this.ddaten = d;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                PanelVorlage.this.isShown();
            }
        });
    }

    public void isShown() {
    }

    public void getSpalten(JTable tabelle) {
        try {
            int i;
            this.breite = new int[tabelle.getColumnCount()];
            this.reihe = new int[tabelle.getColumnCount()];
            this.sel = tabelle.getSelectedRow();
            this.rows = tabelle.getRowCount();
            for (i = 0; i < this.reihe.length && i < tabelle.getModel().getColumnCount(); ++i) {
                this.reihe[i] = tabelle.convertColumnIndexToModel(i);
            }
            for (i = 0; i < this.breite.length && i < tabelle.getModel().getColumnCount(); ++i) {
                this.breite[i] = tabelle.getColumnModel().getColumn(tabelle.convertColumnIndexToView(i)).getWidth();
            }
            if (tabelle.getRowSorter() != null) {
                this.listeSort = tabelle.getRowSorter().getSortKeys();
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung("PanelVorlage.getSpalten", ex);
        }
    }

    public void setSpalten(JTable tabelle) {
        try {
            int i;
            for (i = 0; i < this.breite.length && i < tabelle.getColumnCount(); ++i) {
                tabelle.getColumnModel().getColumn(tabelle.convertColumnIndexToView(i)).setPreferredWidth(this.breite[i]);
            }
            for (i = 0; i < this.reihe.length && i < tabelle.getColumnCount(); ++i) {
                tabelle.getColumnModel().moveColumn(tabelle.convertColumnIndexToView(this.reihe[i]), i);
            }
            if (this.listeSort != null && !this.listeSort.isEmpty()) {
                tabelle.getRowSorter().setSortKeys(this.listeSort);
            }
            if (this.rows == tabelle.getRowCount() && this.sel >= 0 && this.sel < tabelle.getRowCount()) {
                tabelle.setRowSelectionInterval(this.sel, this.sel);
                tabelle.scrollRectToVisible(tabelle.getCellRect(this.sel, 0, false));
            }
            tabelle.validate();
        }
        catch (Exception ex) {
            Log.fehlerMeldung("PanelVorlage.setSpalten", ex);
        }
    }
}

