/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import mediathek.Daten;
import mediathek.controller.filme.filmeImportieren.MediathekListener;
import mediathek.controller.io.starter.StartEvent;
import mediathek.controller.io.starter.StartListener;
import mediathek.controller.io.starter.Starts;
import mediathek.daten.DDaten;
import mediathek.daten.DatenDownload;
import mediathek.gui.PanelVorlage;
import mediathek.gui.beobachter.BeobMpanel;
import mediathek.gui.beobachter.CellRendererDownloads;
import mediathek.gui.dialog.DialogEditDownload;
import mediathek.tool.Datum;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.TModelDownload;

public class GuiDownloads
extends PanelVorlage {
    private ButtonGroup buttonGroup1;
    private JCheckBox jCheckBoxFilter;
    private JPanel jPanelFilter;
    private JPanel jPanelFilterInnen;
    private JRadioButton jRadioButtonAbos;
    private JRadioButton jRadioButtonAlles;
    private JRadioButton jRadioButtonDownloads;
    private JScrollPane jScrollPane2;
    private JTable jTable1;

    public GuiDownloads(DDaten d) {
        super(d);
        this.initComponents();
        this.init();
        this.load();
        GuiFunktionen.spaltenDownloadSetzen(this.jTable1);
    }

    @Override
    public void isShown() {
        super.isShown();
        this.ddaten.mediathekGui.setToolbar(2);
        this.ddaten.infoPanel.setIdx(2);
    }

    public void akualisieren() {
        Daten.setGeaendert();
        this.aufraeumen();
        this.ddaten.listeDownloads.abosLoschen();
        this.ddaten.listeDownloads.abosEintragen();
        this.load();
    }

    public void starten() {
        this.downloadAll("");
    }

    public void zurueckstellen() {
        this.downloadLoeschen(false);
    }

    public void loeschen() {
        this.downloadLoeschen(true);
    }

    public void aufraeumen() {
        this.tabelleAufraeumen();
    }

    public void aendern() {
        this.downloadAendern();
    }

    private void init() {
        Daten.addAdListener(new MediathekListener(7, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiDownloads.this.load();
            }
        });
        this.jRadioButtonAbos.setForeground(GuiKonstanten.ABO_FOREGROUND);
        this.jRadioButtonDownloads.setForeground(GuiKonstanten.DOWNLOAD_FOREGROUND);
        this.jTable1.setDefaultRenderer(Object.class, new CellRendererDownloads(this.ddaten));
        this.jTable1.setDefaultRenderer(Datum.class, new CellRendererDownloads(this.ddaten));
        this.jTable1.setModel(new TModelDownload(new Object[0][], DatenDownload.DOWNLOAD_COLUMN_NAMES));
        this.jTable1.addMouseListener(new BeobMausTabelle());
        ActionMap am = this.jTable1.getActionMap();
        am.put("aendern", new BeobAbstractAction());
        InputMap im = this.jTable1.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "aendern");
        this.ddaten.starterClass.addListener(new BeobachterStart());
        this.jRadioButtonAlles.addActionListener(new BeobAnzeige());
        this.jRadioButtonAbos.addActionListener(new BeobAnzeige());
        this.jRadioButtonDownloads.addActionListener(new BeobAnzeige());
        this.jCheckBoxFilter.addActionListener(new BeobMpanel(this.jCheckBoxFilter, this.jPanelFilter, "Filter"));
    }

    private void load() {
        boolean download;
        boolean abo;
        this.getSpalten(this.jTable1);
        TModelDownload tModel = new TModelDownload(new Object[0][], DatenDownload.DOWNLOAD_COLUMN_NAMES);
        if (this.jRadioButtonAlles.isSelected()) {
            abo = true;
            download = true;
        } else if (this.jRadioButtonAbos.isSelected()) {
            abo = true;
            download = false;
        } else {
            abo = false;
            download = true;
        }
        this.ddaten.listeDownloads.getModel(tModel, abo, download);
        this.jTable1.setModel(tModel);
        GuiFunktionen.spaltenDownloadSetzen(this.jTable1);
        this.setSpalten(this.jTable1);
        this.setInfo();
    }

    private void downloadAendern() {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = this.jTable1.convertRowIndexToModel(rows[i]);
                String url = this.jTable1.getModel().getValueAt(delRow, 7).toString();
                DatenDownload download = this.ddaten.listeDownloads.getDownloadByUrl(url);
                DatenDownload d = download.getCopy();
                DialogEditDownload dialog = new DialogEditDownload(null, true, d);
                dialog.setVisible(true);
                if (!dialog.ok) continue;
                download.aufMichKopieren(d);
                DDaten.setGeaendert();
                this.load();
            }
            this.setInfo();
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void downloadLoeschen(boolean dauerhaft) {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = this.jTable1.convertRowIndexToModel(rows[i]);
                String url = this.jTable1.getModel().getValueAt(delRow, 7).toString();
                DatenDownload download = this.ddaten.listeDownloads.getDownloadByUrl(url);
                if (dauerhaft) {
                    if (download.istAbo()) {
                        this.ddaten.erledigteAbos.zeileSchreiben(download.arr[3], download.arr[4], url);
                    }
                    this.ddaten.listeDownloads.delDownloadByUrl(url);
                }
                this.ddaten.starterClass.filmLoeschen(this.jTable1.getModel().getValueAt(delRow, 7).toString());
                ((TModelDownload)this.jTable1.getModel()).removeRow(delRow);
            }
            this.setInfo();
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void filmStartenWiederholenStoppen(boolean starten) {
        int row = this.jTable1.getSelectedRow();
        if (row >= 0) {
            int delRow = this.jTable1.convertRowIndexToModel(row);
            String url = this.jTable1.getModel().getValueAt(delRow, 7).toString();
            Starts s = this.ddaten.starterClass.getStart(url);
            if (s != null && (starten && s.status > 2 || !starten && s.status <= 2)) {
                this.ddaten.starterClass.filmLoeschen(url);
                if (s.download.istAbo()) {
                    this.ddaten.erledigteAbos.urlAusLogfileLoeschen(url);
                }
            }
            if (starten) {
                this.downloadAll(url);
            }
            this.setInfo();
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void stopAll() {
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            int delRow = this.jTable1.convertRowIndexToModel(i);
            String url = this.jTable1.getModel().getValueAt(delRow, 7).toString();
            Starts s = this.ddaten.starterClass.getStart(url);
            if (s != null && s.status <= 2) {
                this.ddaten.starterClass.filmLoeschen(url);
            }
            this.setInfo();
        }
    }

    private void stopWartende() {
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            int delRow = this.jTable1.convertRowIndexToModel(i);
            String url = this.jTable1.getModel().getValueAt(delRow, 7).toString();
            Starts s = this.ddaten.starterClass.getStart(url);
            if (s != null && s.status < 2) {
                this.ddaten.starterClass.filmLoeschen(url);
            }
            this.setInfo();
        }
    }

    private void tabelleAufraeumen() {
        for (int i = 0; i < this.jTable1.getModel().getRowCount(); ++i) {
            int delRow = this.jTable1.convertRowIndexToModel(i);
            String url = this.jTable1.getModel().getValueAt(delRow, 7).toString();
            Starts s = this.ddaten.starterClass.getStart(url);
            if (s == null || s.status < 3) continue;
            this.ddaten.listeDownloads.delDownloadByUrl(url);
            ((TModelDownload)this.jTable1.getModel()).removeRow(i);
            --i;
        }
        this.setInfo();
        this.ddaten.starterClass.aufraeumen();
    }

    private boolean downloadAll(String uurl) {
        boolean ret = false;
        if (this.jTable1.getModel() != null) {
            for (int i = 0; i < this.jTable1.getModel().getRowCount(); ++i) {
                String url = this.jTable1.getModel().getValueAt(i, 7).toString();
                if (!uurl.equals("") && !uurl.equals(url)) continue;
                DatenDownload download = this.ddaten.listeDownloads.getDownloadByUrl(url);
                this.ddaten.starterClass.addStarts(new Starts(download));
                ret = true;
            }
        }
        this.setInfo();
        return ret;
    }

    private void panelUpdate() {
        this.setInfo();
        this.jTable1.repaint();
        this.validate();
    }

    private void setInfo() {
        int laufen = this.ddaten.starterClass.getDownloadsLaufen();
        int warten = this.ddaten.starterClass.getDownloadsWarten();
        int gesamt = this.jTable1.getModel().getRowCount();
        String textLinks = gesamt == 1 ? "1 Download," : gesamt + " Downloads,";
        textLinks = textLinks + " (";
        textLinks = laufen == 1 ? textLinks + "1 l\u00e4uft," : textLinks + laufen + " laufen,";
        textLinks = warten == 1 ? textLinks + " 1 wartet" : textLinks + " " + warten + " warten";
        textLinks = textLinks + ")";
        this.ddaten.infoPanel.setTextLinks(2, textLinks);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanelFilter = new JPanel();
        this.jCheckBoxFilter = new JCheckBox();
        this.jPanelFilterInnen = new JPanel();
        this.jRadioButtonAlles = new JRadioButton();
        this.jRadioButtonDownloads = new JRadioButton();
        this.jRadioButtonAbos = new JRadioButton();
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jPanelFilter.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jCheckBoxFilter.setBackground(new Color(217, 217, 217));
        this.jCheckBoxFilter.setFont(new Font("Dialog", 1, 10));
        this.jCheckBoxFilter.setText("Filter");
        this.buttonGroup1.add(this.jRadioButtonAlles);
        this.jRadioButtonAlles.setSelected(true);
        this.jRadioButtonAlles.setText(" alle");
        this.jRadioButtonAlles.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonAlles.setBorderPainted(true);
        this.buttonGroup1.add(this.jRadioButtonDownloads);
        this.jRadioButtonDownloads.setText(" Downloads ");
        this.jRadioButtonDownloads.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonDownloads.setBorderPainted(true);
        this.buttonGroup1.add(this.jRadioButtonAbos);
        this.jRadioButtonAbos.setText(" Abos ");
        this.jRadioButtonAbos.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonAbos.setBorderPainted(true);
        GroupLayout jPanelFilterInnenLayout = new GroupLayout(this.jPanelFilterInnen);
        this.jPanelFilterInnen.setLayout(jPanelFilterInnenLayout);
        jPanelFilterInnenLayout.setHorizontalGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterInnenLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAlles).addGap(18, 18, 18).addComponent(this.jRadioButtonDownloads).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAbos).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelFilterInnenLayout.linkSize(0, this.jRadioButtonAbos, this.jRadioButtonAlles, this.jRadioButtonDownloads);
        jPanelFilterInnenLayout.setVerticalGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterInnenLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jRadioButtonAlles).addComponent(this.jRadioButtonDownloads).addComponent(this.jRadioButtonAbos)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelFilterLayout = new GroupLayout(this.jPanelFilter);
        this.jPanelFilter.setLayout(jPanelFilterLayout);
        jPanelFilterLayout.setHorizontalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelFilterInnen, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxFilter, -1, -1, Short.MAX_VALUE));
        jPanelFilterLayout.setVerticalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterLayout.createSequentialGroup().addComponent(this.jCheckBoxFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFilterInnen, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 670, Short.MAX_VALUE).addComponent(this.jPanelFilter, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 357, Short.MAX_VALUE).addContainerGap()));
    }

    private class BeobAnzeige
    implements ActionListener {
        private BeobAnzeige() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiDownloads.this.load();
        }
    }

    private class BeobAbstractAction
    extends AbstractAction {
        private BeobAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiDownloads.this.downloadAendern();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private Point p;

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() > 1) {
                    GuiDownloads.this.downloadAendern();
                }
            } else if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiDownloads.this.jTable1.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiDownloads.this.jTable1.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            int row = GuiDownloads.this.jTable1.getSelectedRow();
            boolean wartenOderLaufen = false;
            if (row >= 0) {
                int delRow = GuiDownloads.this.jTable1.convertRowIndexToModel(row);
                Starts s = GuiDownloads.this.ddaten.starterClass.getStart(GuiDownloads.this.jTable1.getModel().getValueAt(delRow, 7).toString());
                if (s != null && s.status <= 2) {
                    wartenOderLaufen = true;
                }
            }
            JMenuItem itemStarten = new JMenuItem("Download starten");
            itemStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_play_16.png")));
            itemStarten.setEnabled(!wartenOderLaufen);
            menu.add(itemStarten);
            itemStarten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(true);
                }
            });
            JMenuItem itemStoppen = new JMenuItem("Download stoppen");
            itemStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_stop_16.png")));
            itemStoppen.setEnabled(wartenOderLaufen);
            menu.add(itemStoppen);
            itemStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(false);
                }
            });
            menu.addSeparator();
            JMenuItem itemLoeschen = new JMenuItem("Download zur\u00fcckstellen");
            itemLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/undo_16.png")));
            menu.add(itemLoeschen);
            itemLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadLoeschen(false);
                }
            });
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download dauerhaft l\u00f6schen");
            itemDauerhaftLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
            menu.add(itemDauerhaftLoeschen);
            itemDauerhaftLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadLoeschen(true);
                }
            });
            JMenuItem itemAendern = new JMenuItem("Download \u00c4ndern");
            itemAendern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/configure_16.png")));
            menu.add(itemAendern);
            itemAendern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadAendern();
                }
            });
            menu.addSeparator();
            JMenuItem itemAlleStarten = new JMenuItem("alle Downloads starten");
            itemAlleStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/next_16.png")));
            menu.add(itemAlleStarten);
            itemAlleStarten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadAll("");
                }
            });
            JMenuItem itemAlleStoppen = new JMenuItem("alle Downloads stoppen");
            itemAlleStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_stop_16.png")));
            menu.add(itemAlleStoppen);
            itemAlleStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.stopAll();
                }
            });
            JMenuItem itemWartendeStoppen = new JMenuItem("wartende Downloads stoppen");
            itemWartendeStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_stop_16.png")));
            menu.add(itemWartendeStoppen);
            itemWartendeStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.stopWartende();
                }
            });
            JMenuItem itemAktualisieren = new JMenuItem("Liste der Downloads aktualisieren");
            itemAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh_16.png")));
            menu.add(itemAktualisieren);
            itemAktualisieren.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.akualisieren();
                }
            });
            JMenuItem itemAufraeumen = new JMenuItem("Liste Aufr\u00e4umen");
            itemAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear_16.png")));
            menu.add(itemAufraeumen);
            itemAufraeumen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.aufraeumen();
                }
            });
            menu.addSeparator();
            JMenuItem itemVor = new JMenuItem("URL kopieren");
            itemVor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nr = GuiDownloads.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFunktionen.copyToClipboard(GuiDownloads.this.jTable1.getModel().getValueAt(GuiDownloads.this.jTable1.convertRowIndexToModel(nr), 7).toString());
                    }
                }
            });
            menu.add(itemVor);
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobachterStart
    implements StartListener {
        private BeobachterStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            GuiDownloads.this.panelUpdate();
        }
    }
}

