/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeAbo;
import mediathek.tool.DatumZeit;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.TModelFilm;
import org.apache.commons.lang3.StringEscapeUtils;

public class ListeFilme
extends LinkedList<DatenFilm> {
    public static final String THEMA_LIVE = "Livestream";
    public static final String FILMLISTE = "Filmliste";
    public static final int FILMLISTE_MAX_ELEM = 6;
    public static final String FILMLISTE_DATUM = "Filmliste-Datum";
    public static final int FILMLISTE_DATUM_NR = 0;
    public static final String FILMLISTE_ZEIT = "Filmliste-Nur-Zeit";
    public static final int FILMLISTE_NUR_ZEIT_NR = 1;
    public static final String FILMLISTE_DATUM_ZEIT = "Filmliste-Nur-Datum";
    public static final int FILMLISTE_NUR_DATUM_NR = 2;
    public static final String FILMLISTE_ANZAHL = "Filmliste-Anzahl";
    public static final int FILMLISTE_ANZAHL_NR = 3;
    public static final String FILMLISTE_VERSION = "Filmliste-Version";
    public static final int FILMLISTE_VERSION_NR = 4;
    public static final String FILMLISTE_PROGRAMM = "Filmliste-Programm";
    public static final int FILMLISTE_PRGRAMM_NR = 5;
    public static final String[] FILMLISTE_COLUMN_NAMES = new String[]{"Filmliste-Datum", "Filmliste-Nur-Zeit", "Filmliste-Nur-Datum", "Filmliste-Anzahl", "Filmliste-Version", "Filmliste-Programm"};
    public static final String FILMLISTE_INFOS = "Filmliste-Infos";
    public static final int FILMLISTE_INFOS_MAX_ELEM = 2;
    public static final String FILMLISTE_INFOS_SWR_NR_THEMA = "Filmliste-Infos-Swr-NrThema";
    public static final int FILMLISTE_INFOS_SWR_NR_THEMA_NR = 0;
    public static final String FILMLISTE_INFOS_test = "Filmliste-Infos-Test";
    public static final int FILMLISTE_INFOS_test_NR = 1;
    public static final String[] FILMLISTE_INFOS_COLUMN_NAMES = new String[]{"Filmliste-Infos-Swr-NrThema", "Filmliste-Infos-Test"};
    private int nr = 0;
    public String[] infos = ListeFilme.newInfo();
    public String[] metaDaten = ListeFilme.newMetaDaten();

    public static String[] newMetaDaten() {
        String[] ret = new String[6];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = "";
        }
        return ret;
    }

    public static String[] newInfo() {
        String[] ret = new String[2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = "";
        }
        return ret;
    }

    @Override
    public synchronized void clear() {
        this.nr = 0;
        super.clear();
    }

    public void sort() {
        Collections.sort(this);
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            ((DatenFilm)it.next()).arr[0] = this.getNr(i++);
        }
    }

    public synchronized void setInfo(int feld, String wert) {
        this.infos[feld] = wert;
    }

    public synchronized void setInfo(String[] iinfo) {
        for (int i = 0; i < 2; ++i) {
            this.infos[i] = iinfo[i].toString();
        }
    }

    public synchronized void setMeta(String[] mmeta) {
        for (int i = 0; i < 6; ++i) {
            this.metaDaten[i] = mmeta[i].toString();
        }
    }

    public synchronized boolean addFilmVomSender(DatenFilm film) {
        DatenFilm f2 = null;
        film.arr[2] = StringEscapeUtils.unescapeHtml4(film.arr[2].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml4(film.arr[3].trim());
        for (DatenFilm f2 : this) {
            if (!f2.getIndex().equals(film.getIndex())) continue;
            return false;
        }
        return this.add(film);
    }

    public synchronized void updateListe(ListeFilme liste, boolean index) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (index) {
                hashSet.add(((DatenFilm)it.next()).getIndex());
                continue;
            }
            hashSet.add(((DatenFilm)it.next()).arr[6]);
        }
        for (DatenFilm f : liste) {
            if (index) {
                if (hashSet.contains(f.getIndex())) continue;
                this.add(f);
                continue;
            }
            if (hashSet.contains(f.arr[6])) continue;
            this.add(f);
        }
    }

    public synchronized void alteThemenL\u00f6schen(String sender, LinkedList<String[]> liste) {
        Iterator itIch = this.iterator();
        while (itIch.hasNext()) {
            DatenFilm film = (DatenFilm)itIch.next();
            if (!film.arr[1].equalsIgnoreCase(sender)) continue;
            boolean found = false;
            Iterator itListe = liste.iterator();
            while (itListe.hasNext()) {
                if (!film.arr[2].equals(((String[])itListe.next())[1])) continue;
                found = true;
                break;
            }
            if (found) continue;
            itIch.remove();
        }
    }

    public synchronized boolean addWithNr(DatenFilm film) {
        film.arr[2] = StringEscapeUtils.unescapeHtml4(film.arr[2].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml4(film.arr[3].trim());
        film.arr[0] = this.getNr(this.nr++);
        film.arr[6] = film.getUrlOrg();
        return this.add(film);
    }

    private String getNr(int nr) {
        int MAX_STELLEN = 5;
        String FUELL_ZEICHEN = "0";
        String str = String.valueOf(nr++);
        while (str.length() < 5) {
            str = "0" + str;
        }
        return str;
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenFilm)it.next()).arr[1].equalsIgnoreCase(sender)) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized void delOhneSender(String sender) {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public void liveStreamEintragen() {
        this.addFilmVomSender(new DatenFilm("ZDF", THEMA_LIVE, "", "ZDF Livestream", "http://wstreaming.zdf.de/encoder/livestream2_vh.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("3Sat", THEMA_LIVE, "", "3Sat Livestream", "http://wstreaming.zdf.de/encoder/3sat_vh.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("ARD", THEMA_LIVE, "", "ARD Tagesschau Livestream", "mmsh://tagesschau-live1-webm-wmv.wm.llnwd.net/tagesschau_live1_webm_wmv?MSWMExt=.asf", "", ""));
        this.addFilmVomSender(new DatenFilm("NDR", THEMA_LIVE, "", "NDR Livestream", "http://www.ndr.de/resources/metadaten/ndr_fs_nds_hi_wmv.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("WDR", THEMA_LIVE, "", "WDR Livestream", "http://www.wdr.de/wdrlive/media/wdr-fernsehen_web-l.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("MDR", THEMA_LIVE, "", "MDR SACHSEN Livestream", "http://avw.mdr.de/livestreams/mdr_tv_sachsen.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("MDR", THEMA_LIVE, "", "MDR SACHSEN-ANHALT Livestream", "http://avw.mdr.de/livestreams/mdr_tv_sachsen-anhalt.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("MDR", THEMA_LIVE, "", "MDR TH\u00dcRINGEN Livestream", "http://avw.mdr.de/livestreams/mdr_tv_thueringen.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("ARD", THEMA_LIVE, "", "ARD Phoenix Livestream", "http://hstreaming.zdf.de/encoder/phoenix_vh.mov", "", ""));
    }

    public synchronized void getModelTabFilme(DDaten ddaten, TModelFilm modelFilm, String filterSender, String filterThema, String filterTitel, String filterThemaTitel) {
        modelFilm.setRowCount(0);
        if (this.size() != 0) {
            ListeFilme liste = new ListeFilme();
            Iterator it = this.iterator();
            if (filterSender.equals("") && filterThema.equals("") && filterTitel.equals("") && filterThemaTitel.equals("")) {
                this.addObjectDataTabFilme(ddaten, modelFilm);
            } else {
                while (it.hasNext()) {
                    DatenFilm film = (DatenFilm)it.next();
                    if (!ListeAbo.filterAufAboPruefen(filterSender, filterThema, filterTitel, filterThemaTitel, film.arr[1], film.arr[2], film.arr[3])) continue;
                    liste.add(film);
                }
                liste.addObjectDataTabFilme(ddaten, modelFilm);
            }
        }
    }

    public synchronized String[] getModelOfField(int feld, String filterString, int filterFeld) {
        String str;
        HashSet<String> tree = new HashSet<String>();
        tree.add("");
        Iterator it = this.iterator();
        if (filterString.equals("")) {
            while (it.hasNext()) {
                str = ((DatenFilm)it.next()).arr[feld];
                if (tree.contains(str)) continue;
                tree.add(str);
            }
        } else {
            while (it.hasNext()) {
                DatenFilm film = (DatenFilm)it.next();
                str = film.arr[feld];
                if (!film.arr[filterFeld].equalsIgnoreCase(filterString) || tree.contains(str)) continue;
                tree.add(str);
            }
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String h : tree) {
            list.add(h);
        }
        GuiFunktionen.listeSort(list);
        String[] ret = new String[]{};
        ret = list.toArray(ret);
        return ret;
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        DatenFilm ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm f = (DatenFilm)it.next();
            if (!f.arr[6].equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    private void addObjectDataTabFilme(DDaten ddaten, TModelFilm model) {
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            while (iterator.hasNext()) {
                DatenFilm film = (DatenFilm)iterator.next();
                DatenAbo datenAbo = ddaten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3]);
                film.arr[11] = datenAbo != null ? datenAbo.arr[2] : "";
                Object[] object = new Object[12];
                for (int m = 0; m < 12; ++m) {
                    object[m] = m == 4 ? DatumZeit.getDatumForObject(film) : film.arr[m];
                }
                model.addRow(object);
            }
        }
    }

    public int alterFilmlisteSek() {
        int ret = 0;
        Date jetzt = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        String date = this.metaDaten[0];
        Date filmDate = null;
        try {
            filmDate = sdf.parse(date);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (jetzt != null && filmDate != null) {
            ret = Math.round((jetzt.getTime() - filmDate.getTime()) / 1000L);
            ret = Math.abs(ret);
        }
        return ret;
    }

    public boolean filmlisteIstAelter() {
        int ret = -1;
        Date jetzt = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        String date = this.metaDaten[0];
        Date filmDate = null;
        try {
            filmDate = sdf.parse(date);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (jetzt != null && filmDate != null) {
            ret = Math.round((jetzt.getTime() - filmDate.getTime()) / 1000L);
            ret = Math.abs(ret);
        }
        if (ret > 10800) {
            return true;
        }
        return ret == -1;
    }
}

