/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import mediathek.tool.DatumZeit;
import mediathek.tool.GermanStringSorter;

public class DatenFilm
implements Comparable<DatenFilm> {
    public static final String FELD_INFO = "Feldinfo";
    public static final String FILME = "Filme";
    public static final String FILME_ = "X";
    public static final int FILME_MAX_ELEM = 12;
    public static final String FILM_NR = "Nr";
    public static final int FILM_NR_NR = 0;
    public static final String FILM_SENDER = "Sender";
    public static final int FILM_SENDER_NR = 1;
    public static final String FILM_THEMA = "Thema";
    public static final int FILM_THEMA_NR = 2;
    public static final String FILM_TITEL = "Titel";
    public static final int FILM_TITEL_NR = 3;
    public static final String FILM_DATUM = "Datum";
    public static final int FILM_DATUM_NR = 4;
    public static final String FILM_ZEIT = "Zeit";
    public static final int FILM_ZEIT_NR = 5;
    public static final String FILM_URL = "Url";
    public static final int FILM_URL_NR = 6;
    public static final String FILM_URL_ORG = "UrlOrg";
    public static final int FILM_URL_ORG_NR = 7;
    public static final String FILM_URL_RTMP = "UrlRTMP";
    public static final int FILM_URL_RTMP_NR = 8;
    public static final String FILM_URL_AUTH = "UrlAuth";
    public static final int FILM_URL_AUTH_NR = 9;
    public static final String FILM_URL_THEMA = "UrlThema";
    public static final int FILM_URL_THEMA_NR = 10;
    public static final String FILM_ABO_NAME = "Abo-Name";
    public static final int FILM_ABO_NAME_NR = 11;
    public static final String[] FILME_COLUMN_NAMES = new String[]{"Nr", "Sender", "Thema", "Titel", "Datum", "Zeit", "Url", "UrlOrg", "UrlRTMP", "UrlAuth", "UrlThema", "Abo-Name"};
    public static final String[] FILME_COLUMN_NAMES_ = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"};
    public String[] arr;

    public DatenFilm() {
        this.makeArr();
    }

    public DatenFilm(String ssender, String tthema, String urlThema, String ttitel, String uurl, String datum, String zeit) {
        this.makeArr();
        this.arr[1] = ssender;
        this.arr[2] = tthema;
        this.arr[3] = ttitel;
        this.arr[6] = uurl;
        this.arr[4] = DatumZeit.checkDatum(datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[5] = DatumZeit.checkZeit(this.arr[4], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[10] = urlThema;
    }

    public DatenFilm(String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String uurlRtmp, String datum, String zeit) {
        this.makeArr();
        this.arr[1] = ssender;
        this.arr[2] = tthema;
        this.arr[3] = ttitel;
        this.arr[6] = uurl;
        this.arr[7] = uurlorg;
        this.arr[8] = uurlRtmp;
        this.arr[10] = urlThema;
        this.arr[4] = DatumZeit.checkDatum(datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[5] = DatumZeit.checkZeit(this.arr[4], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
    }

    public String getIndex() {
        return this.arr[1] + this.arr[2] + this.arr[6];
    }

    public DatenFilm getClean() {
        DatenFilm ret = new DatenFilm();
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        ret.arr[0] = "";
        ret.arr[11] = "";
        return ret;
    }

    public DatenFilm getCopy() {
        DatenFilm ret = new DatenFilm();
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        return ret;
    }

    @Override
    public int compareTo(DatenFilm arg0) {
        int ret = 0;
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        ret = sorter.compare(this.arr[1], arg0.arr[1]);
        if (ret == 0) {
            ret = sorter.compare(this.arr[2], arg0.arr[2]);
        }
        return ret;
    }

    public String getUrlOrg() {
        return DatenFilm.getUrlOrg(this.arr[8], this.arr[7], this.arr[6]);
    }

    public static String getUrlOrg(String url_rtmp, String url_org, String url) {
        String ret = !url_org.equals("") ? url_org : (url.startsWith("-r ") ? url.substring("-r ".length()) : url);
        return ret;
    }

    private void makeArr() {
        this.arr = new String[12];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
    }
}

