/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.File;
import javax.swing.JOptionPane;
import mediathek.Log;
import mediathek.controller.io.AsxLesen;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogZielDatei;
import mediathek.tool.DatumZeit;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiFunktionen;

public class DatenDownload
implements Comparable<DatenDownload> {
    public static final String DOWNLOAD = "Downlad";
    public static final int DOWNLOAD_MAX_ELEM = 19;
    public static final String DOWNLOAD_NR = "Nr";
    public static final int DOWNLOAD_NR_NR = 0;
    public static final String DOWNLOAD_ABO = "Abo";
    public static final int DOWNLOAD_ABO_NR = 1;
    public static final String DOWNLOAD_SENDER = "Sender";
    public static final int DOWNLOAD_SENDER_NR = 2;
    public static final String DOWNLOAD_THEMA = "Thema";
    public static final int DOWNLOAD_THEMA_NR = 3;
    public static final String DOWNLOAD_TITEL = "Titel";
    public static final int DOWNLOAD_TITEL_NR = 4;
    public static final String DOWNLOAD_DATUM = "Datum";
    public static final int DOWNLOAD_DATUM_NR = 5;
    public static final String DOWNLOAD_ZEIT = "Zeit";
    public static final int DOWNLOAD_ZEIT_NR = 6;
    public static final String DOWNLOAD_URL = "URL";
    public static final int DOWNLOAD_URL_NR = 7;
    public static final String DOWNLOAD_URL_AUTH = "URL-Auth";
    public static final int DOWNLOAD_URL_AUTH_NR = 8;
    public static final String DOWNLOAD_URL_RTMP = "URL-rtmp";
    public static final int DOWNLOAD_URL_RTMP_NR = 9;
    public static final String DOWNLOAD_PROGRAMMSET = "Programmset";
    public static final int DOWNLOAD_PROGRAMMSET_NR = 10;
    public static final String DOWNLOAD_PROGRAMM = "Programm";
    public static final int DOWNLOAD_PROGRAMM_NR = 11;
    public static final String DOWNLOAD_PROGRAMM_AUFRUF = "Programmaufruf";
    public static final int DOWNLOAD_PROGRAMM_AUFRUF_NR = 12;
    public static final String DOWNLOAD_PROGRAMM_RESTART = "Restart";
    public static final int DOWNLOAD_PROGRAMM_RESTART_NR = 13;
    public static final String DOWNLOAD_ZIEL_DATEINAME = "Dateiname";
    public static final int DOWNLOAD_ZIEL_DATEINAME_NR = 14;
    public static final String DOWNLOAD_ZIEL_PFAD = "Pfad";
    public static final int DOWNLOAD_ZIEL_PFAD_NR = 15;
    public static final String DOWNLOAD_ZIEL_PFAD_DATEINAME = "Pfad-Dateiname";
    public static final int DOWNLOAD_ZIEL_PFAD_DATEINAME_NR = 16;
    public static final String DOWNLOAD_ART = "Art";
    public static final int DOWNLOAD_ART_NR = 17;
    public static final String DOWNLOAD_QUELLE = "Quelle";
    public static final int DOWNLOAD_QUELLE_NR = 18;
    public static final String[] DOWNLOAD_COLUMN_NAMES = new String[]{"Nr", "Abo", "Sender", "Thema", "Titel", "Datum", "Zeit", "URL", "URL-Auth", "URL-rtmp", "Programmset", "Programm", "Programmaufruf", "Restart", "Dateiname", "Pfad", "Pfad-Dateiname", "Art", "Quelle"};
    public String[] arr;

    public DatenDownload() {
        this.makeArr();
    }

    public DatenDownload(DatenFilm film, int quelle) {
        this.makeArr();
        this.arr[0] = film.arr[0];
        this.arr[2] = film.arr[1];
        this.arr[3] = film.arr[2];
        this.arr[4] = film.arr[3];
        this.arr[7] = film.arr[6];
        this.arr[8] = film.arr[9];
        this.arr[5] = film.arr[4];
        this.arr[6] = film.arr[5];
        this.arr[9] = film.arr[8];
        this.arr[18] = String.valueOf(quelle);
    }

    public DatenDownload getCopy() {
        DatenDownload ret = new DatenDownload();
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        return ret;
    }

    public void aufMichKopieren(DatenDownload datenDownload) {
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = new String(datenDownload.arr[i]);
        }
    }

    public boolean istAbo() {
        return !this.arr[1].equals("");
    }

    public int getArt() {
        try {
            return Integer.parseInt(this.arr[17]);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(this.getClass().getName(), ex);
            return 2;
        }
    }

    public int getQuelle() {
        try {
            return Integer.parseInt(this.arr[18]);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(this.getClass().getName(), ex);
            return 1;
        }
    }

    public boolean isRestart() {
        if (this.arr[13].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[13]);
    }

    public void aufrufBauen(DatenPset gruppe, DatenAbo abo) {
        try {
            DatenProg programm = gruppe.getProgUrl(this.arr[7]);
            String zielDateiname = gruppe.getZielDateiname(this.arr[7]);
            String zielPfad = gruppe.getZielPfad();
            if (abo != null) {
                zielPfad = GuiFunktionen.addsPfad(zielPfad, abo.arr[7]);
                this.arr[1] = abo.arr[2];
            }
            this.arr[10] = gruppe.arr[0];
            int art = gruppe.checkDownloadDirekt(this.arr[7]);
            this.arr[17] = String.valueOf(art);
            this.arr[11] = art == 1 ? "direkter Download" : programm.arr[0];
            this.arr[13] = String.valueOf(programm.isRestart());
            this.arr[14] = zielDateiname;
            this.arr[15] = zielPfad;
            this.dateinamePfadBauen(gruppe);
            this.programmaufrufBauen(programm);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(this.getClass().getName(), ex);
        }
    }

    private void dateinamePfadBauen(DatenPset gruppe) {
        String name = this.arr[14];
        String pfad = this.arr[15];
        if (pfad.equals("")) {
            pfad = GuiFunktionen.getHomePath();
        }
        if (name.equals("")) {
            name = DatumZeit.getHeute_yyyyMMdd() + "_" + this.arr[3] + "-" + this.arr[4] + ".mp4";
        } else {
            name = name.replace("%D", this.arr[5].equals("") ? DatumZeit.getHeute_yyyyMMdd() : this.datumDatumZeitReinigen(this.datumDrehen(this.arr[5])));
            name = name.replace("%d", this.arr[6].equals("") ? DatumZeit.getJetzt_HHMMSS() : this.datumDatumZeitReinigen(this.arr[6]));
            name = name.replace("%t", this.arr[3]);
            name = name.replace("%T", this.arr[4]);
            name = name.replace("%s", this.arr[2]);
            name = name.replace("%H", DatumZeit.getHeute_yyyyMMdd());
            name = name.replace("%h", DatumZeit.getJetzt_HHMMSS());
            name = name.replace("%n", GuiFunktionen.getDateiName(this.arr[7]));
            if ((name = name.replace("%N", GuiFunktionen.getDateiName(this.arr[7]))).length() > 8) {
                String suf1 = name.substring(name.length() - 8, name.length() - 4);
                String suf2 = name.substring(name.length() - 4);
                if (suf1.startsWith(".") && suf2.startsWith(".") && suf1.equalsIgnoreCase(suf2)) {
                    name = name.substring(0, name.length() - 4);
                }
            }
        }
        if (pfad.endsWith(File.separator)) {
            pfad = pfad.substring(0, pfad.length() - 1);
        }
        if (name.contains("%p") || pfad.contains("%p")) {
            name = name.equals("%p") ? DatumZeit.getHeute_yyyyMMdd() + "_" + this.arr[3] + "-" + this.arr[4] + ".mp4" : name.replace("%p", "-_-");
            pfad = pfad.replace("%p", "");
            name = GuiFunktionen.replaceLeerDateiname(name, true);
            DialogZielDatei dialog = new DialogZielDatei(null, true, pfad, name);
            dialog.setVisible(true);
            if (!dialog.ok) {
                name = DatumZeit.getHeute_yyyyMMdd() + "_" + this.arr[3] + "-" + this.arr[4] + ".mp4";
                pfad = GuiFunktionen.getHomePath();
            } else {
                name = dialog.zielDateiname;
                pfad = dialog.zielPfad;
            }
        } else if (name.contains("%n")) {
            name = name.equals("%n") ? DatumZeit.getHeute_yyyyMMdd() + "_" + this.arr[3] + "-" + this.arr[4] + ".mp4" : name.replace("%n", "-_-");
            name = GuiFunktionen.replaceLeerDateiname(name, true);
            if ((name = JOptionPane.showInputDialog("Dateiname eingeben", (Object)name)) == null) {
                name = DatumZeit.getHeute_yyyyMMdd() + "_" + this.arr[3] + "-" + this.arr[4] + ".mp4";
            }
        }
        if (pfad.endsWith(File.separator)) {
            pfad = pfad.substring(0, pfad.length() - 1);
        }
        if (Boolean.parseBoolean(gruppe.arr[10])) {
            int laenge = 25;
            if (!gruppe.arr[11].equals("")) {
                laenge = Integer.parseInt(gruppe.arr[11]);
            }
            if (name.length() > laenge) {
                name = name.substring(0, laenge - 4) + name.substring(name.length() - 4);
            }
        }
        this.arr[14] = GuiFunktionen.replaceLeerDateiname(name, true);
        this.arr[15] = pfad;
        this.arr[16] = GuiFunktionen.addsPfad(pfad, this.arr[14]);
    }

    private void programmaufrufBauen(DatenProg programm) {
        String befehlsString = programm.getProgrammAufruf();
        befehlsString = befehlsString.replace("**", this.arr[16]);
        befehlsString = befehlsString.replace("%f", this.arr[7]);
        befehlsString = befehlsString.replace("%F", this.getUrlFlvstreamer());
        befehlsString = befehlsString.replace("%k", this.getUrlLow());
        befehlsString = befehlsString.replace("%x", AsxLesen.lesen(this.arr[7]));
        if (this.arr[8].equals("")) {
            befehlsString = befehlsString.replace("%a", "");
            befehlsString = befehlsString.replace("%A", "");
        } else {
            befehlsString = befehlsString.replace("%a", this.arr[8]);
            befehlsString = befehlsString.replace("%A", "-W " + this.arr[8]);
        }
        this.arr[12] = this.getArt() == 1 ? "" : befehlsString;
    }

    private String getUrlFlvstreamer() {
        String ret = "";
        ret = !this.arr[9].equals("") ? this.arr[9] : (this.arr[7].startsWith("rtmp") ? "-r " + this.arr[7] : this.arr[7]);
        return ret;
    }

    private String getUrlLow() {
        String ret = "";
        if (this.arr[2].equalsIgnoreCase("3Sat")) {
            ret = this.arr[7].replace("/veryhigh/", "/300/");
        } else if (this.arr[2].equalsIgnoreCase("ZDF")) {
            ret = this.arr[7].replace("/veryhigh/", "/300/");
        } else if (this.arr[2].equalsIgnoreCase("NDR")) {
            ret = this.arr[7].replace(".hq.", ".lo.");
        }
        return ret;
    }

    @Override
    public int compareTo(DatenDownload arg0) {
        int ret = 0;
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        ret = sorter.compare(this.arr[2], arg0.arr[2]);
        if (ret == 0) {
            ret = sorter.compare(this.arr[3], arg0.arr[3]);
        }
        return ret;
    }

    private void makeArr() {
        this.arr = new String[19];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
    }

    private String datumDrehen(String datum) {
        String ret = "";
        if (!datum.equals("")) {
            try {
                if (datum.length() == 10) {
                    String tmp = datum.substring(6);
                    tmp = tmp + "." + datum.substring(3, 5);
                    ret = tmp = tmp + "." + datum.substring(0, 2);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("DatenFilm.datumDrehen", ex, datum);
            }
        }
        return ret;
    }

    private String datumDatumZeitReinigen(String datum) {
        String ret = "";
        ret = datum;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }
}

