/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io.starter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import mediathek.Log;
import mediathek.controller.io.starter.ListeStarts;
import mediathek.controller.io.starter.RuntimeExec;
import mediathek.controller.io.starter.StartEvent;
import mediathek.controller.io.starter.StartListener;
import mediathek.controller.io.starter.Starts;
import mediathek.daten.DDaten;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.tool.TModel;

public class StarterClass {
    private DDaten ddaten;
    private boolean allesStop = false;
    private ListeStarts listeStarts;
    private Starten starten = null;
    private EventListenerList listeners = new EventListenerList();

    public StarterClass(DDaten d) {
        this.ddaten = d;
        this.init();
    }

    private void init() {
        this.listeners = new EventListenerList();
        this.listeStarts = new ListeStarts(this.ddaten);
        this.starten = new Starten();
        Thread startenThread = new Thread(this.starten);
        startenThread.setDaemon(true);
        startenThread.start();
    }

    public synchronized Starts urlStarten(DatenPset gruppe, DatenFilm ersterFilm) {
        Starts s = null;
        String url = ersterFilm.arr[6];
        if (!url.equals("")) {
            DatenDownload download = new DatenDownload(ersterFilm, 1);
            download.aufrufBauen(gruppe, null);
            s = new Starts(download);
            this.starten.startStarten(s);
            this.addStarts(s);
        }
        return s;
    }

    public synchronized LinkedList<Starts> getStarts(int quelle) {
        LinkedList<Starts> ret = new LinkedList<Starts>();
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.download.getQuelle() != quelle && quelle != -1) continue;
            ret.add(s);
        }
        return ret;
    }

    public synchronized int getDownloadsWarten() {
        int ret = 0;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.download.getQuelle() != 3 && s.download.getQuelle() != 2 || s.status != 1) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized int getDownloadsLaufen() {
        int ret = 0;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.download.getQuelle() != 3 && s.download.getQuelle() != 2 || s.status != 2) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized TModel getStarterModell(TModel model) {
        return this.listeStarts.getModel(model);
    }

    public void addListener(StartListener listener) {
        this.listeners.add(StartListener.class, listener);
    }

    public synchronized void addStarts(Starts starts) {
        this.allesStop = false;
        if (starts != null && !this.listeStarts.contain(starts)) {
            this.listeStarts.add(starts);
        }
        this.notifyStartEvent();
    }

    public synchronized int getState(String url) {
        int ret = 0;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (!s.download.arr[7].equals(url)) continue;
            ret = s.status;
            break;
        }
        return ret;
    }

    public synchronized Starts getStart(String url) {
        Starts ret = null;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (!s.download.arr[7].equals(url)) continue;
            ret = s;
            break;
        }
        return ret;
    }

    public synchronized void delStart(String url) {
        this.listeStarts.delStart(url);
    }

    public synchronized void aufraeumen() {
        this.listeStarts.aufraeumen();
        this.notifyStartEvent();
    }

    public synchronized void abbrechen() {
        this.allesStop = true;
        this.listeStarts.delAlle();
        this.notifyStartEvent();
    }

    public synchronized void abbrechenNachFilm() {
        this.listeStarts.delRest();
        this.notifyStartEvent();
    }

    public synchronized void filmLoeschen(String url) {
        this.listeStarts.delStart(url);
        this.notifyStartEvent();
    }

    private void notifyStartEvent() {
        int down = 0;
        int progress = 0;
        int max = this.listeStarts.getmax();
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.status == 2) {
                ++down;
            }
            if (s.status < 3) continue;
            ++progress;
        }
        StartEvent event = new StartEvent(this, down, progress, max, this.allesStop);
        for (StartListener l : (StartListener[])this.listeners.getListeners(StartListener.class)) {
            l.starter(event);
        }
    }

    private Starts getListe() {
        Starts ret = null;
        if (this.allesStop) {
            Iterator<Starts> it = this.listeStarts.getIt();
            while (it.hasNext()) {
                Starts s = it.next();
                if (s.status >= 3) continue;
                it.remove();
            }
        } else if (this.listeStarts.size() >= 0) {
            Starts s;
            if (this.listeStarts.getDown() < Integer.parseInt(DDaten.system[15]) && (s = this.naechsterStart()) != null && s.status == 1) {
                ret = s;
            }
        }
        return ret;
    }

    private void buttonStartsPutzen() {
        boolean habsGetan = false;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.download.getQuelle() != 1 || s.status == 2) continue;
            it.remove();
            habsGetan = true;
        }
        if (habsGetan) {
            this.notifyStartEvent();
        }
    }

    private Starts naechsterStart() {
        Starts s = null;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            s = it.next();
            if (s.status != 1 || this.maxSenderLaufen(s, 1)) continue;
            return s;
        }
        it = this.listeStarts.getIt();
        while (it.hasNext()) {
            s = it.next();
            if (s.status != 1 || this.maxSenderLaufen(s, 2)) continue;
            return s;
        }
        return null;
    }

    private boolean maxSenderLaufen(Starts s, int max) {
        try {
            int counter = 0;
            Starts start = null;
            String host = this.getHost(s);
            Iterator<Starts> it = this.listeStarts.getIt();
            while (it.hasNext()) {
                start = it.next();
                if (start.status != 2 || !this.getHost(start).equalsIgnoreCase(host) || ++counter < max) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHost(Starts s) {
        String host = "";
        try {
            try {
                URL url;
                String tmp;
                String uurl = s.download.arr[7];
                if (uurl.startsWith("rtmpt:")) {
                    uurl = uurl.toLowerCase().replace("rtmpt:", "http:");
                }
                if (uurl.startsWith("rtmp:")) {
                    uurl = uurl.toLowerCase().replace("rtmp:", "http:");
                }
                if (uurl.startsWith("mms:")) {
                    uurl = uurl.toLowerCase().replace("mms:", "http:");
                }
                if ((tmp = (url = new URL(uurl)).getHost()).contains(".")) {
                    host = tmp.substring(tmp.lastIndexOf("."));
                    host = (tmp = tmp.substring(0, tmp.lastIndexOf("."))).contains(".") ? tmp.substring(tmp.lastIndexOf(".") + 1) + host : (tmp.contains("/") ? tmp.substring(tmp.lastIndexOf("/") + 1) + host : "host");
                }
            }
            catch (Exception ex) {
                host = "host";
            }
            finally {
                if (host == null) {
                    host = "host";
                }
                if (host.equals("")) {
                    host = "host";
                }
            }
        }
        catch (Exception ex) {
            host = "exception";
        }
        return host;
    }

    private boolean pruefen(Starts starts) {
        boolean ret = false;
        File file = new File(starts.download.arr[16]);
        if (!file.exists()) {
            Log.fehlerMeldung("StartetClass.pruefen-1", "Download fehlgeschlagen: " + starts.download.arr[16]);
        } else if (file.length() < 2048L) {
            Log.fehlerMeldung("StartetClass.pruefen-2", "Download fehlgeschlagen: " + starts.download.arr[16]);
        } else {
            if (starts.download.istAbo()) {
                this.ddaten.erledigteAbos.zeileSchreiben(starts.download.arr[3], starts.download.arr[4], starts.download.arr[7]);
            }
            ret = true;
        }
        return ret;
    }

    private class StartenDonwnload
    implements Runnable {
        Starts starts;

        public StartenDonwnload(Starts s) {
            this.starts = s;
            this.starts.status = 2;
            StarterClass.this.notifyStartEvent();
        }

        @Override
        public void run() {
            InputStream input = null;
            FileOutputStream destStream = null;
            try {
                int len;
                new File(this.starts.download.arr[15]).mkdirs();
                URL feedUrl = new URL(this.starts.download.arr[7]);
                input = feedUrl.openStream();
                byte[] buffer = new byte[1024];
                destStream = new FileOutputStream(this.starts.download.arr[16]);
                while ((len = input.read(buffer)) != -1) {
                    ((OutputStream)destStream).write(buffer, 0, len);
                    if (!StarterClass.this.allesStop && !this.starts.stoppen) continue;
                }
                input.close();
                ((OutputStream)destStream).close();
            }
            catch (Exception ex) {
                Log.fehlerMeldung("StarterClass.StartenDonwnload-1", ex);
            }
            try {
                if (!StarterClass.this.allesStop && !this.starts.stoppen) {
                    this.starts.status = this.starts.download.getQuelle() == 1 ? 3 : (StarterClass.this.pruefen(this.starts) ? 3 : 4);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("StarterClass.StartenDonwnload-2", ex);
            }
            StarterClass.this.notifyStartEvent();
        }
    }

    private class StartenProgramm
    implements Runnable {
        Starts starts;
        RuntimeExec runtimeExec;

        public StartenProgramm(Starts s) {
            this.starts = s;
            this.starts.status = 2;
            StarterClass.this.notifyStartEvent();
            try {
                new File(this.starts.download.arr[15]).mkdirs();
            }
            catch (Exception ex) {
                Log.fehlerMeldung("StarterClass.StartenProgramm-1", ex);
            }
        }

        @Override
        public synchronized void run() {
            int k = 0;
            long filesize = -1L;
            boolean restart = false;
            boolean startOk = false;
            try {
                if (this.starten()) {
                    restart = true;
                }
                while (restart && !this.starts.stoppen) {
                    startOk = false;
                    restart = false;
                    while (!StarterClass.this.allesStop && !this.starts.stoppen) {
                        try {
                            k = this.starts.process.exitValue();
                            break;
                        }
                        catch (Exception ex) {
                            try {
                                this.wait(2000L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (StarterClass.this.allesStop || this.starts.stoppen) {
                        if (this.starts.process == null) continue;
                        this.starts.process.destroy();
                        if (this.starts.download.getQuelle() == 1) {
                            this.starts.status = 3;
                            continue;
                        }
                        this.starts.status = 1;
                        continue;
                    }
                    if (k != 0) {
                        if (this.starts.download.isRestart()) {
                            File file;
                            if (filesize == -1L) {
                                file = new File(this.starts.download.arr[16]);
                                if (file.exists()) {
                                    filesize = file.length();
                                    startOk = true;
                                } else if (this.starts.startcounter < 3) {
                                    startOk = true;
                                }
                            } else {
                                file = new File(this.starts.download.arr[16]);
                                if (file.exists() && file.length() > filesize) {
                                    startOk = true;
                                    filesize = file.length();
                                }
                            }
                            if (startOk && this.starten()) {
                                restart = true;
                                continue;
                            }
                            this.starts.status = 4;
                            continue;
                        }
                        this.starts.status = 4;
                        continue;
                    }
                    if (this.starts.download.getQuelle() == 1) {
                        this.starts.status = 3;
                        continue;
                    }
                    if (StarterClass.this.pruefen(this.starts)) {
                        this.starts.status = 3;
                        continue;
                    }
                    this.starts.status = 4;
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("StarterClass.StartenProgramm-2", ex);
            }
            StarterClass.this.notifyStartEvent();
        }

        private boolean starten() {
            boolean ret = true;
            this.runtimeExec = new RuntimeExec(this.starts);
            this.starts.process = this.runtimeExec.exec();
            if (this.starts.process == null) {
                this.starts.status = 4;
                ret = false;
            } else {
                ++this.starts.startcounter;
            }
            return ret;
        }
    }

    private class Starten
    implements Runnable {
        Starts starts;

        private Starten() {
        }

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if ((this.starts = StarterClass.this.getListe()) != null) {
                            this.startStarten(this.starts);
                            this.wait(5000L);
                            continue;
                        }
                        StarterClass.this.buttonStartsPutzen();
                        this.wait(3000L);
                    }
                }
                catch (Exception ex) {
                    Log.fehlerMeldung("StarterClass.Starten.run", ex);
                    continue;
                }
                break;
            }
        }

        public void startStarten(Starts starts) {
            switch (starts.download.getArt()) {
                case 2: {
                    StartenProgramm zdfStarten = new StartenProgramm(starts);
                    new Thread(zdfStarten).start();
                    break;
                }
                case 1: {
                    StartenDonwnload podderStart = new StartenDonwnload(starts);
                    new Thread(podderStart).start();
                    break;
                }
                default: {
                    Log.fehlerMeldung("StartetClass.startStarten", "StarterClass.Starten - Switch-default");
                }
            }
        }
    }
}

