/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filme.filmeSuchen;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import mediathek.Daten;
import mediathek.Log;
import mediathek.Main;
import mediathek.controller.filme.FilmListener;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.controller.filme.filmeSuchen.ListeRunSender;
import mediathek.controller.filme.filmeSuchen.RunSender;
import mediathek.controller.filme.filmeSuchen.sender.Mediathek3Sat;
import mediathek.controller.filme.filmeSuchen.sender.MediathekArd;
import mediathek.controller.filme.filmeSuchen.sender.MediathekArdPodcast;
import mediathek.controller.filme.filmeSuchen.sender.MediathekArte7;
import mediathek.controller.filme.filmeSuchen.sender.MediathekBr;
import mediathek.controller.filme.filmeSuchen.sender.MediathekHr;
import mediathek.controller.filme.filmeSuchen.sender.MediathekMdr;
import mediathek.controller.filme.filmeSuchen.sender.MediathekNdr;
import mediathek.controller.filme.filmeSuchen.sender.MediathekOrf;
import mediathek.controller.filme.filmeSuchen.sender.MediathekRbb;
import mediathek.controller.filme.filmeSuchen.sender.MediathekReader;
import mediathek.controller.filme.filmeSuchen.sender.MediathekSf;
import mediathek.controller.filme.filmeSuchen.sender.MediathekSfPod;
import mediathek.controller.filme.filmeSuchen.sender.MediathekSwr;
import mediathek.controller.filme.filmeSuchen.sender.MediathekWdr;
import mediathek.controller.filme.filmeSuchen.sender.MediathekZdf;
import mediathek.controller.io.GetUrl;
import mediathek.daten.ListeFilme;
import mediathek.tool.DatumZeit;

public class FilmeSuchen {
    public LinkedList<MediathekReader> mediathekListe = new LinkedList();
    public boolean allesLaden = true;
    public ListeFilme listeFilmeNeu;
    private ListeFilme listeFilmeAlt = null;
    private EventListenerList listeners = new EventListenerList();
    private ListeRunSender listeSenderLaufen = new ListeRunSender();
    private LinkedList<String> fertigMeldung = new LinkedList();

    public FilmeSuchen() {
        this.initMediathekReader();
    }

    public void filmeBeimSenderLaden(boolean aallesLaden, ListeFilme alteListe) {
        this.allesLaden = aallesLaden;
        this.initStart(alteListe);
        this.listeFilmeNeu.liveStreamEintragen();
        for (MediathekReader mr : this.mediathekListe) {
            new Thread(mr).start();
        }
    }

    public void updateSender(String sender, ListeFilme alteListe) {
        this.allesLaden = false;
        this.initStart(alteListe);
        MediathekReader reader = this.getMediathekReader(sender);
        if (reader != null) {
            new Thread(reader).start();
        }
    }

    private void initStart(ListeFilme alteListe) {
        this.fertigMeldung.clear();
        this.listeFilmeAlt = alteListe;
        this.listeFilmeNeu = new ListeFilme();
        this.listeFilmeNeu.setInfo(alteListe.infos);
        GetUrl.resetSeitenZaehler();
    }

    public boolean senderAn(String sender) {
        MediathekReader r = this.getMediathekReader(sender);
        return r != null && r.istSenderAn();
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    private void initMediathekReader() {
        this.mediathekListe.add(new MediathekArd(this));
        this.mediathekListe.add(new MediathekArdPodcast(this));
        this.mediathekListe.add(new MediathekZdf(this));
        this.mediathekListe.add(new MediathekArte7(this, true));
        this.mediathekListe.add(new MediathekArte7(this, false));
        this.mediathekListe.add(new Mediathek3Sat(this));
        this.mediathekListe.add(new MediathekSwr(this));
        this.mediathekListe.add(new MediathekNdr(this));
        this.mediathekListe.add(new MediathekMdr(this));
        this.mediathekListe.add(new MediathekWdr(this));
        this.mediathekListe.add(new MediathekHr(this));
        this.mediathekListe.add(new MediathekRbb(this));
        this.mediathekListe.add(new MediathekBr(this));
        this.mediathekListe.add(new MediathekSf(this));
        this.mediathekListe.add(new MediathekSfPod(this));
        this.mediathekListe.add(new MediathekOrf(this));
    }

    private MediathekReader getMediathekReader(String sender) {
        MediathekReader ret;
        block1: {
            ret = null;
            if (sender.equals("")) break block1;
            Iterator it = this.mediathekListe.iterator();
            while (it.hasNext() && !(ret = (MediathekReader)it.next()).getSenderName().equalsIgnoreCase(sender)) {
            }
        }
        return ret;
    }

    public synchronized void melden(String sender, int max, int progress, String text) {
        RunSender runSender = this.listeSenderLaufen.getSender(sender);
        if (runSender != null) {
            runSender.max = max;
            runSender.progress = progress;
        } else {
            Log.systemMeldung("Starten " + sender + ": " + DatumZeit.getJetzt_HH_MM_SS());
            this.listeSenderLaufen.add(new RunSender(sender, max, progress));
            if (this.listeSenderLaufen.size() <= 1) {
                this.notifyStart(new FilmListenerElement(sender, text, this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
            }
        }
        this.notifyProgress(new FilmListenerElement(sender, text, this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
        this.progressBar();
    }

    public void meldenFertig(String sender) {
        int MAX_SENDER = 25;
        int MAX1 = 22;
        int MAX2 = 15;
        int MAX3 = 20;
        Log.systemMeldung("Fertig " + sender + ": " + DatumZeit.getJetzt_HH_MM_SS());
        RunSender run = this.listeSenderLaufen.senderFertig(sender);
        if (run != null) {
            String zeile = "";
            zeile = zeile + this.textLaenge(MAX_SENDER, "Sender:   " + run.sender);
            zeile = zeile + this.textLaenge(MAX1, " Laufzeit: " + run.getLaufzeitMinuten() + " Min.");
            zeile = zeile + this.textLaenge(MAX2, " Seiten: " + GetUrl.getSeitenZaehler(run.sender));
            zeile = zeile + this.textLaenge(MAX3, " Ladefehler: " + GetUrl.getSeitenZaehlerFehler(run.sender));
            zeile = zeile + this.textLaenge(MAX3, " Filme: " + this.listeFilmeNeu.countSender(run.sender));
            this.fertigMeldung.add(zeile);
        }
        if (this.listeSenderLaufen.listeFertig()) {
            Log.systemMeldung("Alle Sender fertig: " + DatumZeit.getJetzt_HH_MM_SS());
            this.listeFilmeNeu.sort();
            if (!this.allesLaden) {
                this.listeFilmeNeu.updateListe(this.listeFilmeAlt, true);
            }
            this.listeFilmeAlt = null;
            this.metaDatenSchreiben();
            Log.systemMeldung(this.fertigMeldung.toArray(new String[0]));
            this.notifyFertig(new FilmListenerElement(sender, "", this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
        } else {
            this.notifyProgress(new FilmListenerElement(sender, "", this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
        }
    }

    private void progressBar() {
        int max = this.listeSenderLaufen.getMax();
        int progress = this.listeSenderLaufen.getProgress();
        int proz = 0;
        if (max != 0) {
            int i;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            if (max > 0 && proz == 100) {
                proz = 99;
            }
            String text = "  [ ";
            int a = proz / 10;
            for (i = 0; i < a; ++i) {
                text = text + "#";
            }
            for (i = 0; i < 10 - a; ++i) {
                text = text + "-";
            }
            text = text + " ]  " + GetUrl.getSeitenZaehler() + " Seiten  /  " + proz + "% von " + max + " Themen  /  Filme: " + this.listeFilmeNeu.size();
            Log.progress(text);
        }
    }

    private void metaDatenSchreiben() {
        this.listeFilmeNeu.metaDaten = ListeFilme.newMetaDaten();
        if (!Daten.filmeLaden.getStop()) {
            this.listeFilmeNeu.metaDaten[0] = DatumZeit.getJetzt_ddMMyyyy_HHmm();
            this.listeFilmeNeu.metaDaten[1] = DatumZeit.getJetzt_HH_MM_SS();
            this.listeFilmeNeu.metaDaten[2] = DatumZeit.getHeute_dd_MM_yyyy();
        } else {
            this.listeFilmeNeu.metaDaten[0] = "";
            this.listeFilmeNeu.metaDaten[1] = "";
            this.listeFilmeNeu.metaDaten[2] = "";
        }
        this.listeFilmeNeu.metaDaten[3] = String.valueOf(this.listeFilmeNeu.size());
        this.listeFilmeNeu.metaDaten[4] = "3.0.0";
        try {
            Date d = new Date(Main.class.getResource("Main.class").openConnection().getLastModified());
            this.listeFilmeNeu.metaDaten[5] = "compiled: " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(d);
        }
        catch (IOException ex) {
            Log.fehlerMeldung("FilmeSuchen.metaDatenSchreiben", ex);
        }
    }

    private String textLaenge(int max, String text) {
        if (text.length() > max) {
            text = text.substring(0, max - 1);
        }
        while (text.length() < max) {
            text = text + " ";
        }
        return text;
    }

    private void notifyStart(FilmListenerElement filmListenerElement) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(filmListenerElement);
        }
    }

    private void notifyProgress(FilmListenerElement filmListenerElement) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(filmListenerElement);
        }
    }

    private void notifyFertig(FilmListenerElement filmListenerElement) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig(filmListenerElement);
        }
    }
}

