/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filme.filmUpdateServer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import mediathek.controller.filme.filmUpdateServer.DatenFilmUpdateServer;

public class ListeFilmUpdateServer
extends LinkedList<DatenFilmUpdateServer> {
    public boolean addWithCheck(DatenFilmUpdateServer film) {
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            if (!((DatenFilmUpdateServer)it.next()).arr[1].equals(film.arr[1])) continue;
            return false;
        }
        return this.add(film);
    }

    public void sort() {
        int nr = 0;
        Collections.sort(this);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String str = String.valueOf(nr++);
            while (str.length() < 3) {
                str = "0" + str;
            }
            ((DatenFilmUpdateServer)it.next()).arr[0] = str;
        }
    }

    public String[][] getTableObjectData() {
        ListIterator iterator = this.listIterator();
        String[][] object = new String[this.size()][6];
        int i = 0;
        while (iterator.hasNext()) {
            DatenFilmUpdateServer filmUpdate = (DatenFilmUpdateServer)iterator.next();
            object[i] = filmUpdate.arr;
            ++i;
        }
        return object;
    }

    public int getNr(String url) {
        int nr = 0;
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext() && !((DatenFilmUpdateServer)iterator.next()).arr[1].equals(url)) {
            ++nr;
        }
        if (nr >= this.size()) {
            nr = 0;
        }
        return nr;
    }

    public DatenFilmUpdateServer getNrUpdate(String url) {
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext()) {
            DatenFilmUpdateServer update = (DatenFilmUpdateServer)iterator.next();
            if (!update.arr[1].equals(url)) continue;
            return update;
        }
        return null;
    }

    public String getRand(int errcount) {
        int MAXMINUTEN = 50;
        int minCount = 2;
        if (errcount > 0) {
            minCount = 2 * errcount;
        }
        String ret = "";
        if (!this.isEmpty()) {
            DatenFilmUpdateServer filmUpdate2;
            LinkedList<DatenFilmUpdateServer> listePrio = new LinkedList<DatenFilmUpdateServer>();
            LinkedList<DatenFilmUpdateServer> listeZeit = new LinkedList<DatenFilmUpdateServer>();
            Iterator it = this.iterator();
            Date today = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            int minuten = 200;
            int count = 0;
            while (it.hasNext()) {
                filmUpdate2 = (DatenFilmUpdateServer)it.next();
                String date = filmUpdate2.arr[2] + " " + filmUpdate2.arr[3];
                try {
                    Date d = sdf.parse(date);
                    minuten = Math.round((today.getTime() - d.getTime()) / 60000L);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                if (minuten < 50) {
                    listeZeit.add(filmUpdate2);
                    ++count;
                    continue;
                }
                if (count >= minCount) continue;
                listeZeit.add(filmUpdate2);
                ++count;
            }
            for (DatenFilmUpdateServer filmUpdate2 : listeZeit) {
                if (filmUpdate2.arr[5].equals("1")) {
                    listePrio.add(filmUpdate2.getCopy());
                    continue;
                }
                listePrio.add(filmUpdate2.getCopy());
                listePrio.add(filmUpdate2.getCopy());
            }
            int nr = new Random().nextInt(listePrio.size());
            filmUpdate2 = (DatenFilmUpdateServer)listePrio.get(nr);
            ret = filmUpdate2.arr[1];
        }
        return ret;
    }

    public void listeSchreiben() {
        for (DatenFilmUpdateServer filmUpdate : this) {
            System.out.println("Datum: " + filmUpdate.arr[2] + "   Uhrzeit: " + filmUpdate.arr[3] + "   URL: " + filmUpdate.arr[1]);
        }
    }
}

