/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.Daten;
import mediathek.Log;
import mediathek.controller.filme.BeobFilmeLaden;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.controller.io.IoXmlFilmlisteSchreiben;
import mediathek.daten.ListeFilme;

public class MediathekNoGui {
    public final String STARTP_ALLES = "-alles";
    public final String STARTP_USER_AGENT = "-agent";
    public final String STARTP_EXPORT_DATEI = "-o";
    public final String STARTP_IMPORT_URL = "-i";
    private String output = "";
    private String importUrl = "";
    private String userAgent = "";
    private boolean allesLaden = false;
    private Date startZeit = new Date(System.currentTimeMillis());
    private Date stopZeit = null;
    private String pfad = "";
    private Daten daten;

    public MediathekNoGui(String[] ar) {
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                this.pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-alles")) {
                    this.allesLaden = true;
                }
                if (ar[i].equalsIgnoreCase("-o") && ar.length > i) {
                    this.output = ar[i + 1];
                }
                if (ar[i].equalsIgnoreCase("-i") && ar.length > i) {
                    this.importUrl = ar[i + 1];
                }
                if (!ar[i].equalsIgnoreCase("-agent") || ar.length <= i) continue;
                this.userAgent = ar[i + 1];
            }
        }
        this.daten = new Daten(this.pfad);
        if (!this.userAgent.equals("")) {
            Daten.setUserAgentManuel(this.userAgent);
        }
        Log.startMeldungen(this.getClass().getName());
        if (this.allesLaden) {
            Log.systemMeldung("Programmstart: alles laden");
        } else {
            Log.systemMeldung("Programmstart: nur update laden");
        }
        Log.systemMeldung("ImportUrl: " + this.importUrl);
        Log.systemMeldung("Outputfile: " + this.output);
    }

    public void starten() {
        Daten.filmeLaden.addAdListener(new BeobachterLadenFilme());
        Daten.ioXmlFilmlisteLesen.filmlisteLesen(Daten.getBasisVerzeichnis() + "filme.xml", false, Daten.listeFilme);
        Daten.filmeLaden.filmeBeimSenderSuchen(Daten.listeFilme, this.allesLaden);
    }

    private void addImportListe(String url) {
        if (!url.equals("")) {
            Log.systemMeldung("Filmliste importieren von: " + url);
            ListeFilme tmpListe = new ListeFilme();
            Daten.ioXmlFilmlisteLesen.filmlisteLesen(url, false, tmpListe);
            Daten.listeFilme.updateListe(tmpListe, false);
            tmpListe.clear();
        }
    }

    private void undTschuess() {
        int minuten;
        Daten.listeFilme = Daten.filmeLaden.getListeFilme();
        if (!this.importUrl.equals("")) {
            this.addImportListe(this.importUrl);
        }
        new IoXmlFilmlisteSchreiben().filmeSchreiben(Daten.getBasisVerzeichnis(true) + "filme.xml", Daten.listeFilme);
        if (!this.output.equals("")) {
            LinkedList<String> out = new LinkedList<String>();
            do {
                if (this.output.startsWith(",")) {
                    this.output = this.output.substring(1);
                }
                if (this.output.contains(",")) {
                    String tmp = this.output.substring(0, this.output.indexOf(","));
                    this.output = this.output.substring(this.output.indexOf(","));
                    out.add(tmp);
                    continue;
                }
                out.add(this.output);
            } while (this.output.contains(","));
            Iterator it = out.iterator();
            while (it.hasNext()) {
                new IoXmlFilmlisteSchreiben().filmeSchreiben((String)it.next(), Daten.listeFilme);
            }
        }
        this.stopZeit = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        try {
            minuten = Math.round((this.stopZeit.getTime() - this.startZeit.getTime()) / 60000L);
        }
        catch (Exception ex) {
            minuten = -1;
        }
        Log.systemMeldung(new String[]{"========================================", "  " + Daten.filmeLaden.getSeitenGeladen() + " Seiten geladen", "  " + Daten.listeFilme.size() + " Filme gesamt", "  --> Beginn: " + sdf.format(this.startZeit), "  --> Fertig: " + sdf.format(this.stopZeit), "  --> Dauer[Min]: " + (minuten == 0 ? "<1" : Integer.valueOf(minuten)), "========================================"});
        if (Daten.listeFilme.isEmpty()) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    private class BeobachterLadenFilme
    extends BeobFilmeLaden {
        private BeobachterLadenFilme() {
        }

        @Override
        public void fertig(FilmListenerElement filmListenerElement) {
            MediathekNoGui.this.undTschuess();
        }
    }
}

