/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.io.File;
import javax.swing.event.EventListenerList;
import mediathek.Log;
import mediathek.controller.filme.FilmeLaden;
import mediathek.controller.filme.filmeImportieren.MediathekListener;
import mediathek.controller.io.IoXmlFilmlisteLesen;
import mediathek.controller.io.IoXmlFilmlisteSchreiben;
import mediathek.daten.ListeFilme;

public class Daten {
    public static String[] system = new String[37];
    public static boolean debug = false;
    private static boolean geaendert = false;
    private static String basisverzeichnis = "";
    public static FilmeLaden filmeLaden;
    public static IoXmlFilmlisteLesen ioXmlFilmlisteLesen;
    public static ListeFilme listeFilme;
    private static EventListenerList listeners;
    public static final String LINE_SEPARATOR;

    public Daten(String pfad) {
        basisverzeichnis = pfad;
        this.init();
    }

    private void init() {
        for (int i = 0; i < system.length; ++i) {
            Daten.system[i] = "";
        }
        Daten.system[15] = "1";
        Daten.system[25] = "1";
        Daten.system[3] = "MediathekView 3.0.0";
        Daten.system[25] = "1";
        Daten.system[1] = "1";
        Daten.system[4] = "3.0.0";
        Daten.system[27] = Boolean.TRUE.toString();
        listeFilme = new ListeFilme();
        ioXmlFilmlisteLesen = new IoXmlFilmlisteLesen();
        filmeLaden = new FilmeLaden();
    }

    public static synchronized void addAdListener(MediathekListener listener) {
        listeners.add(MediathekListener.class, listener);
    }

    public static synchronized void notifyMediathekListener(int ereignis, String klasse) {
        for (MediathekListener l : (MediathekListener[])listeners.getListeners(MediathekListener.class)) {
            if (l.ereignis != ereignis || l.klasse.equals(klasse)) continue;
            l.ping();
        }
    }

    public static void setUserAgentAuto() {
        Daten.system[2] = Boolean.TRUE.toString();
    }

    public static void setUserAgentManuel(String ua) {
        Daten.system[2] = Boolean.FALSE.toString();
        Daten.system[3] = ua;
    }

    public static boolean isUserAgentAuto() {
        if (system[2].equals("")) {
            Daten.system[2] = Boolean.TRUE.toString();
            return true;
        }
        return Boolean.parseBoolean(system[2]);
    }

    public static String getUserAgent() {
        if (Daten.isUserAgentAuto()) {
            return "MediathekView 3.0.0";
        }
        return system[3];
    }

    public void setGeaendertPanel() {
        geaendert = true;
    }

    public static void setGeaendert() {
        geaendert = true;
    }

    public static boolean isGeaendert() {
        return geaendert;
    }

    public static String getBasisVerzeichnis() {
        return Daten.getBasisVerzeichnis(false);
    }

    public static String getBasisVerzeichnis(boolean anlegen) {
        return Daten.getBasisVerzeichnis(basisverzeichnis, anlegen);
    }

    private static String getBasisVerzeichnis(String basis, boolean anlegen) {
        File basisF;
        String ret = basis.equals("") ? System.getProperty("user.home") + File.separator + ".mediathek3" + File.separator : basis;
        if (anlegen && !(basisF = new File(ret)).exists() && !basisF.mkdir()) {
            Log.fehlerMeldung("Daten.getBasisVerzeichnis", new String[]{"Kann den Ordner zum Speichern der Daten nicht anlegen!", "Daten.getBasisVerzeichnis"});
        }
        return ret;
    }

    public void allesLaden() {
        ioXmlFilmlisteLesen.filmlisteLesen(Daten.getBasisVerzeichnis() + "filme.xml", false, listeFilme);
    }

    public void allesSpeichern() {
        new IoXmlFilmlisteSchreiben().filmeSchreiben(Daten.getBasisVerzeichnis(true) + "filme.xml", listeFilme);
    }

    public void allesAbbrechen() {
    }

    static {
        ioXmlFilmlisteLesen = null;
        listeFilme = null;
        listeners = new EventListenerList();
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

