/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import com.ibm.icu.text.Normalizer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.limewire.util.AbstractI18NConverter;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;

final class I18NConvertICU
extends AbstractI18NConverter {
    private BitSet _excluded;
    private BitSet _replaceWithSpace;
    private Map _cMap;

    I18NConvertICU() throws IOException, ClassNotFoundException {
        BitSet bs = null;
        BitSet bs2 = null;
        HashMap hm = null;
        InputStream fi = CommonUtils.getResourceStream("org/limewire/util/excluded.dat");
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fi));
        bs = (BitSet)ois.readObject();
        ois.close();
        fi = CommonUtils.getResourceStream("org/limewire/util/caseMap.dat");
        ois = new ConverterObjectInputStream(new BufferedInputStream(fi));
        hm = (HashMap)ois.readObject();
        ois.close();
        fi = CommonUtils.getResourceStream("org/limewire/util/replaceSpace.dat");
        ois = new ObjectInputStream(new BufferedInputStream(fi));
        bs2 = (BitSet)ois.readObject();
        ois.close();
        this._excluded = bs;
        this._cMap = hm;
        this._replaceWithSpace = bs2;
    }

    @Override
    public String getNorm(String s) {
        return this.convert(s);
    }

    @Override
    public String compose(String s) {
        return Normalizer.compose(s, false);
    }

    private String convert(String s) {
        String nfkd = Normalizer.decompose(s, true);
        StringBuilder buf = new StringBuilder();
        int len = nfkd.length();
        for (int i = 0; i < len; ++i) {
            char c = nfkd.charAt(i);
            if (this._replaceWithSpace.get(c)) {
                buf.append(" ");
                continue;
            }
            if (this._excluded.get(c)) continue;
            String lower = (String)this._cMap.get(String.valueOf(c));
            if (lower != null) {
                buf.append(lower);
                continue;
            }
            buf.append(c);
        }
        return this.blockSplit(Normalizer.compose(buf.toString(), false));
    }
}

