/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.ui.swing.table.GlazedJXTable;
import org.limewire.ui.swing.util.EventListColumnComparator;
import org.limewire.ui.swing.util.EventListTableSortFormat;

public class EventListJXTableSorting {
    private static final int MAX_SORT_COLUMNS = 5;
    private final SortedList sortedList;
    private final GlazedJXTable table;
    private final SortController sortController;
    private final SortController originalSortController;
    private final EventListTableSortFormat tableSortFormat;

    private EventListJXTableSorting(GlazedJXTable table, SortedList sortedList, EventListTableSortFormat tableSortFormat) {
        this.table = table;
        this.sortedList = sortedList;
        this.tableSortFormat = tableSortFormat;
        this.originalSortController = table.getSortController();
        this.sortController = new EventListSortController();
        table.setSortController(this.sortController);
        if (tableSortFormat != null) {
            List<SortKey> sortKeys = tableSortFormat.getDefaultSortKeys();
            this.sortController.setSortKeys(sortKeys);
        }
    }

    public static EventListJXTableSorting install(GlazedJXTable table, SortedList sortedList) {
        return new EventListJXTableSorting(table, sortedList, null);
    }

    public static EventListJXTableSorting install(GlazedJXTable table, SortedList sortedList, EventListTableSortFormat tableSortFormat) {
        return new EventListJXTableSorting(table, sortedList, tableSortFormat);
    }

    public void uninstall() {
        this.table.setSortController(this.originalSortController);
    }

    private class EventListSortController
    implements SortController {
        private final List<SortKey> sortKeys = new ArrayList<SortKey>(5);
        private final List<SortKey> sortKeysReadOnly = Collections.unmodifiableList(this.sortKeys);
        private final List<SortKey> nonHiddenSortKeys = new ArrayList<SortKey>(5);
        private final List<SortKey> nonHiddenKeysReadOnly = Collections.unmodifiableList(this.nonHiddenSortKeys);

        private EventListSortController() {
        }

        @Override
        public void toggleSortOrder(int columnIndex) {
            this.toggleSortOrder(columnIndex, GlazedLists.comparableComparator());
        }

        @Override
        public void toggleSortOrder(int columnIndex, Comparator comparator) {
            List<? extends SortKey> sortKeys = this.getSortKeys();
            SortKey columnSortKey = null;
            for (SortKey sortKey : sortKeys) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED || sortKey.getColumn() != columnIndex) continue;
                columnSortKey = sortKey;
                break;
            }
            if (columnSortKey == null) {
                columnSortKey = new SortKey(SortOrder.ASCENDING, columnIndex);
            } else {
                SortOrder sortOrder = columnSortKey.getSortOrder() == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                columnSortKey = new SortKey(sortOrder, columnIndex);
            }
            List<? extends SortKey> newSortKeys = sortKeys;
            if (EventListJXTableSorting.this.tableSortFormat != null) {
                List<Integer> list = EventListJXTableSorting.this.tableSortFormat.getSecondarySortColumns(columnIndex);
                for (int i = list.size(); i > 0; --i) {
                    Integer secondaryColumn = list.get(i - 1);
                    SortKey sortKey = this.findSortKey(secondaryColumn, sortKeys);
                    newSortKeys = this.buildSortKeys(sortKey, newSortKeys);
                }
            }
            this.setSortKeys(this.buildSortKeys(columnSortKey, newSortKeys));
        }

        private SortKey findSortKey(int column, List<? extends SortKey> sortKeys) {
            for (SortKey sortKey : sortKeys) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED || sortKey.getColumn() != column) continue;
                return new SortKey(sortKey.getSortOrder(), column);
            }
            return new SortKey(SortOrder.ASCENDING, column);
        }

        private List<? extends SortKey> buildSortKeys(SortKey firstKey, List<? extends SortKey> sortKeys) {
            ArrayList<SortKey> newSortKeys = new ArrayList<SortKey>();
            HashSet<Integer> columnSet = new HashSet<Integer>();
            newSortKeys.add(firstKey);
            columnSet.add(firstKey.getColumn());
            for (SortKey sortKey : sortKeys) {
                if (newSortKeys.size() >= 5) break;
                if (sortKey.getSortOrder() == SortOrder.UNSORTED || columnSet.contains(sortKey.getColumn())) continue;
                newSortKeys.add(sortKey);
                columnSet.add(sortKey.getColumn());
            }
            return newSortKeys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSortKeys(List<? extends SortKey> sortKeys) {
            if (sortKeys == this.sortKeysReadOnly) {
                return;
            }
            if (sortKeys == null) {
                sortKeys = Collections.emptyList();
            }
            this.sortKeys.clear();
            this.nonHiddenSortKeys.clear();
            if (EventListJXTableSorting.this.tableSortFormat != null && EventListJXTableSorting.this.tableSortFormat.getPreSortColumns() != null && EventListJXTableSorting.this.tableSortFormat.getPreSortColumns().size() > 0) {
                this.sortKeys.addAll(EventListJXTableSorting.this.tableSortFormat.getPreSortColumns());
            }
            this.nonHiddenSortKeys.addAll(sortKeys);
            this.sortKeys.addAll(sortKeys);
            ArrayList comparators = new ArrayList(this.sortKeys.size());
            for (int k = 0; k < this.sortKeys.size(); ++k) {
                SortKey sortKey = this.sortKeys.get(k);
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                Comparator comparator = this.getComparator(sortKey.getColumn());
                if (sortKey.getSortOrder() == SortOrder.DESCENDING) {
                    comparator = GlazedLists.reverseComparator(comparator);
                }
                comparators.add(comparator);
            }
            Comparator comparator = comparators.isEmpty() ? null : (comparators.size() == 1 ? (Comparator)comparators.get(0) : GlazedLists.chainComparators(comparators));
            EventListJXTableSorting.this.sortedList.getReadWriteLock().writeLock().lock();
            try {
                EventListJXTableSorting.this.sortedList.setComparator(comparator);
            }
            finally {
                EventListJXTableSorting.this.sortedList.getReadWriteLock().writeLock().unlock();
            }
        }

        private Comparator getComparator(int modelIndex) {
            DefaultEventTableModel tableModel = (DefaultEventTableModel)EventListJXTableSorting.this.table.getModel();
            TableFormat tableFormat = tableModel.getTableFormat();
            if (tableFormat instanceof AdvancedTableFormat) {
                return new EventListColumnComparator(tableFormat, modelIndex, ((AdvancedTableFormat)tableFormat).getColumnComparator(modelIndex));
            }
            return new TableColumnComparator(tableFormat, modelIndex);
        }

        @Override
        public List<? extends SortKey> getSortKeys() {
            return this.nonHiddenKeysReadOnly;
        }

        @Override
        public SortOrder getSortOrder(int columnIndex) {
            for (SortKey s : this.sortKeys) {
                if (s.getColumn() != columnIndex) continue;
                return s.getSortOrder();
            }
            return SortOrder.UNSORTED;
        }
    }
}

