/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.tray;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.tray.BasicNotifier;
import org.limewire.ui.swing.tray.Notification;
import org.limewire.ui.swing.tray.TrayNotifier;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;

class SystemTrayNotifier
implements TrayNotifier {
    private final SystemTray tray;
    private final TrayIcon trayIcon;
    private final PopupMenu popupMenu;
    private final BasicNotifier basicNotifier = new BasicNotifier();
    @Resource
    private Icon windowsIconResource16;
    @Resource
    private Icon windowsIconResource32;
    @Resource
    private Icon windowsIconResource48;
    @Resource
    private Icon linuxIconResource16;
    @Resource
    private Icon linuxIconResource24;
    @Resource
    private Icon linuxIconResource32;
    @Resource
    private Icon linuxIconResource48;

    public SystemTrayNotifier() {
        if (SystemTray.isSupported()) {
            GuiUtils.assignResources(this);
            this.tray = SystemTray.getSystemTray();
            this.popupMenu = this.buildPopupMenu();
            this.trayIcon = this.buildTrayIcon("LimeWire");
        } else {
            this.tray = null;
            this.trayIcon = null;
            this.popupMenu = null;
        }
    }

    private TrayIcon buildTrayIcon(String desc) {
        Icon icon = this.getIcon();
        TrayIcon trayIcon = new TrayIcon(((ImageIcon)icon).getImage(), desc, this.popupMenu);
        trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationActionMap map = Application.getInstance().getContext().getActionManager().getActionMap();
                map.get("restoreView").actionPerformed(e);
            }
        });
        trayIcon.setImageAutoSize(true);
        return trayIcon;
    }

    private Icon getIcon() {
        Dimension iconSize = SystemTray.getSystemTray().getTrayIconSize();
        if (iconSize == null || iconSize.getWidth() <= 16.0) {
            return OSUtils.isWindows() ? this.windowsIconResource16 : this.linuxIconResource16;
        }
        if (iconSize.getWidth() <= 24.0) {
            return OSUtils.isWindows() ? this.windowsIconResource16 : this.linuxIconResource24;
        }
        if (iconSize.getWidth() <= 32.0) {
            return OSUtils.isWindows() ? this.windowsIconResource32 : this.linuxIconResource32;
        }
        return OSUtils.isWindows() ? this.windowsIconResource48 : this.linuxIconResource48;
    }

    private PopupMenu buildPopupMenu() {
        PopupMenu menu = new PopupMenu();
        MenuItem item = new MenuItem(I18n.tr("Show LimeWire"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationActionMap map = Application.getInstance().getContext().getActionManager().getActionMap();
                map.get("restoreView").actionPerformed(e);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new MenuItem(I18n.tr("Exit After Transfers"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationActionMap map = Application.getInstance().getContext().getActionManager().getActionMap();
                map.get("shutdownAfterTransfers").actionPerformed(e);
            }
        });
        menu.add(item);
        item = new MenuItem(I18n.tr("Exit"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.getInstance().exit(e);
            }
        });
        menu.add(item);
        return menu;
    }

    @Override
    public boolean isExitEvent(EventObject event) {
        if (!SwingUiSettings.MINIMIZE_TO_TRAY.getValue()) {
            return true;
        }
        if (event != null && event.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)event.getSource();
            return item.getParent() == this.popupMenu;
        }
        if (event instanceof ActionEvent) {
            return "Shutdown".equals(((ActionEvent)event).getActionCommand());
        }
        return false;
    }

    @Override
    public boolean showTrayIcon() {
        if (this.tray == null) {
            return false;
        }
        try {
            this.tray.add(this.trayIcon);
        }
        catch (AWTException e) {
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsSystemTray() {
        return this.trayIcon != null && this.tray != null;
    }

    @Override
    public void hideTrayIcon() {
        if (this.tray != null) {
            this.tray.remove(this.trayIcon);
        }
    }

    @Override
    public void showMessage(Notification notification) {
        this.basicNotifier.showMessage(notification);
    }

    @Override
    public void hideMessage(Notification notification) {
        this.basicNotifier.hideMessage(notification);
    }

    public void updateUI() {
        this.basicNotifier.updateUI();
    }
}

