/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.tray;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdesktop.application.Resource;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.tray.Notification;
import org.limewire.ui.swing.tray.NotificationWindow;
import org.limewire.ui.swing.tray.TrayNotifier;
import org.limewire.ui.swing.tray.WindowDisposedEvent;
import org.limewire.ui.swing.util.GuiUtils;

final class BasicNotifier
implements TrayNotifier {
    @Resource
    private Icon notificationIcon;
    private WindowManager windowManager = new WindowManager();

    public BasicNotifier() {
        GuiUtils.assignResources(this);
    }

    @Override
    public boolean supportsSystemTray() {
        return false;
    }

    @Override
    public boolean showTrayIcon() {
        return false;
    }

    @Override
    public void hideTrayIcon() {
    }

    @Override
    public void showMessage(Notification notification) {
        this.windowManager.createWindow(notification);
    }

    @Override
    public void hideMessage(Notification notification) {
        this.windowManager.hideMessage(notification);
    }

    public void updateUI() {
    }

    @Override
    public boolean isExitEvent(EventObject event) {
        return false;
    }

    private GraphicsConfiguration getGraphicsConfiguration(Point location) {
        GraphicsDevice[] screenDevices;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice screenDevice : screenDevices = ge.getScreenDevices()) {
            GraphicsConfiguration gc;
            if (screenDevice.getType() != 0 || !(gc = screenDevice.getDefaultConfiguration()).getBounds().contains(location)) continue;
            return gc;
        }
        return null;
    }

    private class WindowManager
    implements EventListener<WindowDisposedEvent> {
        private final List<NotificationWindow> notificationWindows = Collections.synchronizedList(new ArrayList());
        private final Map<Notification, NotificationWindow> notifications = Collections.synchronizedMap(new HashMap());

        public synchronized void hideMessage(Notification notification) {
            NotificationWindow notificationWindow = this.notifications.get(notification);
            notificationWindow.dispose();
            this.notifications.remove(notification);
            this.notificationWindows.remove(notification);
            this.bumpWindows();
        }

        public synchronized void createWindow(Notification notification) {
            Icon icon = notification.getIcon() != null ? notification.getIcon() : BasicNotifier.this.notificationIcon;
            NotificationWindow notificationWindow = new NotificationWindow(icon, notification);
            notificationWindow.addListener(this);
            notificationWindow.setLocation(this.getNewWindowLocation(notificationWindow, -1 * notificationWindow.getPreferredSize().height));
            this.notificationWindows.add(notificationWindow);
            this.bumpWindows();
        }

        private synchronized void bumpWindows() {
            int totalWindowHeight = 0;
            for (int i = 0; i < this.notificationWindows.size(); ++i) {
                NotificationWindow notificationWindow = this.notificationWindows.get(this.notificationWindows.size() - (i + 1));
                Point newLocation = this.getNewWindowLocation(notificationWindow, totalWindowHeight);
                notificationWindow.moveTo(newLocation);
                Dimension preferredSize = notificationWindow.getPreferredSize();
                totalWindowHeight += preferredSize.height + 10;
            }
        }

        public Point getNewWindowLocation(NotificationWindow notificationWindow, int startHeight) {
            Rectangle screenBounds;
            Insets screenInsets;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            GraphicsConfiguration gc = BasicNotifier.this.getGraphicsConfiguration(new Point(screenSize.width - 1, screenSize.height - 1));
            if (gc != null) {
                screenInsets = toolkit.getScreenInsets(gc);
                screenBounds = gc.getBounds();
            } else {
                screenInsets = new Insets(0, 0, 0, 0);
                screenBounds = new Rectangle(toolkit.getScreenSize());
            }
            int screenWidth = screenBounds.width - Math.abs(screenInsets.right);
            int screenHeight = screenBounds.height - Math.abs(screenInsets.bottom);
            Dimension preferredSize = notificationWindow.getPreferredSize();
            Point newLocation = new Point(screenWidth - preferredSize.width, screenHeight - preferredSize.height - startHeight);
            return newLocation;
        }

        @Override
        public synchronized void handleEvent(WindowDisposedEvent event) {
            NotificationWindow notificationWindow = event.getNotWindow();
            this.notificationWindows.remove(notificationWindow);
            this.notifications.remove(notificationWindow.getNotification());
            notificationWindow.dispose();
            this.bumpWindows();
        }
    }
}

