/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.ui.swing.table.GlazedJXTable;
import org.limewire.ui.swing.util.GuiUtils;

public class TableCellHeaderRenderer
extends JXLabel
implements TableCellRenderer {
    @Resource
    private Color topBorderColor;
    @Resource
    private Color bottomBorderColor;
    @Resource
    private Color topGradientColor;
    @Resource
    private Color bottomGradientColor;
    @Resource
    private Color leftBorderColor;
    @Resource
    private Color rightBorderColor;
    @Resource
    private Color fontColor;
    @Resource
    private Icon downIcon;
    @Resource
    private Icon upIcon;
    private final Border emptyBorder;
    private final Font font;
    private Icon sortIcon;

    public TableCellHeaderRenderer() {
        this(10);
    }

    public TableCellHeaderRenderer(int horizontalAlignment) {
        GuiUtils.assignResources(this);
        switch (horizontalAlignment) {
            case 4: 
            case 11: {
                this.emptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 10);
                break;
            }
            default: {
                this.emptyBorder = BorderFactory.createEmptyBorder(0, 10, 0, 0);
            }
        }
        this.font = this.getFont().deriveFont(1, 11.0f);
        this.setHorizontalAlignment(horizontalAlignment);
        this.setHorizontalTextPosition(2);
        this.setForeground(this.fontColor);
        this.setBackgroundPainter(new HeaderBackgroundPainter());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof String) {
            this.setText((String)value);
        } else if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        this.setIcon(this.sortIcon);
        this.setPreferredSize(new Dimension(20, this.getPreferredSize().width));
        this.setBorder(this.emptyBorder);
        this.setFont(this.font);
        if (column >= 0) {
            SortOrder order = this.getSortOrder(table, table.convertColumnIndexToModel(column));
            if (order == SortOrder.UNSORTED) {
                this.setIcon(null);
            } else if (order == SortOrder.ASCENDING) {
                this.setIcon(this.upIcon);
            } else {
                this.setIcon(this.downIcon);
            }
        }
        return this;
    }

    private SortOrder getSortOrder(JTable table, int modelColumn) {
        if (table instanceof GlazedJXTable) {
            SortController sortController = ((GlazedJXTable)table).getSortController();
            if (sortController == null) {
                return SortOrder.UNSORTED;
            }
            List<? extends SortKey> sortKeys = sortController.getSortKeys();
            if (sortKeys == null) {
                return SortOrder.UNSORTED;
            }
            SortKey firstKey = SortKey.getFirstSortingKey(sortKeys);
            if (firstKey != null && firstKey.getColumn() == modelColumn) {
                return firstKey.getSortOrder();
            }
            return SortOrder.UNSORTED;
        }
        return SortOrder.UNSORTED;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    private class HeaderBackgroundPainter
    extends AbstractPainter<JXLabel> {
        private RectanglePainter<JXLabel> painter = new RectanglePainter();

        public HeaderBackgroundPainter() {
            this.painter.setFillPaint(new GradientPaint(0.0f, 0.0f, TableCellHeaderRenderer.this.topGradientColor, 0.0f, 1.0f, TableCellHeaderRenderer.this.bottomGradientColor, false));
            this.painter.setFillVertical(true);
            this.painter.setFillHorizontal(true);
            this.painter.setPaintStretched(true);
            this.painter.setBorderPaint(null);
        }

        @Override
        protected void doPaint(Graphics2D g, JXLabel object, int width, int height) {
            this.painter.paint(g, object, width, height);
            g.setColor(TableCellHeaderRenderer.this.topBorderColor);
            g.drawLine(0, 0, width, 0);
            g.setColor(TableCellHeaderRenderer.this.bottomBorderColor);
            g.drawLine(0, height - 1, width, height - 1);
            g.setColor(TableCellHeaderRenderer.this.leftBorderColor);
            g.drawLine(0, 0, 0, height - 2);
            g.setColor(TableCellHeaderRenderer.this.rightBorderColor);
            g.drawLine(width - 1, 0, width - 1, height);
        }
    }
}

