/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.player;

import java.awt.Canvas;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicReference;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.media.protocol.file.DataSource;
import net.sf.fmj.mf.media.content.unknown.Handler;
import org.limewire.util.ExceptionUtils;
import org.limewire.util.OSUtils;

class VideoPlayerFactory {
    VideoPlayerFactory() {
    }

    public Player createVideoPlayer(File file, final Container parentComponent) throws IncompatibleSourceException {
        if (!OSUtils.isWindows() && !OSUtils.isMacOSX()) {
            throw new IllegalStateException("Video is only supported on Windows and Mac");
        }
        if (OSUtils.isMacOSX() && file.getName().toLowerCase().endsWith("avi")) {
            throw new IncompatibleSourceException("AVI files are not supported by LimeWire's built in video player on OS X.");
        }
        if (OSUtils.isWindows7()) {
            return this.createWindows7Player(file, parentComponent);
        }
        final AbstractPlayer handler = OSUtils.isWindows() ? new net.sf.fmj.ds.media.content.unknown.Handler() : new net.sf.fmj.qt.media.content.unknown.Handler();
        this.setupPlayer(handler, file);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                parentComponent.add(handler.getVisualComponent());
            }
        });
        return handler;
    }

    private Player createWindows7Player(File file, final Container parentComponent) throws IncompatibleSourceException {
        final net.sf.fmj.ds.media.content.unknown.Handler dsPlayer = new net.sf.fmj.ds.media.content.unknown.Handler();
        try {
            this.setupPlayer(dsPlayer, file);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    parentComponent.add(dsPlayer.getVisualComponent());
                }
            });
            return dsPlayer;
        }
        catch (IncompatibleSourceException e) {
            final AtomicReference mfCanvas = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Canvas canvas = new Canvas();
                        parentComponent.add(canvas);
                        parentComponent.addNotify();
                        mfCanvas.set(canvas);
                    }
                });
            }
            catch (InterruptedException e2) {
                throw new IncompatibleSourceException(e2.toString() + " \n" + ExceptionUtils.getStackTrace(e2));
            }
            catch (InvocationTargetException e3) {
                throw new IncompatibleSourceException(e3.toString() + " \n" + ExceptionUtils.getStackTrace(e3));
            }
            Handler mfPlayer = new Handler((Canvas)mfCanvas.get());
            this.setupPlayer(mfPlayer, file);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    parentComponent.setPreferredSize(((Canvas)mfCanvas.get()).getPreferredSize());
                }
            });
            return mfPlayer;
        }
    }

    private void setupPlayer(Player player, File file) throws IncompatibleSourceException {
        try {
            player.setSource(this.createDataSource(file));
        }
        catch (IOException e) {
            throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
        }
        catch (UnsatisfiedLinkError e) {
            throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
        }
        player.realize();
    }

    private javax.media.protocol.DataSource createDataSource(File file) throws MalformedURLException {
        DataSource source = new DataSource();
        if (OSUtils.isMacOSX()) {
            source.setLocator(new MediaLocator("file:///" + file.getAbsolutePath()));
        } else {
            String urlString = file.toURI().toURL().toExternalForm();
            source.setLocator(new MediaLocator(urlString));
        }
        return source;
    }
}

