/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.MessageWriter;
import org.limewire.friend.api.Network;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.OverlayPopupPanel;
import org.limewire.ui.swing.friends.chat.ChatFrame;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatHeader;
import org.limewire.ui.swing.friends.chat.ChatMessageEvent;
import org.limewire.ui.swing.friends.chat.ChatModel;
import org.limewire.ui.swing.friends.chat.ChatSettings;
import org.limewire.ui.swing.friends.chat.IncomingListener;
import org.limewire.ui.swing.friends.chat.Message;
import org.limewire.ui.swing.mainframe.GlobalLayeredPane;
import org.limewire.ui.swing.tray.Notification;
import org.limewire.ui.swing.tray.TrayNotifier;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.ui.swing.util.ResizeUtils;

@LazySingleton
public class ChatMediator {
    @Resource
    private Font font;
    @Resource
    private Color foreground;
    @Resource
    private Icon unviewedChatIcon;
    @Resource
    private Icon normalChatIcon;
    private final Provider<ChatHeader> chatHeaderProvider;
    private final JLayeredPane layeredPane;
    private final Provider<ChatModel> chatModel;
    private final Provider<ChatFrame> chatFrameProvider;
    private ChatFrame chatFrame;
    private Frame panel;
    private final JXButton chatButton;
    private final TrayNotifier trayNotifier;
    private IncomingListener incomingChatListener;
    private Set<String> unseenMessages = new HashSet<String>();
    private volatile FriendConnectionEvent lastEvent;

    @Inject
    public ChatMediator(Provider<ChatFrame> chatFrameProvider, Provider<ChatHeader> chatHeaderProvider, TrayNotifier trayNotifier, Provider<ChatModel> chatModel, @GlobalLayeredPane JLayeredPane layeredPane) {
        this.chatFrameProvider = chatFrameProvider;
        this.chatHeaderProvider = chatHeaderProvider;
        this.layeredPane = layeredPane;
        this.trayNotifier = trayNotifier;
        this.chatModel = chatModel;
        this.chatButton = new JXButton();
        this.initChatButton();
    }

    private Panel getChatFrame() {
        if (this.panel == null) {
            JPanel child;
            this.panel = new Frame(this.layeredPane);
            if (this.isFacebook()) {
                child = this.getFacebookPanel();
            } else {
                this.chatFrame = this.chatFrameProvider.get();
                child = this.chatFrame;
            }
            this.panel.add((Component)child, "Center");
            child.revalidate();
        }
        return this.panel;
    }

    private boolean isFacebook() {
        return ((FriendConnection)this.lastEvent.getSource()).getConfiguration().getType() == Network.Type.FACEBOOK;
    }

    public JXButton getChatButton() {
        return this.chatButton;
    }

    public void setVisible(boolean value) {
        this.getChatFrame().setVisible(value);
        this.panel.resize();
        if (this.unseenMessages.size() > 0) {
            this.unseenMessages.clear();
            this.setUnseenMessageCount(this.unseenMessages.size());
        }
        this.getChatButton().repaint();
    }

    public boolean isVisible() {
        return this.panel != null && this.panel.isVisible();
    }

    public void startOrSelectConversation(String friendId) {
        this.setVisible(true);
        if (!this.isFacebook()) {
            this.chatFrame.selectOrStartConversation(this.chatModel.get().getChatFriend(friendId));
        }
    }

    private void initChatButton() {
        GuiUtils.assignResources(this);
        this.chatButton.setFocusPainted(false);
        this.chatButton.setOpaque(false);
        this.chatButton.setBorder(null);
        this.chatButton.setContentAreaFilled(false);
        this.chatButton.setFocusable(false);
        this.chatButton.setBorder(BorderFactory.createEmptyBorder(2, 10, 0, 10));
        this.chatButton.setPaintBorderInsets(true);
        this.chatButton.setFont(this.font);
        this.chatButton.setForeground(this.foreground);
        this.chatButton.setVisible(false);
        this.chatButton.setText(I18n.tr("Chat"));
        this.chatButton.setIcon(this.normalChatIcon);
        this.chatButton.setBackgroundPainter(new ChatButtonPainter());
    }

    @Inject
    void register(ListenerSupport<FriendConnectionEvent> connectionSupport, final ListenerSupport<ChatMessageEvent> messageList) {
        final EventListener<ChatMessageEvent> messageListener = new EventListener<ChatMessageEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(ChatMessageEvent event) {
                ChatMediator.this.handleChatMessage((Message)event.getData());
            }
        };
        connectionSupport.addListener(new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                ChatMediator.this.lastEvent = event;
                switch ((FriendConnectionEvent.Type)((Object)event.getType())) {
                    case CONNECTED: {
                        ((ChatModel)ChatMediator.this.chatModel.get()).registerListeners();
                        if (ChatMediator.this.incomingChatListener == null) {
                            ChatMediator.this.incomingChatListener = new IncomingListener(){

                                @Override
                                public void incomingChat(ChatFriend chatFriend, MessageWriter messageWriter) {
                                    ChatMediator.this.getChatFrame();
                                    ChatMediator.this.chatFrame.startConversation(chatFriend, messageWriter);
                                }
                            };
                        }
                        ((ChatModel)ChatMediator.this.chatModel.get()).addIncomingListener(ChatMediator.this.incomingChatListener);
                        ChatMediator.this.getChatButton().setVisible(true);
                        messageList.addListener(messageListener);
                        break;
                    }
                    case DISCONNECTED: {
                        ChatMediator.this.getChatButton().setVisible(false);
                        if (ChatMediator.this.panel != null) {
                            ChatMediator.this.setVisible(false);
                            if (ChatMediator.this.chatFrame != null) {
                                ChatMediator.this.chatFrame.closeAllChats();
                            }
                            ChatMediator.this.panel.dispose();
                        }
                        ((ChatModel)ChatMediator.this.chatModel.get()).unregisterListeners();
                        ((ChatModel)ChatMediator.this.chatModel.get()).removeIncomingListener(ChatMediator.this.incomingChatListener);
                        messageList.removeListener(messageListener);
                        ChatMediator.this.panel = null;
                    }
                }
            }
        });
        this.chatButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatMediator.this.setVisible(!ChatMediator.this.isVisible());
            }
        });
    }

    public void handleChatMessage(Message message) {
        if (message.getType() != Message.Type.SENT) {
            String messageFriendID = message.getFriendID();
            ChatFriend chatFriend = this.chatModel.get().getChatFriend(messageFriendID);
            if (!this.isVisible()) {
                chatFriend.setHasUnviewedMessages(true);
                this.unseenMessages.add(messageFriendID);
                this.setUnseenMessageCount(this.unseenMessages.size());
            } else if (chatFriend != this.chatFrame.getSelectedConversation() && this.chatFrame.getSelectedConversation() != null) {
                chatFriend.setHasUnviewedMessages(true);
            }
        }
        if (!(message.getType() == Message.Type.SENT || GuiUtils.getMainFrame().isActive() && this.isVisible())) {
            this.trayNotifier.showMessage(this.getNoticeForMessage(message));
        }
    }

    private Notification getNoticeForMessage(final Message message) {
        String title = message.getType() == Message.Type.SERVER ? I18n.tr("Message from the chat server") : I18n.tr("Chat from {0}", message.getSenderName());
        Notification notification = new Notification(title, message.toString(), new AbstractAction(I18n.tr("Reply")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationActionMap map = Application.getInstance().getContext().getActionManager().getActionMap();
                map.get("restoreView").actionPerformed(e);
                if (message.getType() != Message.Type.SERVER && message.getFriendID() != null) {
                    ChatMediator.this.startOrSelectConversation(message.getFriendID());
                } else {
                    ChatMediator.this.setVisible(true);
                }
            }
        });
        return notification;
    }

    private void setUnseenMessageCount(int count) {
        this.chatButton.setText(count > 0 ? I18n.tr("Chat ({0})", count) : I18n.tr("Chat"));
        this.chatButton.setIcon(count > 0 ? this.unviewedChatIcon : this.normalChatIcon);
    }

    public JPanel getFacebookPanel() {
        JPanel panel = new JPanel(new MigLayout("gap 10! 10!"));
        panel.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.BLACK));
        panel.add((Component)this.chatHeaderProvider.get().getComponent(), "dock north");
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        editorPane.setCaretPosition(0);
        editorPane.setSelectionColor(HTMLLabel.TRANSPARENT_COLOR);
        editorPane.setOpaque(false);
        editorPane.setFocusable(false);
        editorPane.setText("<HTML>" + ChatSettings.FACEBOOK_CHAT_DISABLED_TEXT.get() + "</HTML>");
        StyleSheet mainStyle = ((HTMLDocument)editorPane.getDocument()).getStyleSheet();
        String rules = "h1 { font-family: dialog; color:  #313131; font-size: 12; font-weight: bold}p {font-family: dialog; color: #313131; font-size: 11; }";
        StyleSheet newStyle = new StyleSheet();
        newStyle.addRule(rules);
        mainStyle.addStyleSheet(newStyle);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    NativeLaunchUtils.openURL("http://www.facebook.com");
                }
            }
        });
        panel.add(editorPane);
        return panel;
    }

    private class ChatButtonPainter
    extends AbstractPainter<JXButton> {
        @Resource
        private Color rolloverBackground = PainterUtils.TRASPARENT;
        @Resource
        private Color activeBackground = PainterUtils.TRASPARENT;
        @Resource
        private Color activeBorder = PainterUtils.TRASPARENT;
        @Resource
        private Color border = PainterUtils.TRASPARENT;

        public ChatButtonPainter() {
            GuiUtils.assignResources(this);
            this.setCacheable(false);
            this.setAntialiasing(true);
        }

        @Override
        protected void doPaint(Graphics2D g, JXButton object, int width, int height) {
            if (ChatMediator.this.panel != null && ChatMediator.this.panel.isVisible()) {
                g.setPaint(this.activeBackground);
                g.fillRect(0, 0, width, height);
                g.setPaint(this.border);
                g.drawLine(0, 0, 0, height - 1);
                g.drawLine(0, height - 1, width - 1, height - 1);
                g.drawLine(width - 1, 0, width - 1, height - 1);
                if (ChatMediator.this.chatFrame != null && ChatMediator.this.chatFrame.getSelectedConversation() != null) {
                    g.setPaint(this.activeBorder);
                    g.drawLine(0, 0, width - 2, 0);
                }
            } else if (object.getModel().isRollover()) {
                g.setPaint(this.rolloverBackground);
                g.fillRect(0, 2, width - 1, height - 2);
                g.setPaint(this.activeBorder);
                g.drawLine(0, 1, 0, height - 1);
            }
        }
    }

    private class Frame
    extends OverlayPopupPanel {
        public Frame(JLayeredPane layeredPane) {
            super(layeredPane);
            this.setLayout(new BorderLayout());
            ResizeUtils.forceSize(this, new Dimension(400, 240));
            this.setVisible(false);
            this.resize();
        }

        @Override
        public void resize() {
            Rectangle parentBounds = this.layeredPane.getBounds();
            int w = this.getPreferredSize().width;
            int h = this.getPreferredSize().height;
            this.setLocation(parentBounds.width - w, parentBounds.height - h);
        }
    }
}

