/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.util.GuiUtils;

public class LimePopupDialog {
    private final JPopupMenu popup = new JPopupMenu();
    @Resource
    private Color titleForeground;
    @Resource
    private Color titleBackground;
    @Resource
    private Font titleFont;
    @Resource
    private Icon closeIcon;
    @Resource
    private Icon closeIconRollover;
    @Resource
    private Icon closeIconPressed;

    public LimePopupDialog(String title, JComponent component) {
        GuiUtils.assignResources(this);
        JPanel mainPanel = new JPanel();
        JPanel titlePanel = new JPanel();
        titlePanel.setBackground(this.titleBackground);
        titlePanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        titlePanel.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel();
        titleLabel.setForeground(this.titleForeground);
        titleLabel.setFont(this.titleFont);
        titleLabel.setText(title);
        IconButton closeButton = new IconButton(this.closeIcon, this.closeIconRollover, this.closeIconPressed);
        closeButton.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 0));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LimePopupDialog.this.popup.setVisible(false);
            }
        });
        this.popup.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)titleLabel, "West");
        titlePanel.add((Component)closeButton, "East");
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)titlePanel, "North");
        mainPanel.add((Component)component, "Center");
        this.popup.add(mainPanel);
    }

    public void showPopup(Component invoker, int x, int y) {
        this.popup.show(invoker, x, y);
    }

    public void hidePopup() {
        this.popup.setVisible(false);
    }
}

