/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;

public class CustomHyperlinkUI
extends BasicButtonUI {
    private static final Logger LOG = Logger.getLogger(CustomHyperlinkUI.class.getName());
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    private Color focusColor;
    private View ulv;
    private PropertyChangeListener pcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CustomHyperlinkUI.this.ulv = null;
        }
    };

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
        if (b.getBorder() == null || b.getBorder() instanceof UIResource) {
            b.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        }
        this.dashedRectGapX = UIManager.getInt("ButtonUI.dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt("ButtonUI.dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt("ButtonUI.dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt("ButtonUI.dashedRectGapHeight");
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        b.setHorizontalAlignment(10);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener(this.pcListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(this.pcListener);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        CustomHyperlinkUI.viewRect.x = i.left;
        CustomHyperlinkUI.viewRect.y = i.top;
        CustomHyperlinkUI.viewRect.width = b.getWidth() - (i.right + CustomHyperlinkUI.viewRect.x);
        CustomHyperlinkUI.viewRect.height = b.getHeight() - (i.bottom + CustomHyperlinkUI.viewRect.y);
        CustomHyperlinkUI.textRect.height = 0;
        CustomHyperlinkUI.textRect.width = 0;
        CustomHyperlinkUI.textRect.y = 0;
        CustomHyperlinkUI.textRect.x = 0;
        CustomHyperlinkUI.iconRect.height = 0;
        CustomHyperlinkUI.iconRect.width = 0;
        CustomHyperlinkUI.iconRect.y = 0;
        CustomHyperlinkUI.iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                this.paintHTMLText(g, b, textRect, text, v);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintHTMLText(Graphics g, AbstractButton b, Rectangle textRect, String text, View v) {
        textRect.x += this.getTextShiftOffset();
        textRect.y += this.getTextShiftOffset();
        if (b.getModel().isRollover()) {
            if (this.ulv == null) {
                this.ulv = ULHtml.createHTMLView(b, text);
            }
            this.ulv.paint(g, textRect);
        } else {
            v.paint(g, textRect);
        }
        textRect.x -= this.getTextShiftOffset();
        textRect.y -= this.getTextShiftOffset();
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        if (!b.getModel().isEnabled()) {
            ++textRect.x;
        }
        super.paintText(g, b, textRect, text);
        if (b.getModel().isRollover()) {
            // empty if block
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        g.setColor(this.getFocusColor());
        Rectangle iconTextRect = this.getIconTextRect(b);
        BasicGraphicsUtils.drawDashedRect(g, iconTextRect.x, iconTextRect.y, iconTextRect.width, iconTextRect.height);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicHyperlinkListener(b);
    }

    protected Rectangle getIconTextRect(AbstractButton b) {
        if (b.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(b.getSize());
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        r.y -= insets.top;
        return r;
    }

    static class ULHtml
    extends BasicHTML {
        private static BasicEditorKit basicHTMLFactory;
        private static ViewFactory basicHTMLViewFactory;
        private static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }font {text-decoration: underline}";

        ULHtml() {
        }

        public static View createHTMLView(JComponent c, String html) {
            BasicEditorKit kit = ULHtml.getFactory();
            Document doc = kit.createDefaultDocument(c.getFont(), c.getForeground());
            Object base = c.getClientProperty("html.base");
            if (base instanceof URL) {
                ((HTMLDocument)doc).setBase((URL)base);
            }
            StringReader r = new StringReader(html);
            try {
                kit.read(r, doc, 0);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ViewFactory f = kit.getViewFactory();
            View hview = f.create(doc.getDefaultRootElement());
            Renderer v = new Renderer(c, f, hview);
            return v;
        }

        static BasicEditorKit getFactory() {
            if (basicHTMLFactory == null) {
                basicHTMLViewFactory = new BasicHTMLViewFactory();
                basicHTMLFactory = new BasicEditorKit();
            }
            return basicHTMLFactory;
        }

        static class Renderer
        extends View {
            private int width;
            private View view;
            private ViewFactory factory;
            private JComponent host;

            Renderer(JComponent c, ViewFactory f, View v) {
                super(null);
                this.host = c;
                this.factory = f;
                this.view = v;
                this.view.setParent(this);
                this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
            }

            @Override
            public AttributeSet getAttributes() {
                return null;
            }

            @Override
            public float getPreferredSpan(int axis) {
                if (axis == 0) {
                    return this.width;
                }
                return this.view.getPreferredSpan(axis);
            }

            @Override
            public float getMinimumSpan(int axis) {
                return this.view.getMinimumSpan(axis);
            }

            @Override
            public float getMaximumSpan(int axis) {
                return 2.1474836E9f;
            }

            @Override
            public void preferenceChanged(View child, boolean width, boolean height) {
                this.host.revalidate();
                this.host.repaint();
            }

            @Override
            public float getAlignment(int axis) {
                return this.view.getAlignment(axis);
            }

            @Override
            public void paint(Graphics g, Shape allocation) {
                Rectangle alloc = allocation.getBounds();
                this.view.setSize(alloc.width, alloc.height);
                this.view.paint(g, allocation);
            }

            @Override
            public void setParent(View parent) {
                throw new Error("Can't set parent on root view");
            }

            @Override
            public int getViewCount() {
                return 1;
            }

            @Override
            public View getView(int n) {
                return this.view;
            }

            @Override
            public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
                return this.view.modelToView(pos, a, b);
            }

            @Override
            public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
                return this.view.modelToView(p0, b0, p1, b1, a);
            }

            @Override
            public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
                return this.view.viewToModel(x, y, a, bias);
            }

            @Override
            public Document getDocument() {
                return this.view.getDocument();
            }

            @Override
            public int getStartOffset() {
                return this.view.getStartOffset();
            }

            @Override
            public int getEndOffset() {
                return this.view.getEndOffset();
            }

            @Override
            public Element getElement() {
                return this.view.getElement();
            }

            @Override
            public void setSize(float width, float height) {
                this.width = (int)width;
                this.view.setSize(width, height);
            }

            @Override
            public Container getContainer() {
                return this.host;
            }

            @Override
            public ViewFactory getViewFactory() {
                return this.factory;
            }
        }

        static class BasicDocument
        extends HTMLDocument {
            private static Class clz;
            private static Method displayPropertiesToCSS;

            private static String displayPropertiesToCSS(Font f, Color c) {
                try {
                    return (String)displayPropertiesToCSS.invoke(null, f, c);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            BasicDocument(StyleSheet s, Font defaultFont, Color foreground) {
                super(s);
                this.setPreservesUnknownTags(false);
                this.setFontAndColor(defaultFont, foreground);
            }

            private void setFontAndColor(Font font, Color fg) {
                this.getStyleSheet().addRule(BasicDocument.displayPropertiesToCSS(font, fg));
            }

            static {
                String j5 = "com.sun.java.swing.SwingUtilities2";
                String j6 = "sun.swing.SwingUtilities2";
                try {
                    clz = Class.forName(j6);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clz = Class.forName(j5);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new RuntimeException("Failed to find SwingUtilities2. Check the classpath.");
                    }
                }
                try {
                    displayPropertiesToCSS = clz.getMethod("displayPropertiesToCSS", Font.class, Color.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to use SwingUtilities2. Check the permissions and class version.");
                }
            }
        }

        static class BasicHTMLViewFactory
        extends HTMLEditorKit.HTMLFactory {
            BasicHTMLViewFactory() {
            }

            @Override
            public View create(Element elem) {
                View view = super.create(elem);
                if (view instanceof ImageView) {
                    ((ImageView)view).setLoadsSynchronously(true);
                }
                return view;
            }
        }

        static class BasicEditorKit
        extends HTMLEditorKit {
            private static StyleSheet defaultStyles;

            BasicEditorKit() {
            }

            @Override
            public StyleSheet getStyleSheet() {
                if (defaultStyles == null) {
                    defaultStyles = new StyleSheet();
                    StringReader r = new StringReader(ULHtml.styleChanges);
                    try {
                        defaultStyles.loadRules(r, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    r.close();
                    defaultStyles.addStyleSheet(super.getStyleSheet());
                }
                return defaultStyles;
            }

            public Document createDefaultDocument(Font defaultFont, Color foreground) {
                StyleSheet styles = this.getStyleSheet();
                StyleSheet ss = new StyleSheet();
                ss.addStyleSheet(styles);
                BasicDocument doc = new BasicDocument(ss, defaultFont, foreground);
                doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                doc.setPreservesUnknownTags(false);
                return doc;
            }

            @Override
            public ViewFactory getViewFactory() {
                return basicHTMLViewFactory;
            }
        }
    }

    public static class BasicHyperlinkListener
    extends BasicButtonListener {
        public BasicHyperlinkListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (button.isRolloverEnabled()) {
                button.setCursor(button.getModel().isRollover() ? Cursor.getPredefinedCursor(12) : null);
            }
            super.stateChanged(e);
        }
    }
}

