/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class CountingOutputStream
extends FilterOutputStream {
    private int _count = 0;
    private boolean _isCounting = true;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (this._isCounting) {
            ++this._count;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this._isCounting) {
            this._count += len;
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public int getAmountWritten() {
        return this._count;
    }

    public void setIsCounting(boolean count) {
        this._isCounting = count;
    }
}

