/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.inspections;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.core.impl.inspections.InspectionDataContainer;
import org.limewire.core.impl.inspections.InspectionsSpec;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.util.BEncoder;

public class InspectionsParser {
    public List<InspectionsSpec> parseInspectionSpecs(byte[] rawInspectionSpecs) throws IOException, InvalidDataException {
        ByteArrayInputStream bais = new ByteArrayInputStream(rawInspectionSpecs);
        GZIPInputStream gzip = new GZIPInputStream(bais);
        ReadableByteChannel rbc = Channels.newChannel(gzip);
        ArrayList<InspectionsSpec> specs = new ArrayList<InspectionsSpec>();
        List inspSpecs = (List)Token.parse(rbc, "UTF-8");
        for (Object inspSpec : inspSpecs) {
            specs.add(new InspectionsSpec(inspSpec));
        }
        return specs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] inspectionResultToByteArray(InspectionDataContainer insps) throws IOException {
        Map<String, Object> bencodedMap = insps.asBencodedMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream dos = null;
        try {
            dos = new GZIPOutputStream(baos);
            try {
                BEncoder.getEncoder(dos, false, true, "UTF-8").encodeDict(bencodedMap);
            }
            catch (Throwable bencoding) {
                String msg = bencoding.toString();
                String ret = "d5:error" + msg.length() + ":" + msg + "e";
                dos.write(ret.getBytes("UTF-8"));
            }
            dos.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(dos);
            throw throwable;
        }
        IOUtils.close(dos);
        return baos.toByteArray();
    }
}

