/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;

public class SimpleFuture<T>
implements ListeningFuture<T> {
    private final T t;
    private final ExecutionException exception;
    private final EventListenerList.EventListenerListContext context = new EventListenerList.EventListenerListContext();

    public SimpleFuture(T t) {
        this.t = t;
        this.exception = null;
    }

    public SimpleFuture(Throwable throwable) {
        this.t = null;
        this.exception = new ExecutionException(throwable);
    }

    public SimpleFuture(ExecutionException ee) {
        this.t = null;
        this.exception = ee;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public T get() throws ExecutionException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.t;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.t;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public void addFutureListener(EventListener<FutureEvent<T>> listener) {
        EventListenerList.dispatch(listener, FutureEvent.createEvent(this), this.context);
    }
}

